/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta;

import io.sentry.IHub;
import io.sentry.protocol.Request;
import io.sentry.util.HttpUtils;
import io.sentry.util.Objects;
import io.sentry.util.UrlUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryRequestResolver {
    @NotNull
    private final IHub hub;

    public SentryRequestResolver(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"options is required");
    }

    @NotNull
    public Request resolveSentryRequest(@NotNull HttpServletRequest httpRequest) {
        Request sentryRequest = new Request();
        sentryRequest.setMethod(httpRequest.getMethod());
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)httpRequest.getRequestURL().toString());
        urlDetails.applyToRequest(sentryRequest);
        sentryRequest.setQueryString(httpRequest.getQueryString());
        sentryRequest.setHeaders(this.resolveHeadersMap(httpRequest));
        if (this.hub.getOptions().isSendDefaultPii()) {
            sentryRequest.setCookies(SentryRequestResolver.toString(httpRequest.getHeaders("Cookie")));
        }
        return sentryRequest;
    }

    @NotNull
    Map<String, String> resolveHeadersMap(@NotNull HttpServletRequest request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (!this.hub.getOptions().isSendDefaultPii() && HttpUtils.containsSensitiveHeader((String)headerName)) continue;
            headersMap.put(headerName, SentryRequestResolver.toString(request.getHeaders(headerName)));
        }
        return headersMap;
    }

    @Nullable
    private static String toString(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? String.join((CharSequence)",", Collections.list(enumeration)) : null;
    }
}

