/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.jakarta.tracing;

import io.sentry.IHub;
import io.sentry.ITransaction;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.spring.jakarta.tracing.SentryTransaction;
import io.sentry.util.Objects;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

@ApiStatus.Internal
public class SentryTransactionAdvice
implements MethodInterceptor {
    @NotNull
    private final IHub hub;

    public SentryTransactionAdvice(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    public Object invoke(@NotNull MethodInvocation invocation) throws Throwable {
        Method mostSpecificMethod = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), invocation.getThis().getClass());
        @Nullable SentryTransaction sentryTransaction = (SentryTransaction)AnnotationUtils.findAnnotation((Method)mostSpecificMethod, SentryTransaction.class);
        if (sentryTransaction == null) {
            sentryTransaction = (SentryTransaction)AnnotationUtils.findAnnotation(mostSpecificMethod.getDeclaringClass(), SentryTransaction.class);
        }
        TransactionNameAndSource nameAndSource = this.resolveTransactionName(invocation, sentryTransaction);
        boolean isTransactionActive = this.isTransactionActive();
        if (isTransactionActive) {
            return invocation.proceed();
        }
        String operation = sentryTransaction != null && !StringUtils.isEmpty((Object)sentryTransaction.operation()) ? sentryTransaction.operation() : "bean";
        this.hub.pushScope();
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setBindToScope(true);
        ITransaction transaction = this.hub.startTransaction(new TransactionContext(nameAndSource.name, nameAndSource.source, operation), transactionOptions);
        try {
            Object result = invocation.proceed();
            transaction.setStatus(SpanStatus.OK);
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            transaction.setStatus(SpanStatus.INTERNAL_ERROR);
            transaction.setThrowable(e);
            throw e;
        }
        finally {
            transaction.finish();
            this.hub.popScope();
        }
    }

    @NotNull
    private TransactionNameAndSource resolveTransactionName(MethodInvocation invocation, @Nullable SentryTransaction sentryTransaction) {
        if (sentryTransaction == null || StringUtils.isEmpty((Object)sentryTransaction.value())) {
            String name = invocation.getMethod().getDeclaringClass().getSimpleName() + "." + invocation.getMethod().getName();
            return new TransactionNameAndSource(name, TransactionNameSource.COMPONENT);
        }
        return new TransactionNameAndSource(sentryTransaction.value(), TransactionNameSource.CUSTOM);
    }

    private boolean isTransactionActive() {
        return this.hub.getSpan() != null;
    }

    private static class TransactionNameAndSource {
        @NotNull
        private final String name;
        @NotNull
        private final TransactionNameSource source;

        public TransactionNameAndSource(@NotNull String name, @NotNull TransactionNameSource source) {
            this.name = name;
            this.source = source;
        }
    }
}

