/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot;

import io.sentry.IHub;
import io.sentry.spring.webflux.SentryScheduleHook;
import io.sentry.spring.webflux.SentryWebExceptionHandler;
import io.sentry.spring.webflux.SentryWebFilter;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import reactor.core.scheduler.Schedulers;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnBean(value={IHub.class})
@ConditionalOnClass(value={Schedulers.class})
@ApiStatus.Experimental
public class SentryWebfluxAutoConfiguration {
    private static final int SENTRY_SPRING_FILTER_PRECEDENCE = Integer.MIN_VALUE;

    @Bean
    @NotNull
    public ApplicationRunner sentryScheduleHookApplicationRunner() {
        return args -> Schedulers.onScheduleHook((String)"sentry", (Function)new SentryScheduleHook());
    }

    @Bean
    @Order(value=-2147483648)
    @NotNull
    public SentryWebFilter sentryWebFilter(@NotNull IHub hub) {
        return new SentryWebFilter(hub);
    }

    @Bean
    @NotNull
    public SentryWebExceptionHandler sentryWebExceptionHandler(@NotNull IHub hub) {
        return new SentryWebExceptionHandler(hub);
    }
}

