/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.spring.boot.graphql;

import graphql.execution.instrumentation.Instrumentation;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.graphql.SentryInstrumentation;
import io.sentry.graphql.SentrySubscriptionHandler;
import io.sentry.spring.boot.SentryProperties;
import io.sentry.spring.graphql.SentryDataFetcherExceptionResolverAdapter;
import io.sentry.spring.graphql.SentryGraphqlBeanPostProcessor;
import io.sentry.spring.graphql.SentrySpringSubscriptionHandler;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration(proxyBeanMethods=false)
public class SentryGraphqlAutoConfiguration {
    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public GraphQlSourceBuilderCustomizer sourceBuilderCustomizerWebmvc(@NotNull SentryProperties sentryProperties) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring5GrahQLWebMVC");
        return this.sourceBuilderCustomizer(sentryProperties, false);
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public GraphQlSourceBuilderCustomizer sourceBuilderCustomizerWebflux(@NotNull SentryProperties sentryProperties) {
        SentryIntegrationPackageStorage.getInstance().addIntegration("Spring5GrahQLWebFlux");
        return this.sourceBuilderCustomizer(sentryProperties, true);
    }

    private GraphQlSourceBuilderCustomizer sourceBuilderCustomizer(@NotNull SentryProperties sentryProperties, boolean captureRequestBody) {
        return builder -> builder.configureGraphQl(graphQlBuilder -> graphQlBuilder.instrumentation((Instrumentation)new SentryInstrumentation(null, (SentrySubscriptionHandler)new SentrySpringSubscriptionHandler(), captureRequestBody, sentryProperties.getGraphql().getIgnoredErrorTypes())));
    }

    @Bean
    @Order(value=-2147483648)
    public SentryDataFetcherExceptionResolverAdapter exceptionResolverAdapter() {
        return new SentryDataFetcherExceptionResolverAdapter();
    }

    @Bean
    public static SentryGraphqlBeanPostProcessor graphqlBeanPostProcessor() {
        return new SentryGraphqlBeanPostProcessor();
    }
}

