/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.servlet.jakarta;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.protocol.Request;
import io.sentry.util.HttpUtils;
import io.sentry.util.Objects;
import io.sentry.util.UrlUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SentryRequestHttpServletRequestProcessor
implements EventProcessor {
    @NotNull
    private final HttpServletRequest httpRequest;

    public SentryRequestHttpServletRequestProcessor(@NotNull HttpServletRequest httpRequest) {
        this.httpRequest = (HttpServletRequest)Objects.requireNonNull((Object)httpRequest, (String)"httpRequest is required");
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        Request sentryRequest = new Request();
        sentryRequest.setMethod(this.httpRequest.getMethod());
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)this.httpRequest.getRequestURL().toString());
        urlDetails.applyToRequest(sentryRequest);
        sentryRequest.setQueryString(this.httpRequest.getQueryString());
        sentryRequest.setHeaders(this.resolveHeadersMap(this.httpRequest));
        event.setRequest(sentryRequest);
        return event;
    }

    @NotNull
    private Map<String, String> resolveHeadersMap(@NotNull HttpServletRequest request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (HttpUtils.containsSensitiveHeader((String)headerName.toUpperCase(Locale.ROOT))) continue;
            headersMap.put(headerName, SentryRequestHttpServletRequestProcessor.toString(request.getHeaders(headerName)));
        }
        return headersMap;
    }

    @Nullable
    private static String toString(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? String.join((CharSequence)",", Collections.list(enumeration)) : null;
    }
}

