/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.servlet.jakarta;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.protocol.Request;
import io.sentry.util.Objects;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SentryRequestHttpServletRequestProcessor
implements EventProcessor {
    private static final List<String> SENSITIVE_HEADERS = Arrays.asList("X-FORWARDED-FOR", "AUTHORIZATION", "COOKIE");
    @NotNull
    private final HttpServletRequest httpRequest;

    public SentryRequestHttpServletRequestProcessor(@NotNull HttpServletRequest httpRequest) {
        this.httpRequest = (HttpServletRequest)Objects.requireNonNull((Object)httpRequest, (String)"httpRequest is required");
    }

    @NotNull
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        Request sentryRequest = new Request();
        sentryRequest.setMethod(this.httpRequest.getMethod());
        sentryRequest.setQueryString(this.httpRequest.getQueryString());
        sentryRequest.setUrl(this.httpRequest.getRequestURL().toString());
        sentryRequest.setHeaders(this.resolveHeadersMap(this.httpRequest));
        event.setRequest(sentryRequest);
        return event;
    }

    @NotNull
    private Map<String, String> resolveHeadersMap(@NotNull HttpServletRequest request) {
        HashMap<String, String> headersMap = new HashMap<String, String>();
        for (String headerName : Collections.list(request.getHeaderNames())) {
            if (SENSITIVE_HEADERS.contains(headerName.toUpperCase(Locale.ROOT))) continue;
            headersMap.put(headerName, SentryRequestHttpServletRequestProcessor.toString(request.getHeaders(headerName)));
        }
        return headersMap;
    }

    @Nullable
    private static String toString(@Nullable Enumeration<String> enumeration) {
        return enumeration != null ? String.join((CharSequence)",", Collections.list(enumeration)) : null;
    }
}

