/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.servlet.jakarta;

import io.sentry.Breadcrumb;
import io.sentry.EventProcessor;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.servlet.jakarta.SentryRequestHttpServletRequestProcessor;
import io.sentry.util.Objects;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;

public class SentryServletRequestListener
implements ServletRequestListener {
    private final IHub hub;

    public SentryServletRequestListener(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
    }

    public SentryServletRequestListener() {
        this((IHub)HubAdapter.getInstance());
    }

    public void requestDestroyed(@NotNull ServletRequestEvent servletRequestEvent) {
        this.hub.popScope();
    }

    public void requestInitialized(@NotNull ServletRequestEvent servletRequestEvent) {
        this.hub.pushScope();
        ServletRequest servletRequest = servletRequestEvent.getServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
            HashMap<String, HttpServletRequest> hintMap = new HashMap<String, HttpServletRequest>();
            hintMap.put("servlet:request", httpRequest);
            this.hub.addBreadcrumb(Breadcrumb.http((String)httpRequest.getRequestURI(), (String)httpRequest.getMethod()), hintMap);
            this.hub.configureScope(scope -> scope.addEventProcessor((EventProcessor)new SentryRequestHttpServletRequestProcessor(httpRequest)));
        }
    }
}

