/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.okhttp;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HttpStatusCodeRange;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.ISpan;
import io.sentry.ScopesAdapter;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SpanStatus;
import io.sentry.W3CTraceparentHeader;
import io.sentry.okhttp.SentryOkHttpEvent;
import io.sentry.okhttp.SentryOkHttpEventListener;
import io.sentry.okhttp.SentryOkHttpInterceptor;
import io.sentry.okhttp.SentryOkHttpUtils;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Platform;
import io.sentry.util.PropagationTargetsUtils;
import io.sentry.util.SpanUtils;
import io.sentry.util.TracingUtils;
import io.sentry.util.UrlUtils;
import io.sentry.util.network.NetworkBody;
import io.sentry.util.network.NetworkBodyParser;
import io.sentry.util.network.NetworkDetailCaptureUtils;
import io.sentry.util.network.NetworkRequestData;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 <2\u00020\u0001:\u0002;<B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bBE\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J6\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\nH\u0002J&\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J;\u0010+\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010,\u001a\u0004\u0018\u00010\u00132\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u00103\u001a\u0004\u0018\u00010$*\u00020\u001b2\u0006\u0010)\u001a\u00020*H\u0002J'\u00104\u001a\u00020\u0015*\u0004\u0018\u00010.2\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020\u001506H\u0002\u00a2\u0006\u0002\u00107J\u0018\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f09*\u00020:H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lio/sentry/okhttp/SentryOkHttpInterceptor;", "Lokhttp3/Interceptor;", "()V", "scopes", "Lio/sentry/IScopes;", "(Lio/sentry/IScopes;)V", "beforeSpan", "Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "(Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;)V", "captureFailedRequests", "", "failedRequestStatusCodes", "", "Lio/sentry/HttpStatusCodeRange;", "failedRequestTargets", "", "(Lio/sentry/IScopes;Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;ZLjava/util/List;Ljava/util/List;)V", "containsStatusCode", "statusCode", "", "finishSpan", "", "span", "Lio/sentry/ISpan;", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "isFromEventListener", "okHttpEvent", "Lio/sentry/okhttp/SentryOkHttpEvent;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "isIgnored", "safeExtractRequestBody", "Lio/sentry/util/network/NetworkBody;", "bufferedBody", "", "contentType", "Lokhttp3/MediaType;", "logger", "Lio/sentry/ILogger;", "sendBreadcrumb", "code", "startTimestamp", "", "networkDetailData", "Lio/sentry/util/network/NetworkRequestData;", "(Lokhttp3/Request;Ljava/lang/Integer;Lokhttp3/Response;JLio/sentry/util/network/NetworkRequestData;)V", "shouldCaptureClientError", "extractResponseBody", "ifHasValidLength", "fn", "Lkotlin/Function1;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "toMap", "", "Lokhttp3/Headers;", "BeforeSpanCallback", "Companion", "sentry-okhttp"})
@SourceDebugExtension(value={"SMAP\nSentryOkHttpInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryOkHttpInterceptor.kt\nio/sentry/okhttp/SentryOkHttpInterceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,413:1\n1#2:414\n*E\n"})
public class SentryOkHttpInterceptor
implements Interceptor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final IScopes scopes;
    @Nullable
    private final BeforeSpanCallback beforeSpan;
    private final boolean captureFailedRequests;
    @NotNull
    private final List<HttpStatusCodeRange> failedRequestStatusCodes;
    @NotNull
    private final List<String> failedRequestTargets;
    @NotNull
    private static final Companion.FAKE_OPTIONS.1 FAKE_OPTIONS;

    public SentryOkHttpInterceptor(@NotNull IScopes scopes, @Nullable BeforeSpanCallback beforeSpan, boolean captureFailedRequests, @NotNull List<HttpStatusCodeRange> failedRequestStatusCodes, @NotNull List<String> failedRequestTargets) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter(failedRequestStatusCodes, (String)"failedRequestStatusCodes");
        Intrinsics.checkNotNullParameter(failedRequestTargets, (String)"failedRequestTargets");
        this.scopes = scopes;
        this.beforeSpan = beforeSpan;
        this.captureFailedRequests = captureFailedRequests;
        this.failedRequestStatusCodes = failedRequestStatusCodes;
        this.failedRequestTargets = failedRequestTargets;
        IntegrationUtils.addIntegrationToSdkVersion((String)"OkHttp");
    }

    public /* synthetic */ SentryOkHttpInterceptor(IScopes iScopes, BeforeSpanCallback beforeSpanCallback, boolean bl, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ScopesAdapter scopesAdapter = ScopesAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)scopesAdapter, (String)"getInstance(...)");
            iScopes = (IScopes)scopesAdapter;
        }
        if ((n & 2) != 0) {
            beforeSpanCallback = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)new HttpStatusCodeRange(500, 599));
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.listOf((Object)".*");
        }
        this(iScopes, beforeSpanCallback, bl, list, list2);
    }

    public SentryOkHttpInterceptor() {
        ScopesAdapter scopesAdapter = ScopesAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scopesAdapter, (String)"getInstance(...)");
        this((IScopes)scopesAdapter);
    }

    public SentryOkHttpInterceptor(@NotNull IScopes scopes) {
        Intrinsics.checkNotNullParameter((Object)scopes, (String)"scopes");
        this(scopes, null, false, null, null, 28, null);
    }

    public SentryOkHttpInterceptor(@NotNull BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)beforeSpan, (String)"beforeSpan");
        ScopesAdapter scopesAdapter = ScopesAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scopesAdapter, (String)"getInstance(...)");
        this((IScopes)scopesAdapter, beforeSpan, false, null, null, 28, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        SentryOkHttpEvent sentryOkHttpEvent;
        Response response;
        BaggageHeader it;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Ref.ObjectRef request = new Ref.ObjectRef();
        request.element = chain.request();
        UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)((Request)request.element).url().toString());
        Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(...)");
        UrlUtils.UrlDetails urlDetails2 = urlDetails;
        String string = urlDetails2.getUrlOrFallback();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlOrFallback(...)");
        String url = string;
        String method = ((Request)request.element).method();
        ISpan span = null;
        SentryOkHttpEvent okHttpEvent = null;
        if (SentryOkHttpEventListener.Companion.getEventMap$sentry_okhttp().containsKey(chain.call())) {
            SentryOkHttpEvent sentryOkHttpEvent2 = okHttpEvent = SentryOkHttpEventListener.Companion.getEventMap$sentry_okhttp().get(chain.call());
            span = sentryOkHttpEvent2 != null ? sentryOkHttpEvent2.getCallSpan$sentry_okhttp() : null;
        } else {
            ISpan parentSpan;
            okHttpEvent = null;
            ISpan iSpan = parentSpan = Platform.isAndroid() ? (ISpan)this.scopes.getTransaction() : this.scopes.getSpan();
            span = iSpan != null ? iSpan.startChild("http.client", method + ' ' + url) : null;
        }
        long startTimestamp = CurrentDateProvider.getInstance().getCurrentTimeMillis();
        ISpan iSpan = span;
        Object object = iSpan != null ? iSpan.getSpanContext() : null;
        if (object != null) {
            object.setOrigin("auto.http.okhttp");
        }
        urlDetails2.applyToSpan(span);
        boolean isFromEventListener = okHttpEvent != null;
        Response response2 = null;
        Integer code = null;
        NetworkRequestData networkDetailData = NetworkDetailCaptureUtils.initializeForUrl((String)((Request)request.element).url().toString(), (String)((Request)request.element).method(), (String[])FAKE_OPTIONS.getNetworkDetailAllowUrls(), (String[])FAKE_OPTIONS.getNetworkDetailDenyUrls());
        try {
            TracingUtils.TracingHeaders tracingHeaders;
            Request.Builder requestBuilder = ((Request)request.element).newBuilder();
            if (!this.isIgnored() && (tracingHeaders = TracingUtils.traceIfAllowed((IScopes)this.scopes, (String)((Request)request.element).url().toString(), (List)((Request)request.element).headers("baggage"), (ISpan)span)) != null) {
                TracingUtils.TracingHeaders tracingHeaders2 = tracingHeaders;
                boolean bl = false;
                String string2 = tracingHeaders2.getSentryTraceHeader().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                String string3 = tracingHeaders2.getSentryTraceHeader().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
                requestBuilder.addHeader(string2, string3);
                BaggageHeader baggageHeader = tracingHeaders2.getBaggageHeader();
                if (baggageHeader != null) {
                    it = baggageHeader;
                    boolean bl2 = false;
                    requestBuilder.removeHeader("baggage");
                    String string4 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    String string5 = it.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
                    requestBuilder.addHeader(string4, string5);
                }
                W3CTraceparentHeader w3CTraceparentHeader = tracingHeaders2.getW3cTraceparentHeader();
                if (w3CTraceparentHeader != null) {
                    it = w3CTraceparentHeader;
                    boolean bl3 = false;
                    String string6 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                    String string7 = it.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
                    requestBuilder.addHeader(string6, string7);
                }
            }
            RequestBody requestBody = ((Request)request.element).body();
            Long requestContentLength = requestBody != null ? Long.valueOf(requestBody.contentLength()) : null;
            NetworkRequestData networkRequestData = networkDetailData;
            if (networkRequestData != null) {
                networkRequestData.setRequestDetails(NetworkDetailCaptureUtils.createRequest((Object)request.element, (Long)requestContentLength, (boolean)FAKE_OPTIONS.getNetworkCaptureBodies(), arg_0 -> SentryOkHttpInterceptor.intercept$lambda$4(requestBuilder, request, this, arg_0), (String[])FAKE_OPTIONS.getNetworkRequestHeaders(), arg_0 -> SentryOkHttpInterceptor.intercept$lambda$5(this, arg_0)));
            }
            request.element = requestBuilder.build();
            response2 = chain.proceed((Request)request.element);
            code = response2.code();
            ISpan iSpan2 = span;
            if (iSpan2 != null) {
                iSpan2.setData("http.response.status_code", (Object)code);
            }
            ISpan iSpan3 = span;
            if (iSpan3 != null) {
                iSpan3.setStatus(SpanStatus.fromHttpStatusCode((int)code));
            }
            if (this.shouldCaptureClientError((Request)request.element, response2)) {
                if (isFromEventListener && okHttpEvent != null) {
                    okHttpEvent.setClientErrorResponse(response2);
                } else {
                    SentryOkHttpUtils.INSTANCE.captureClientError$sentry_okhttp(this.scopes, (Request)request.element, response2);
                }
            }
            response = response2;
            sentryOkHttpEvent = okHttpEvent;
        }
        catch (IOException e) {
            try {
                ISpan iSpan4 = span;
                if (iSpan4 != null) {
                    ISpan iSpan5;
                    ISpan $this$intercept_u24lambda_u246 = iSpan5 = iSpan4;
                    boolean bl = false;
                    $this$intercept_u24lambda_u246.setThrowable((Throwable)e);
                    $this$intercept_u24lambda_u246.setStatus(SpanStatus.INTERNAL_ERROR);
                }
                throw e;
            }
            catch (Throwable throwable) {
                SentryOkHttpEvent sentryOkHttpEvent3 = okHttpEvent;
                if (sentryOkHttpEvent3 != null) {
                    sentryOkHttpEvent3.setRequest((Request)request.element);
                }
                Response response3 = response2;
                if (response3 != null) {
                    Response it2 = response3;
                    boolean bl = false;
                    NetworkRequestData networkRequestData = networkDetailData;
                    if (networkRequestData != null) {
                        ResponseBody responseBody = it2.body();
                        networkRequestData.setResponseDetails(it2.code(), NetworkDetailCaptureUtils.createResponse((Object)it2, (Long)(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null), (boolean)FAKE_OPTIONS.getNetworkCaptureBodies(), arg_0 -> SentryOkHttpInterceptor.intercept$lambda$9$lambda$7(this, arg_0), (String[])FAKE_OPTIONS.getNetworkResponseHeaders(), arg_0 -> SentryOkHttpInterceptor.intercept$lambda$9$lambda$8(this, arg_0)));
                    }
                }
                this.finishSpan(span, (Request)request.element, response2, isFromEventListener, okHttpEvent);
                if (!isFromEventListener) {
                    this.sendBreadcrumb((Request)request.element, code, response2, startTimestamp, networkDetailData);
                }
                throw throwable;
            }
        }
        if (sentryOkHttpEvent != null) {
            sentryOkHttpEvent.setRequest((Request)request.element);
        }
        Response response4 = response2;
        if (response4 != null) {
            it = response4;
            boolean bl = false;
            NetworkRequestData networkRequestData = networkDetailData;
            if (networkRequestData != null) {
                ResponseBody responseBody = it.body();
                networkRequestData.setResponseDetails(it.code(), NetworkDetailCaptureUtils.createResponse((Object)it, (Long)(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null), (boolean)FAKE_OPTIONS.getNetworkCaptureBodies(), arg_0 -> SentryOkHttpInterceptor.intercept$lambda$9$lambda$7(this, arg_0), (String[])FAKE_OPTIONS.getNetworkResponseHeaders(), arg_0 -> SentryOkHttpInterceptor.intercept$lambda$9$lambda$8(this, arg_0)));
            }
        }
        this.finishSpan(span, (Request)request.element, response2, isFromEventListener, okHttpEvent);
        if (!isFromEventListener) {
            this.sendBreadcrumb((Request)request.element, code, response2, startTimestamp, networkDetailData);
        }
        return response;
    }

    private final boolean isIgnored() {
        return SpanUtils.isIgnored((List)this.scopes.getOptions().getIgnoredSpanOrigins(), (String)"auto.http.okhttp");
    }

    private final void sendBreadcrumb(Request request, Integer code, Response response, long startTimestamp, NetworkRequestData networkDetailData) {
        Hint hint;
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.url().toString(), (String)request.method(), (Integer)code);
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"http(...)");
        Breadcrumb breadcrumb2 = breadcrumb;
        RequestBody requestBody = request.body();
        this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
            final /* synthetic */ Breadcrumb $breadcrumb;
            {
                this.$breadcrumb = $breadcrumb;
                super(1);
            }

            public final void invoke(long it) {
                this.$breadcrumb.setData("http.request_content_length", (Object)it);
            }
        }));
        Response response2 = response;
        this.ifHasValidLength(response2 != null && (response2 = response2.body()) != null ? Long.valueOf(response2.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
            final /* synthetic */ Breadcrumb $breadcrumb;
            {
                this.$breadcrumb = $breadcrumb;
                super(1);
            }

            public final void invoke(long it) {
                this.$breadcrumb.setData("http.response_content_length", (Object)it);
            }
        }));
        Hint it = hint = new Hint();
        boolean bl = false;
        it.set("okHttp:request", (Object)request);
        Response response3 = response;
        if (response3 != null) {
            Response resp = response3;
            boolean bl2 = false;
            it.set("okHttp:response", (Object)resp);
        }
        if (networkDetailData != null) {
            it.set("sentry:replayNetworkDetails", (Object)networkDetailData);
        }
        Hint hint2 = hint;
        breadcrumb2.setData("http.start_timestamp", (Object)startTimestamp);
        breadcrumb2.setData("http.end_timestamp", (Object)CurrentDateProvider.getInstance().getCurrentTimeMillis());
        this.scopes.addBreadcrumb(breadcrumb2, hint2);
    }

    private final Map<String, String> toMap(Headers $this$toMap) {
        LinkedHashMap headers = new LinkedHashMap();
        int n = $this$toMap.size();
        for (int i = 0; i < n; ++i) {
            ((Map)headers).put($this$toMap.name(i), $this$toMap.value(i));
        }
        return headers;
    }

    private final NetworkBody safeExtractRequestBody(byte[] bufferedBody, MediaType contentType, ILogger logger) {
        if (bufferedBody == null) {
            return null;
        }
        try {
            String string;
            MediaType mediaType = contentType;
            String contentTypeString = mediaType != null ? mediaType.toString() : null;
            int maxBodySize = 153600;
            Object object = contentType;
            if ((object != null && (object = object.charset(Charsets.UTF_8)) != null ? ((Charset)object).name() : (string = null)) == null) {
                string = "UTF-8";
            }
            String charset = string;
            return NetworkBodyParser.fromBytes((byte[])bufferedBody, (String)contentTypeString, (String)charset, (int)maxBodySize, (ILogger)logger);
        }
        catch (Exception e) {
            logger.log(SentryLevel.ERROR, "Failed to parse buffered request body: " + e.getMessage(), new Object[0]);
            return null;
        }
    }

    private final NetworkBody extractResponseBody(Response $this$extractResponseBody, ILogger logger) {
        Object v5;
        ResponseBody responseBody = $this$extractResponseBody.body();
        if (responseBody != null) {
            ResponseBody responseBody2 = responseBody;
            boolean bl = false;
            try {
                String string;
                String string2;
                MediaType contentType;
                MediaType mediaType = contentType = responseBody2.contentType();
                String contentTypeString = mediaType != null ? mediaType.toString() : null;
                int maxBodySize = 153600;
                long contentLength = responseBody2.contentLength();
                if (contentLength > (long)(maxBodySize * 2)) {
                    return NetworkBody.fromString((String)("[Response body too large: " + contentLength + " bytes]"));
                }
                ResponseBody peekBody = $this$extractResponseBody.peekBody((long)maxBodySize);
                byte[] bodyBytes = peekBody.bytes();
                Object object = contentType;
                String string3 = string2 = object != null && (object = object.charset(Charsets.UTF_8)) != null ? ((Charset)object).name() : null;
                if (string3 == null) {
                    string = "UTF-8";
                } else {
                    Intrinsics.checkNotNull((Object)string3);
                    string = string2;
                }
                String charset = string;
                return NetworkBodyParser.fromBytes((byte[])bodyBytes, (String)contentTypeString, (String)charset, (int)maxBodySize, (ILogger)logger);
            }
            catch (Exception e) {
                logger.log(SentryLevel.ERROR, "Failed to read http response body for Network Details: " + e.getMessage(), new Object[0]);
                v5 = null;
            }
        } else {
            v5 = null;
        }
        return v5;
    }

    private final void finishSpan(ISpan span, Request request, Response response, boolean isFromEventListener, SentryOkHttpEvent okHttpEvent) {
        block4: {
            ISpan result;
            if (span == null) {
                SentryOkHttpEvent sentryOkHttpEvent = okHttpEvent;
                if (sentryOkHttpEvent != null) {
                    SentryOkHttpEvent.finish$default(sentryOkHttpEvent, null, 1, null);
                }
                return;
            }
            if (this.beforeSpan != null && (result = this.beforeSpan.execute(span, request, response)) == null) {
                span.getSpanContext().setSampled(Boolean.valueOf(false));
            }
            if (!isFromEventListener) {
                span.finish();
            }
            SentryOkHttpEvent sentryOkHttpEvent = okHttpEvent;
            if (sentryOkHttpEvent == null) break block4;
            SentryOkHttpEvent.finish$default(sentryOkHttpEvent, null, 1, null);
        }
    }

    private final void ifHasValidLength(Long $this$ifHasValidLength, Function1<? super Long, Unit> fn) {
        if ($this$ifHasValidLength != null) {
            long l = -1L;
            if ($this$ifHasValidLength != l) {
                fn.invoke((Object)$this$ifHasValidLength);
            }
        }
    }

    private final boolean shouldCaptureClientError(Request request, Response response) {
        if (!this.captureFailedRequests || !this.containsStatusCode(response.code())) {
            return false;
        }
        return PropagationTargetsUtils.contain(this.failedRequestTargets, (String)request.url().toString());
    }

    private final boolean containsStatusCode(int statusCode) {
        for (HttpStatusCodeRange item : this.failedRequestStatusCodes) {
            if (!item.isInRange(statusCode)) continue;
            return true;
        }
        return false;
    }

    private static final NetworkBody intercept$lambda$4(Request.Builder $requestBuilder, Ref.ObjectRef $request, SentryOkHttpInterceptor this$0, Request req) {
        NetworkBody networkBody;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        RequestBody requestBody = req.body();
        if (requestBody != null) {
            RequestBody originalBody = requestBody;
            boolean bl = false;
            Buffer buffer = new Buffer();
            originalBody.writeTo((BufferedSink)buffer);
            byte[] bodyBytes = buffer.readByteArray();
            RequestBody newRequestBody = RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])bodyBytes, (MediaType)originalBody.contentType(), (int)0, (int)0, (int)6, null);
            $requestBuilder.method(((Request)$request.element).method(), newRequestBody);
            MediaType mediaType = originalBody.contentType();
            ILogger iLogger = this$0.scopes.getOptions().getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)iLogger, (String)"getLogger(...)");
            networkBody = this$0.safeExtractRequestBody(bodyBytes, mediaType, iLogger);
        } else {
            networkBody = null;
        }
        return networkBody;
    }

    private static final Map intercept$lambda$5(SentryOkHttpInterceptor this$0, Request req) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        return this$0.toMap(req.headers());
    }

    private static final NetworkBody intercept$lambda$9$lambda$7(SentryOkHttpInterceptor this$0, Response resp) {
        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
        ILogger iLogger = this$0.scopes.getOptions().getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)iLogger, (String)"getLogger(...)");
        return this$0.extractResponseBody(resp, iLogger);
    }

    private static final Map intercept$lambda$9$lambda$8(SentryOkHttpInterceptor this$0, Response resp) {
        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
        return this$0.toMap(resp.headers());
    }

    static {
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-okhttp", "8.26.0");
        FAKE_OPTIONS = new Object(){
            private final String[] networkDetailAllowUrls;
            private final String[] networkDetailDenyUrls;
            private final boolean networkCaptureBodies;
            private final String[] networkRequestHeaders;
            private final String[] networkResponseHeaders;
            {
                this.networkDetailAllowUrls = new String[0];
                this.networkDetailDenyUrls = new String[0];
                this.networkRequestHeaders = new String[0];
                this.networkResponseHeaders = new String[0];
            }

            public final String[] getNetworkDetailAllowUrls() {
                return this.networkDetailAllowUrls;
            }

            public final String[] getNetworkDetailDenyUrls() {
                return this.networkDetailDenyUrls;
            }

            public final boolean getNetworkCaptureBodies() {
                return this.networkCaptureBodies;
            }

            public final String[] getNetworkRequestHeaders() {
                return this.networkRequestHeaders;
            }

            public final String[] getNetworkResponseHeaders() {
                return this.networkResponseHeaders;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lio/sentry/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "", "execute", "Lio/sentry/ISpan;", "span", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "sentry-okhttp"})
    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull Request var2, @Nullable Response var3);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003*\u0001\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/sentry/okhttp/SentryOkHttpInterceptor$Companion;", "", "()V", "FAKE_OPTIONS", "io/sentry/okhttp/SentryOkHttpInterceptor$Companion$FAKE_OPTIONS$1", "Lio/sentry/okhttp/SentryOkHttpInterceptor$Companion$FAKE_OPTIONS$1;", "sentry-okhttp"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

