/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.okhttp;

import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryDate;
import io.sentry.SentryLevel;
import io.sentry.okhttp.SentryOkHttpUtils;
import io.sentry.util.Platform;
import io.sentry.util.UrlUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J9\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2%\b\u0002\u0010\u001e\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001fJ7\u0010#\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u00112%\b\u0002\u0010\u001e\u001a\u001f\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b \u0012\b\b!\u0012\u0004\b\b(\"\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001fJ\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\nH\u0002J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001dJ\u000e\u0010'\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000eJ\u0010\u0010(\u001a\u00020\u001b2\b\u0010)\u001a\u0004\u0018\u00010\u0011J\u0010\u0010*\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010\u0011J\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u000eJ\u000e\u00100\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.J\u000e\u00101\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/sentry/okhttp/SentryOkHttpEvent;", "", "hub", "Lio/sentry/IHub;", "request", "Lokhttp3/Request;", "(Lio/sentry/IHub;Lokhttp3/Request;)V", "breadcrumb", "Lio/sentry/Breadcrumb;", "callRootSpan", "Lio/sentry/ISpan;", "getCallRootSpan$sentry_okhttp", "()Lio/sentry/ISpan;", "clientErrorResponse", "Lokhttp3/Response;", "eventSpans", "", "", "isEventFinished", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isReadingResponseBody", "method", "response", "url", "findParentSpan", "event", "finishEvent", "", "finishDate", "Lio/sentry/SentryDate;", "beforeFinish", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "span", "finishSpan", "moveThrowableToRootSpan", "scheduleFinish", "timestamp", "setClientErrorResponse", "setError", "errorMessage", "setProtocol", "protocolName", "setRequestBodySize", "byteCount", "", "setResponse", "setResponseBodySize", "startSpan", "sentry-okhttp"})
@SourceDebugExtension(value={"SMAP\nSentryOkHttpEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryOkHttpEvent.kt\nio/sentry/okhttp/SentryOkHttpEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1#2:229\n766#3:230\n857#3,2:231\n1855#3,2:233\n1726#3,3:235\n*S KotlinDebug\n*F\n+ 1 SentryOkHttpEvent.kt\nio/sentry/okhttp/SentryOkHttpEvent\n*L\n166#1:230\n166#1:231,2\n166#1:233,2\n211#1:235,3\n*E\n"})
public final class SentryOkHttpEvent {
    @NotNull
    private final IHub hub;
    @NotNull
    private final Request request;
    @NotNull
    private final Map<String, ISpan> eventSpans;
    @NotNull
    private final Breadcrumb breadcrumb;
    @Nullable
    private final ISpan callRootSpan;
    @Nullable
    private Response response;
    @Nullable
    private Response clientErrorResponse;
    @NotNull
    private final AtomicBoolean isReadingResponseBody;
    @NotNull
    private final AtomicBoolean isEventFinished;
    @NotNull
    private final String url;
    @NotNull
    private final String method;

    public SentryOkHttpEvent(@NotNull IHub hub, @NotNull Request request) {
        block4: {
            ISpan parentSpan;
            Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            this.hub = hub;
            this.request = request;
            this.eventSpans = new ConcurrentHashMap();
            this.isReadingResponseBody = new AtomicBoolean(false);
            this.isEventFinished = new AtomicBoolean(false);
            UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)this.request.url().toString());
            Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(request.url.toString())");
            UrlUtils.UrlDetails urlDetails2 = urlDetails;
            String string = urlDetails2.getUrlOrFallback();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlDetails.urlOrFallback");
            this.url = string;
            String host = this.request.url().host();
            String encodedPath = this.request.url().encodedPath();
            this.method = this.request.method();
            ISpan iSpan = parentSpan = Platform.isAndroid() ? (ISpan)this.hub.getTransaction() : this.hub.getSpan();
            ISpan iSpan2 = this.callRootSpan = iSpan != null ? iSpan.startChild("http.client", this.method + ' ' + this.url) : null;
            Object object = iSpan2 != null ? iSpan2.getSpanContext() : null;
            if (object != null) {
                object.setOrigin("auto.http.okhttp");
            }
            urlDetails2.applyToSpan(this.callRootSpan);
            Breadcrumb breadcrumb = Breadcrumb.http((String)this.url, (String)this.method);
            Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"http(url, method)");
            this.breadcrumb = breadcrumb;
            this.breadcrumb.setData("host", (Object)host);
            this.breadcrumb.setData("path", (Object)encodedPath);
            ISpan iSpan3 = this.callRootSpan;
            if (iSpan3 != null) {
                iSpan3.setData("url", (Object)this.url);
            }
            ISpan iSpan4 = this.callRootSpan;
            if (iSpan4 != null) {
                iSpan4.setData("host", (Object)host);
            }
            ISpan iSpan5 = this.callRootSpan;
            if (iSpan5 != null) {
                iSpan5.setData("path", (Object)encodedPath);
            }
            ISpan iSpan6 = this.callRootSpan;
            if (iSpan6 == null) break block4;
            String string2 = this.method;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string3 = string2.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(locale)");
            iSpan6.setData("http.request.method", (Object)string3);
        }
    }

    @Nullable
    public final ISpan getCallRootSpan$sentry_okhttp() {
        return this.callRootSpan;
    }

    public final void setResponse(@NotNull Response response) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.response = response;
            this.breadcrumb.setData("protocol", (Object)response.protocol().name());
            this.breadcrumb.setData("status_code", (Object)response.code());
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("protocol", (Object)response.protocol().name());
            }
            ISpan iSpan2 = this.callRootSpan;
            if (iSpan2 == null) break block1;
            iSpan2.setData("http.response.status_code", (Object)response.code());
        }
    }

    public final void setProtocol(@Nullable String protocolName) {
        block1: {
            if (protocolName == null) break block1;
            this.breadcrumb.setData("protocol", (Object)protocolName);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("protocol", (Object)protocolName);
            }
        }
    }

    public final void setRequestBodySize(long byteCount) {
        block1: {
            if (byteCount <= -1L) break block1;
            this.breadcrumb.setData("request_content_length", (Object)byteCount);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("http.request_content_length", (Object)byteCount);
            }
        }
    }

    public final void setResponseBodySize(long byteCount) {
        block1: {
            if (byteCount <= -1L) break block1;
            this.breadcrumb.setData("response_content_length", (Object)byteCount);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("http.response_content_length", (Object)byteCount);
            }
        }
    }

    public final void setClientErrorResponse(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.clientErrorResponse = response;
    }

    public final void setError(@Nullable String errorMessage) {
        block1: {
            if (errorMessage == null) break block1;
            this.breadcrumb.setData("error_message", (Object)errorMessage);
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setData("error_message", (Object)errorMessage);
            }
        }
    }

    public final void startSpan(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ISpan parentSpan = this.findParentSpan(event);
        ISpan iSpan = parentSpan;
        if (iSpan == null || (iSpan = iSpan.startChild("http.client." + event, this.method + ' ' + this.url)) == null) {
            return;
        }
        ISpan span = iSpan;
        if (Intrinsics.areEqual((Object)event, (Object)"response_body")) {
            this.isReadingResponseBody.set(true);
        }
        span.getSpanContext().setOrigin("auto.http.okhttp");
        this.eventSpans.put(event, span);
    }

    @Nullable
    public final ISpan finishSpan(@NotNull String event, @Nullable Function1<? super ISpan, Unit> beforeFinish) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ISpan iSpan = this.eventSpans.get(event);
        if (iSpan == null) {
            return null;
        }
        ISpan span = iSpan;
        ISpan parentSpan = this.findParentSpan(event);
        Function1<? super ISpan, Unit> function1 = beforeFinish;
        if (function1 != null) {
            function1.invoke((Object)span);
        }
        this.moveThrowableToRootSpan(span);
        if (parentSpan != null && !Intrinsics.areEqual((Object)parentSpan, (Object)this.callRootSpan)) {
            Function1<? super ISpan, Unit> function12 = beforeFinish;
            if (function12 != null) {
                function12.invoke((Object)parentSpan);
            }
            this.moveThrowableToRootSpan(parentSpan);
        }
        ISpan iSpan2 = this.callRootSpan;
        if (iSpan2 != null) {
            ISpan it = iSpan2;
            boolean bl = false;
            Function1<? super ISpan, Unit> function13 = beforeFinish;
            if (function13 != null) {
                function13.invoke((Object)it);
            }
        }
        span.finish();
        return span;
    }

    public static /* synthetic */ ISpan finishSpan$default(SentryOkHttpEvent sentryOkHttpEvent, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return sentryOkHttpEvent.finishSpan(string, (Function1<? super ISpan, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public final void finishEvent(@Nullable SentryDate finishDate, @Nullable Function1<? super ISpan, Unit> beforeFinish) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Object it;
        if (this.isEventFinished.getAndSet(true)) {
            return;
        }
        Hint hint = new Hint();
        hint.set("okHttp:request", (Object)this.request);
        Response response = this.response;
        if (response != null) {
            it = response;
            boolean bl = false;
            hint.set("okHttp:response", it);
        }
        this.hub.addBreadcrumb(this.breadcrumb, hint);
        if (this.callRootSpan == null) {
            Response response2 = this.clientErrorResponse;
            if (response2 != null) {
                it = response2;
                boolean bl = false;
                SentryOkHttpUtils.INSTANCE.captureClientError$sentry_okhttp(this.hub, it.request(), (Response)it);
            }
            return;
        }
        Iterable $this$filter$iv = this.eventSpans.values();
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            ISpan it2 = (ISpan)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isFinished())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ISpan it3 = (ISpan)element$iv;
            boolean bl = false;
            this.moveThrowableToRootSpan(it3);
            if (finishDate != null) {
                it3.finish(it3.getStatus(), finishDate);
                continue;
            }
            it3.finish();
        }
        Function1<? super ISpan, Unit> function1 = beforeFinish;
        if (function1 != null) {
            function1.invoke((Object)this.callRootSpan);
        }
        Response response3 = this.clientErrorResponse;
        if (response3 != null) {
            it = response3;
            boolean bl = false;
            SentryOkHttpUtils.INSTANCE.captureClientError$sentry_okhttp(this.hub, it.request(), (Response)it);
        }
        if (finishDate != null) {
            this.callRootSpan.finish(this.callRootSpan.getStatus(), finishDate);
        } else {
            this.callRootSpan.finish();
        }
    }

    public static /* synthetic */ void finishEvent$default(SentryOkHttpEvent sentryOkHttpEvent, SentryDate sentryDate, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            sentryDate = null;
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        sentryOkHttpEvent.finishEvent(sentryDate, (Function1<? super ISpan, Unit>)function1);
    }

    private final void moveThrowableToRootSpan(ISpan span) {
        if (!Intrinsics.areEqual((Object)span, (Object)this.callRootSpan) && span.getThrowable() != null && span.getStatus() != null) {
            ISpan iSpan = this.callRootSpan;
            if (iSpan != null) {
                iSpan.setThrowable(span.getThrowable());
            }
            ISpan iSpan2 = this.callRootSpan;
            if (iSpan2 != null) {
                iSpan2.setStatus(span.getStatus());
            }
            span.setThrowable(null);
        }
    }

    private final ISpan findParentSpan(String event) {
        ISpan iSpan;
        ISpan iSpan2;
        switch (event) {
            case "secure_connect": {
                iSpan2 = this.eventSpans.get("connect");
                break;
            }
            case "request_headers": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            case "request_body": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            case "response_headers": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            case "response_body": {
                iSpan2 = this.eventSpans.get("connection");
                break;
            }
            default: {
                iSpan2 = iSpan = this.callRootSpan;
            }
        }
        if (iSpan2 == null) {
            iSpan = this.callRootSpan;
        }
        return iSpan;
    }

    public final void scheduleFinish(@NotNull SentryDate timestamp) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
        try {
            this.hub.getOptions().getExecutorService().schedule(() -> SentryOkHttpEvent.scheduleFinish$lambda$7(this, timestamp), 800L);
        }
        catch (RejectedExecutionException e) {
            this.hub.getOptions().getLogger().log(SentryLevel.ERROR, "Failed to call the executor. OkHttp span will not be finished automatically. Did you call Sentry.close()?", (Throwable)e);
        }
    }

    private static final void scheduleFinish$lambda$7(SentryOkHttpEvent this$0, SentryDate $timestamp) {
        block8: {
            block9: {
                boolean bl;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$timestamp, (String)"$timestamp");
                    if (this$0.isReadingResponseBody.get()) break block8;
                    Iterable $this$all$iv = this$0.eventSpans.values();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            ISpan it = (ISpan)element$iv;
                            boolean bl2 = false;
                            if (it.isFinished()) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) break block9;
                ISpan iSpan = this$0.callRootSpan;
                if (iSpan != null ? iSpan.isFinished() : false) break block8;
            }
            SentryOkHttpEvent.finishEvent$default(this$0, $timestamp, null, 2, null);
        }
    }
}

