/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.log4j2;

import io.sentry.Sentry;
import io.sentry.environment.SentryEnvironment;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.interfaces.ExceptionInterface;
import io.sentry.event.interfaces.MessageInterface;
import io.sentry.event.interfaces.SentryInterface;
import io.sentry.event.interfaces.StackTraceInterface;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.message.Message;

@Plugin(name="Sentry", category="Core", elementType="appender", printObject=true)
public class SentryAppender
extends AbstractAppender {
    public static final String APPENDER_NAME = "sentry";
    public static final String LOG4J_NDC = "log4j2-NDC";
    public static final String LOG4J_MARKER = "log4j2-Marker";
    public static final String THREAD_NAME = "Sentry-Threadname";

    public SentryAppender() {
        this(APPENDER_NAME, null);
    }

    protected SentryAppender(String name, Filter filter) {
        super(name, filter, null, true);
        this.addFilter((Filter)new DropSentryFilter());
    }

    @PluginFactory
    public static SentryAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for SentryAppender");
            return null;
        }
        return new SentryAppender(name, filter);
    }

    protected static Event.Level formatLevel(Level level) {
        if (level.isMoreSpecificThan(Level.FATAL)) {
            return Event.Level.FATAL;
        }
        if (level.isMoreSpecificThan(Level.ERROR)) {
            return Event.Level.ERROR;
        }
        if (level.isMoreSpecificThan(Level.WARN)) {
            return Event.Level.WARNING;
        }
        if (level.isMoreSpecificThan(Level.INFO)) {
            return Event.Level.INFO;
        }
        return Event.Level.DEBUG;
    }

    protected static List<String> formatMessageParameters(Object[] parameters) {
        ArrayList<String> stringParameters = new ArrayList<String>(parameters.length);
        for (Object parameter : parameters) {
            stringParameters.add(parameter != null ? parameter.toString() : null);
        }
        return stringParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent logEvent) {
        if (SentryEnvironment.isManagingThread()) {
            return;
        }
        SentryEnvironment.startManagingThread();
        try {
            EventBuilder eventBuilder = this.createEventBuilder(logEvent);
            Sentry.capture((EventBuilder)eventBuilder);
        }
        catch (Exception e) {
            this.error("An exception occurred while creating a new event in Sentry", logEvent, e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    protected EventBuilder createEventBuilder(LogEvent event) {
        Throwable throwable;
        Message eventMessage = event.getMessage();
        EventBuilder eventBuilder = new EventBuilder().withSdkIntegration("log4j2").withTimestamp(new Date(event.getTimeMillis())).withMessage(eventMessage.getFormattedMessage()).withLogger(event.getLoggerName()).withLevel(SentryAppender.formatLevel(event.getLevel())).withExtra(THREAD_NAME, (Object)event.getThreadName());
        if (eventMessage.getFormat() != null && !eventMessage.getFormat().equals("") && !eventMessage.getFormattedMessage().equals(eventMessage.getFormat())) {
            eventBuilder.withSentryInterface((SentryInterface)new MessageInterface(eventMessage.getFormat(), SentryAppender.formatMessageParameters(eventMessage.getParameters()), eventMessage.getFormattedMessage()));
        }
        if ((throwable = event.getThrown()) != null) {
            eventBuilder.withSentryInterface((SentryInterface)new ExceptionInterface(throwable));
        } else if (event.getSource() != null) {
            StackTraceElement[] stackTrace = new StackTraceElement[]{event.getSource()};
            eventBuilder.withSentryInterface((SentryInterface)new StackTraceInterface(stackTrace));
        }
        if (event.getSource() != null) {
            eventBuilder.withCulprit(event.getSource());
        } else {
            eventBuilder.withCulprit(event.getLoggerName());
        }
        if (event.getContextStack() != null) {
            eventBuilder.withExtra(LOG4J_NDC, (Object)event.getContextStack().asList());
        }
        if (event.getContextMap() != null) {
            for (Map.Entry contextEntry : event.getContextMap().entrySet()) {
                if (Sentry.getStoredClient().getMdcTags().contains(contextEntry.getKey())) {
                    eventBuilder.withTag((String)contextEntry.getKey(), (String)contextEntry.getValue());
                    continue;
                }
                eventBuilder.withExtra((String)contextEntry.getKey(), contextEntry.getValue());
            }
        }
        if (event.getMarker() != null) {
            eventBuilder.withTag(LOG4J_MARKER, event.getMarker().getName());
        }
        return eventBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SentryEnvironment.startManagingThread();
        try {
            if (!this.isStarted()) {
                return;
            }
            super.stop();
            Sentry.close();
        }
        catch (Exception e) {
            this.error("An exception occurred while closing the Sentry connection", e);
        }
        finally {
            SentryEnvironment.stopManagingThread();
        }
    }

    private class DropSentryFilter
    extends AbstractFilter {
        private DropSentryFilter() {
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, String msg, Object ... params) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Object msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(Logger logger, Level level, Marker marker, Message msg, Throwable t) {
            return this.filter(logger.getName());
        }

        public Filter.Result filter(LogEvent event) {
            return this.filter(event.getLoggerName());
        }

        private Filter.Result filter(String loggerName) {
            if (loggerName != null && loggerName.startsWith("io.sentry")) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }
    }
}

