/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jdbc;

import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.ISpan;
import io.sentry.ScopesAdapter;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SpanOptions;
import io.sentry.SpanStatus;
import io.sentry.jdbc.DatabaseUtils;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryJdbcEventListener
extends SimpleJdbcEventListener {
    private static final String TRACE_ORIGIN = "auto.db.jdbc";
    @NotNull
    private final IScopes scopes;
    @NotNull
    private static final ThreadLocal<ISpan> CURRENT_SPAN = new ThreadLocal();
    @Nullable
    private volatile DatabaseUtils.DatabaseDetails cachedDatabaseDetails = null;
    @NotNull
    protected final AutoClosableReentrantLock databaseDetailsLock = new AutoClosableReentrantLock();

    public SentryJdbcEventListener(@NotNull IScopes scopes) {
        this.scopes = (IScopes)Objects.requireNonNull((Object)scopes, (String)"scopes are required");
        this.addPackageAndIntegrationInfo();
    }

    public SentryJdbcEventListener() {
        this((IScopes)ScopesAdapter.getInstance());
    }

    public void onBeforeAnyExecute(@NotNull StatementInformation statementInformation) {
        ISpan parent = this.scopes.getSpan();
        if (parent != null && !parent.isNoOp()) {
            @NotNull SpanOptions spanOptions = new SpanOptions();
            spanOptions.setOrigin(TRACE_ORIGIN);
            ISpan span = parent.startChild("db.query", statementInformation.getSql(), spanOptions);
            CURRENT_SPAN.set(span);
        }
    }

    public void onAfterAnyExecute(@NotNull StatementInformation statementInformation, long timeElapsedNanos, @Nullable SQLException e) {
        ISpan span = CURRENT_SPAN.get();
        if (span != null) {
            this.applyDatabaseDetailsToSpan(statementInformation, span);
            if (e != null) {
                span.setThrowable((Throwable)e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
            } else {
                span.setStatus(SpanStatus.OK);
            }
            span.finish();
            CURRENT_SPAN.set(null);
        }
    }

    private void addPackageAndIntegrationInfo() {
        SentryIntegrationPackageStorage.getInstance().addIntegration("JDBC");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-jdbc", "8.0.0");
    }

    private void applyDatabaseDetailsToSpan(@NotNull StatementInformation statementInformation, @NotNull ISpan span) {
        @NotNull DatabaseUtils.DatabaseDetails databaseDetails = this.getOrComputeDatabaseDetails(statementInformation);
        if (databaseDetails.getDbSystem() != null) {
            span.setData("db.system", (Object)databaseDetails.getDbSystem());
        }
        if (databaseDetails.getDbName() != null) {
            span.setData("db.name", (Object)databaseDetails.getDbName());
        }
    }

    @NotNull
    private DatabaseUtils.DatabaseDetails getOrComputeDatabaseDetails(@NotNull StatementInformation statementInformation) {
        if (this.cachedDatabaseDetails == null) {
            try (@NotNull ISentryLifecycleToken ignored = this.databaseDetailsLock.acquire();){
                if (this.cachedDatabaseDetails == null) {
                    this.cachedDatabaseDetails = DatabaseUtils.readFrom(statementInformation);
                }
            }
        }
        return this.cachedDatabaseDetails;
    }
}

