/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jdbc;

import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SpanStatus;
import io.sentry.jdbc.DatabaseUtils;
import io.sentry.util.Objects;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryJdbcEventListener
extends SimpleJdbcEventListener {
    private static final String TRACE_ORIGIN = "auto.db.jdbc";
    @NotNull
    private final IHub hub;
    @NotNull
    private static final ThreadLocal<ISpan> CURRENT_SPAN = new ThreadLocal();
    @Nullable
    private volatile DatabaseUtils.DatabaseDetails cachedDatabaseDetails = null;
    @NotNull
    private final Object databaseDetailsLock = new Object();

    public SentryJdbcEventListener(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.addPackageAndIntegrationInfo();
    }

    public SentryJdbcEventListener() {
        this((IHub)HubAdapter.getInstance());
    }

    public void onBeforeAnyExecute(@NotNull StatementInformation statementInformation) {
        ISpan parent = this.hub.getSpan();
        if (parent != null && !parent.isNoOp()) {
            ISpan span = parent.startChild("db.query", statementInformation.getSql());
            CURRENT_SPAN.set(span);
            span.getSpanContext().setOrigin(TRACE_ORIGIN);
        }
    }

    public void onAfterAnyExecute(@NotNull StatementInformation statementInformation, long timeElapsedNanos, @Nullable SQLException e) {
        ISpan span = CURRENT_SPAN.get();
        if (span != null) {
            this.applyDatabaseDetailsToSpan(statementInformation, span);
            if (e != null) {
                span.setThrowable((Throwable)e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
            } else {
                span.setStatus(SpanStatus.OK);
            }
            span.finish();
            CURRENT_SPAN.set(null);
        }
    }

    private void addPackageAndIntegrationInfo() {
        SentryIntegrationPackageStorage.getInstance().addIntegration("JDBC");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-jdbc", "7.5.0");
    }

    private void applyDatabaseDetailsToSpan(@NotNull StatementInformation statementInformation, @NotNull ISpan span) {
        @NotNull DatabaseUtils.DatabaseDetails databaseDetails = this.getOrComputeDatabaseDetails(statementInformation);
        if (databaseDetails.getDbSystem() != null) {
            span.setData("db.system", (Object)databaseDetails.getDbSystem());
        }
        if (databaseDetails.getDbName() != null) {
            span.setData("db.name", (Object)databaseDetails.getDbName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DatabaseUtils.DatabaseDetails getOrComputeDatabaseDetails(@NotNull StatementInformation statementInformation) {
        if (this.cachedDatabaseDetails == null) {
            Object object = this.databaseDetailsLock;
            synchronized (object) {
                if (this.cachedDatabaseDetails == null) {
                    this.cachedDatabaseDetails = DatabaseUtils.readFrom(statementInformation);
                }
            }
        }
        return this.cachedDatabaseDetails;
    }
}

