/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jdbc;

import com.p6spy.engine.common.StatementInformation;
import com.p6spy.engine.event.SimpleJdbcEventListener;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SpanStatus;
import io.sentry.util.Objects;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryJdbcEventListener
extends SimpleJdbcEventListener {
    @NotNull
    private final IHub hub;
    @NotNull
    private static final ThreadLocal<ISpan> CURRENT_SPAN = new ThreadLocal();

    public SentryJdbcEventListener(@NotNull IHub hub) {
        this.hub = (IHub)Objects.requireNonNull((Object)hub, (String)"hub is required");
        this.addPackageAndIntegrationInfo();
    }

    public SentryJdbcEventListener() {
        this((IHub)HubAdapter.getInstance());
    }

    public void onBeforeAnyExecute(@NotNull StatementInformation statementInformation) {
        ISpan parent = this.hub.getSpan();
        if (parent != null && !parent.isNoOp()) {
            ISpan span = parent.startChild("db.query", statementInformation.getSql());
            CURRENT_SPAN.set(span);
        }
    }

    public void onAfterAnyExecute(@NotNull StatementInformation statementInformation, long timeElapsedNanos, @Nullable SQLException e) {
        ISpan span = CURRENT_SPAN.get();
        if (span != null) {
            if (e != null) {
                span.setThrowable((Throwable)e);
                span.setStatus(SpanStatus.INTERNAL_ERROR);
            } else {
                span.setStatus(SpanStatus.OK);
            }
            span.finish();
            CURRENT_SPAN.set(null);
        }
    }

    private void addPackageAndIntegrationInfo() {
        SentryIntegrationPackageStorage.getInstance().addIntegration("JDBC");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-jdbc", "6.20.0");
    }
}

