/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.IHub;
import io.sentry.core.Integration;
import io.sentry.core.SentryOptions;
import io.sentry.core.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class ShutdownHookIntegration
implements Integration {
    @NotNull
    private final Runtime runtime;

    @TestOnly
    public ShutdownHookIntegration(@NotNull Runtime runtime) {
        this.runtime = Objects.requireNonNull(runtime, "Runtime is required");
    }

    public ShutdownHookIntegration() {
        this(Runtime.getRuntime());
    }

    @Override
    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Objects.requireNonNull(hub, "Hub is required");
        this.runtime.addShutdownHook(new Thread(() -> hub.close()));
    }
}

