/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.Breadcrumb;
import io.sentry.core.DiagnosticLogger;
import io.sentry.core.EnvelopeReader;
import io.sentry.core.EventProcessor;
import io.sentry.core.IEnvelopeReader;
import io.sentry.core.ILogger;
import io.sentry.core.ISentryExecutorService;
import io.sentry.core.ISerializer;
import io.sentry.core.Integration;
import io.sentry.core.MainEventProcessor;
import io.sentry.core.NoOpEnvelopeReader;
import io.sentry.core.NoOpLogger;
import io.sentry.core.NoOpSerializer;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryExecutorService;
import io.sentry.core.SentryLevel;
import io.sentry.core.ShutdownHookIntegration;
import io.sentry.core.UncaughtExceptionHandlerIntegration;
import io.sentry.core.cache.IEnvelopeCache;
import io.sentry.core.cache.IEventCache;
import io.sentry.core.protocol.SdkVersion;
import io.sentry.core.transport.ITransport;
import io.sentry.core.transport.ITransportGate;
import io.sentry.core.transport.NoOpEnvelopeCache;
import io.sentry.core.transport.NoOpEventCache;
import io.sentry.core.transport.NoOpTransport;
import io.sentry.core.transport.NoOpTransportGate;
import java.io.File;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryOptions {
    static final SentryLevel DEFAULT_DIAGNOSTIC_LEVEL = SentryLevel.DEBUG;
    @NotNull
    private final List<EventProcessor> eventProcessors = new CopyOnWriteArrayList<EventProcessor>();
    @NotNull
    private final List<Integration> integrations = new CopyOnWriteArrayList<Integration>();
    @Nullable
    private String dsn;
    private long shutdownTimeoutMillis = 2000L;
    private long flushTimeoutMillis = 15000L;
    private boolean debug;
    private boolean enableNdk = true;
    @NotNull
    private ILogger logger = NoOpLogger.getInstance();
    @NotNull
    private SentryLevel diagnosticLevel = DEFAULT_DIAGNOSTIC_LEVEL;
    @NotNull
    private ISerializer serializer = NoOpSerializer.getInstance();
    @NotNull
    private IEnvelopeReader envelopeReader = new EnvelopeReader();
    @Nullable
    private String sentryClientName;
    @Nullable
    private BeforeSendCallback beforeSend;
    @Nullable
    private BeforeBreadcrumbCallback beforeBreadcrumb;
    @Nullable
    private String cacheDirPath;
    private int cacheDirSize = 10;
    private int sessionsDirSize = 100;
    private int maxQueueSize = this.cacheDirSize + this.sessionsDirSize;
    private int maxBreadcrumbs = 100;
    @Nullable
    private String release;
    @Nullable
    private String environment;
    @Nullable
    private Proxy proxy;
    @Nullable
    private Double sampleRate;
    @NotNull
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    @NotNull
    private ITransport transport = NoOpTransport.getInstance();
    @NotNull
    private ITransportGate transportGate = NoOpTransportGate.getInstance();
    @Nullable
    private String dist;
    private boolean attachThreads = true;
    private boolean attachStacktrace;
    private boolean enableSessionTracking;
    private long sessionTrackingIntervalMillis = 30000L;
    private String distinctId;
    private String serverName;
    private boolean enableUncaughtExceptionHandler = true;
    @NotNull
    private ISentryExecutorService executorService;
    private int connectionTimeoutMillis = 5000;
    private int readTimeoutMillis = 5000;
    private boolean bypassSecurity = false;
    @NotNull
    private IEventCache eventDiskCache = NoOpEventCache.getInstance();
    @NotNull
    private IEnvelopeCache envelopeDiskCache = NoOpEnvelopeCache.getInstance();
    @Nullable
    private SdkVersion sdkVersion;

    public void addEventProcessor(@NotNull EventProcessor eventProcessor) {
        this.eventProcessors.add(eventProcessor);
    }

    @NotNull
    public List<EventProcessor> getEventProcessors() {
        return this.eventProcessors;
    }

    public void addIntegration(@NotNull Integration integration) {
        this.integrations.add(integration);
    }

    @NotNull
    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    @Nullable
    public String getDsn() {
        return this.dsn;
    }

    public void setDsn(@Nullable String dsn) {
        this.dsn = dsn;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @NotNull
    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(@Nullable ILogger logger) {
        this.logger = logger == null ? NoOpLogger.getInstance() : new DiagnosticLogger(this, logger);
    }

    @NotNull
    public SentryLevel getDiagnosticLevel() {
        return this.diagnosticLevel;
    }

    public void setDiagnosticLevel(@Nullable SentryLevel diagnosticLevel) {
        this.diagnosticLevel = diagnosticLevel != null ? diagnosticLevel : DEFAULT_DIAGNOSTIC_LEVEL;
    }

    @NotNull
    public ISerializer getSerializer() {
        return this.serializer;
    }

    public void setSerializer(@Nullable ISerializer serializer) {
        this.serializer = serializer != null ? serializer : NoOpSerializer.getInstance();
    }

    @NotNull
    public IEnvelopeReader getEnvelopeReader() {
        return this.envelopeReader;
    }

    public void setEnvelopeReader(@Nullable IEnvelopeReader envelopeReader) {
        this.envelopeReader = envelopeReader != null ? envelopeReader : NoOpEnvelopeReader.getInstance();
    }

    public boolean isEnableNdk() {
        return this.enableNdk;
    }

    public void setEnableNdk(boolean enableNdk) {
        this.enableNdk = enableNdk;
    }

    public long getShutdownTimeout() {
        return this.shutdownTimeoutMillis;
    }

    public void setShutdownTimeout(long shutdownTimeoutMillis) {
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
    }

    @Nullable
    public String getSentryClientName() {
        return this.sentryClientName;
    }

    public void setSentryClientName(@Nullable String sentryClientName) {
        this.sentryClientName = sentryClientName;
    }

    @Nullable
    public BeforeSendCallback getBeforeSend() {
        return this.beforeSend;
    }

    public void setBeforeSend(@Nullable BeforeSendCallback beforeSend) {
        this.beforeSend = beforeSend;
    }

    @Nullable
    public BeforeBreadcrumbCallback getBeforeBreadcrumb() {
        return this.beforeBreadcrumb;
    }

    public void setBeforeBreadcrumb(@Nullable BeforeBreadcrumbCallback beforeBreadcrumb) {
        this.beforeBreadcrumb = beforeBreadcrumb;
    }

    @Nullable
    public String getCacheDirPath() {
        return this.cacheDirPath;
    }

    @Nullable
    public String getOutboxPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.cacheDirPath + File.separator + "outbox";
    }

    @Nullable
    public String getSessionsPath() {
        if (this.cacheDirPath == null || this.cacheDirPath.isEmpty()) {
            return null;
        }
        return this.cacheDirPath + File.separator + "sessions";
    }

    public void setCacheDirPath(@Nullable String cacheDirPath) {
        this.cacheDirPath = cacheDirPath;
    }

    public int getCacheDirSize() {
        return this.cacheDirSize;
    }

    public void setCacheDirSize(int cacheDirSize) {
        this.cacheDirSize = cacheDirSize;
    }

    public int getMaxBreadcrumbs() {
        return this.maxBreadcrumbs;
    }

    public void setMaxBreadcrumbs(int maxBreadcrumbs) {
        this.maxBreadcrumbs = maxBreadcrumbs;
    }

    @Nullable
    public String getRelease() {
        return this.release;
    }

    public void setRelease(@Nullable String release) {
        this.release = release;
    }

    @Nullable
    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(@Nullable String environment) {
        this.environment = environment;
    }

    @Nullable
    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(@Nullable Proxy proxy) {
        this.proxy = proxy;
    }

    @Nullable
    public Double getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(Double sampleRate) {
        if (sampleRate != null && (sampleRate > 1.0 || sampleRate <= 0.0)) {
            throw new IllegalArgumentException("The value " + sampleRate + " is not valid. Use null to disable or values between 0.01 (inclusive) and 1.0 (exclusive).");
        }
        this.sampleRate = sampleRate;
    }

    @NotNull
    public List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public void addInAppExclude(@NotNull String exclude) {
        this.inAppExcludes.add(exclude);
    }

    @NotNull
    public List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public void addInAppInclude(@NotNull String include) {
        this.inAppIncludes.add(include);
    }

    @NotNull
    public ITransport getTransport() {
        return this.transport;
    }

    public void setTransport(@Nullable ITransport transport) {
        this.transport = transport != null ? transport : NoOpTransport.getInstance();
    }

    @Nullable
    public String getDist() {
        return this.dist;
    }

    public void setDist(@Nullable String dist) {
        this.dist = dist;
    }

    @NotNull
    public ITransportGate getTransportGate() {
        return this.transportGate;
    }

    public void setTransportGate(@Nullable ITransportGate transportGate) {
        this.transportGate = transportGate != null ? transportGate : NoOpTransportGate.getInstance();
    }

    public boolean isAttachStacktrace() {
        return this.attachStacktrace;
    }

    public void setAttachStacktrace(boolean attachStacktrace) {
        this.attachStacktrace = attachStacktrace;
    }

    public boolean isAttachThreads() {
        return this.attachThreads;
    }

    public void setAttachThreads(boolean attachThreads) {
        this.attachThreads = attachThreads;
    }

    public boolean isEnableSessionTracking() {
        return this.enableSessionTracking;
    }

    public void setEnableSessionTracking(boolean enableSessionTracking) {
        this.enableSessionTracking = enableSessionTracking;
    }

    @Nullable
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(@Nullable String serverName) {
        this.serverName = serverName;
    }

    public int getSessionsDirSize() {
        return this.sessionsDirSize;
    }

    public void setSessionsDirSize(int sessionsDirSize) {
        this.sessionsDirSize = sessionsDirSize;
    }

    public long getSessionTrackingIntervalMillis() {
        return this.sessionTrackingIntervalMillis;
    }

    public void setSessionTrackingIntervalMillis(long sessionTrackingIntervalMillis) {
        this.sessionTrackingIntervalMillis = sessionTrackingIntervalMillis;
    }

    @ApiStatus.Internal
    public String getDistinctId() {
        return this.distinctId;
    }

    @ApiStatus.Internal
    public void setDistinctId(String distinctId) {
        this.distinctId = distinctId;
    }

    public long getFlushTimeoutMillis() {
        return this.flushTimeoutMillis;
    }

    public void setFlushTimeoutMillis(long flushTimeoutMillis) {
        this.flushTimeoutMillis = flushTimeoutMillis;
    }

    public boolean isEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    public void setEnableUncaughtExceptionHandler(boolean enableUncaughtExceptionHandler) {
        this.enableUncaughtExceptionHandler = enableUncaughtExceptionHandler;
    }

    @NotNull
    ISentryExecutorService getExecutorService() {
        return this.executorService;
    }

    void setExecutorService(@NotNull ISentryExecutorService executorService) {
        if (executorService != null) {
            this.executorService = executorService;
        }
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public void setConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public void setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    public boolean isBypassSecurity() {
        return this.bypassSecurity;
    }

    public void setBypassSecurity(boolean bypassSecurity) {
        this.bypassSecurity = bypassSecurity;
    }

    @NotNull
    public IEventCache getEventDiskCache() {
        return this.eventDiskCache;
    }

    public void setEventDiskCache(@Nullable IEventCache eventDiskCache) {
        this.eventDiskCache = eventDiskCache != null ? eventDiskCache : NoOpEventCache.getInstance();
    }

    @NotNull
    public IEnvelopeCache getEnvelopeDiskCache() {
        return this.envelopeDiskCache;
    }

    public void setEnvelopeDiskCache(@Nullable IEnvelopeCache envelopeDiskCache) {
        this.envelopeDiskCache = envelopeDiskCache != null ? envelopeDiskCache : NoOpEnvelopeCache.getInstance();
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize > 0) {
            this.maxQueueSize = maxQueueSize;
        }
    }

    @Nullable
    public SdkVersion getSdkVersion() {
        return this.sdkVersion;
    }

    @ApiStatus.Internal
    public void setSdkVersion(@Nullable SdkVersion sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public SentryOptions() {
        this.executorService = new SentryExecutorService();
        this.integrations.add(new UncaughtExceptionHandlerIntegration());
        this.integrations.add(new ShutdownHookIntegration());
        this.eventProcessors.add(new MainEventProcessor(this));
        this.setSentryClientName("sentry.java/2.3.2");
        this.setSdkVersion(this.createSdkVersion());
    }

    @NotNull
    private SdkVersion createSdkVersion() {
        SdkVersion sdkVersion = new SdkVersion();
        sdkVersion.setName("sentry.java");
        String version = "2.3.2";
        sdkVersion.setVersion(version);
        sdkVersion.addPackage("maven:sentry-core", version);
        return sdkVersion;
    }

    public static interface BeforeBreadcrumbCallback {
        @Nullable
        public Breadcrumb execute(@NotNull Breadcrumb var1, @Nullable Object var2);
    }

    public static interface BeforeSendCallback {
        @Nullable
        public SentryEvent execute(@NotNull SentryEvent var1, @Nullable Object var2);
    }
}

