/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.EnvelopeReader;
import io.sentry.core.EnvelopeSender;
import io.sentry.core.IHub;
import io.sentry.core.SendCachedEventFireAndForgetIntegration;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import java.io.File;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SendFireAndForgetEnvelopeSender
implements SendCachedEventFireAndForgetIntegration.SendFireAndForgetFactory {
    @NotNull
    private final SendCachedEventFireAndForgetIntegration.SendFireAndForgetDirPath sendFireAndForgetDirPath;

    public SendFireAndForgetEnvelopeSender(@NotNull SendCachedEventFireAndForgetIntegration.SendFireAndForgetDirPath sendFireAndForgetDirPath) {
        this.sendFireAndForgetDirPath = sendFireAndForgetDirPath;
    }

    @Override
    public SendCachedEventFireAndForgetIntegration.SendFireAndForget create(@NotNull IHub hub, @NotNull SentryOptions options) {
        String dirPath = this.sendFireAndForgetDirPath.getDirPath();
        if (dirPath == null) {
            options.getLogger().log(SentryLevel.WARNING, "No envelope dir path is defined in options, discarding EnvelopeSender.", new Object[0]);
            return null;
        }
        EnvelopeSender envelopeSender = new EnvelopeSender(hub, new EnvelopeReader(), options.getSerializer(), options.getLogger(), options.getFlushTimeoutMillis());
        File dirFile = new File(dirPath);
        return () -> {
            options.getLogger().log(SentryLevel.DEBUG, "Started processing cached files from %s", dirPath);
            envelopeSender.processDirectory(dirFile);
            options.getLogger().log(SentryLevel.DEBUG, "Finished processing cached files from %s", dirPath);
        };
    }
}

