/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.Breadcrumb;
import io.sentry.core.Dsn;
import io.sentry.core.Hub;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.ISentryClient;
import io.sentry.core.NoOpHub;
import io.sentry.core.OptionsContainer;
import io.sentry.core.ScopeCallback;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.protocol.SentryId;
import io.sentry.core.protocol.User;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Sentry {
    @NotNull
    private static final ThreadLocal<IHub> currentHub = new ThreadLocal();
    @NotNull
    private static volatile IHub mainHub = NoOpHub.getInstance();
    private static final boolean GLOBAL_HUB_DEFAULT_MODE = false;
    private static volatile boolean globalHubMode = false;

    private Sentry() {
    }

    @NotNull
    static IHub getCurrentHub() {
        if (globalHubMode) {
            return mainHub;
        }
        IHub hub = currentHub.get();
        if (hub == null) {
            hub = mainHub.clone();
            currentHub.set(hub);
        }
        return hub;
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentHub().isEnabled();
    }

    public static void init() {
        Sentry.init(new SentryOptions(), false);
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Sentry.init(clazz, optionsConfiguration, false);
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration, boolean globalHubMode) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        SentryOptions options = (SentryOptions)clazz.createInstance();
        optionsConfiguration.configure(options);
        Sentry.init(options, globalHubMode);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration) {
        Sentry.init(optionsConfiguration, false);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration, boolean globalHubMode) {
        SentryOptions options = new SentryOptions();
        optionsConfiguration.configure(options);
        Sentry.init(options, globalHubMode);
    }

    private static synchronized <T extends SentryOptions> void init(@NotNull T options, boolean globalHubMode) {
        String dsn = options.getDsn();
        if (dsn == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string to disable SDK.");
        }
        if (dsn.isEmpty()) {
            Sentry.close();
            return;
        }
        Dsn parsedDsn = new Dsn(dsn);
        ILogger logger = options.getLogger();
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        logger.log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubMode));
        Sentry.globalHubMode = globalHubMode;
        IHub hub = Sentry.getCurrentHub();
        mainHub = new Hub(options);
        currentHub.set(mainHub);
        hub.close();
    }

    public static synchronized void close() {
        IHub hub = Sentry.getCurrentHub();
        mainHub = NoOpHub.getInstance();
        hub.close();
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event) {
        return Sentry.getCurrentHub().captureEvent(event);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @Nullable Object hint) {
        return Sentry.getCurrentHub().captureEvent(event, hint);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message) {
        return Sentry.getCurrentHub().captureMessage(message);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return Sentry.getCurrentHub().captureMessage(message, level);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable) {
        return Sentry.getCurrentHub().captureException(throwable);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Object hint) {
        return Sentry.getCurrentHub().captureException(throwable, hint);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Object hint) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb, hint);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb);
    }

    public static void addBreadcrumb(@NotNull String message) {
        Sentry.getCurrentHub().addBreadcrumb(message);
    }

    public static void addBreadcrumb(@NotNull String message, @NotNull String category) {
        Sentry.getCurrentHub().addBreadcrumb(message, category);
    }

    public static void setLevel(@Nullable SentryLevel level) {
        Sentry.getCurrentHub().setLevel(level);
    }

    public static void setTransaction(@Nullable String transaction) {
        Sentry.getCurrentHub().setTransaction(transaction);
    }

    public static void setUser(@Nullable User user) {
        Sentry.getCurrentHub().setUser(user);
    }

    public static void setFingerprint(@NotNull List<String> fingerprint) {
        Sentry.getCurrentHub().setFingerprint(fingerprint);
    }

    public static void clearBreadcrumbs() {
        Sentry.getCurrentHub().clearBreadcrumbs();
    }

    public static void setTag(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setTag(key, value);
    }

    public static void removeTag(@NotNull String key) {
        Sentry.getCurrentHub().removeTag(key);
    }

    public static void setExtra(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setExtra(key, value);
    }

    public static void removeExtra(@NotNull String key) {
        Sentry.getCurrentHub().removeExtra(key);
    }

    @NotNull
    public static SentryId getLastEventId() {
        return Sentry.getCurrentHub().getLastEventId();
    }

    public static void pushScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().pushScope();
        }
    }

    public static void popScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().popScope();
        }
    }

    public static void withScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().withScope(callback);
    }

    public static void configureScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().configureScope(callback);
    }

    public static void bindClient(@NotNull ISentryClient client) {
        Sentry.getCurrentHub().bindClient(client);
    }

    public static void flush(long timeoutMillis) {
        Sentry.getCurrentHub().flush(timeoutMillis);
    }

    public static void startSession() {
        Sentry.getCurrentHub().startSession();
    }

    public static void endSession() {
        Sentry.getCurrentHub().endSession();
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(@NotNull T var1);
    }
}

