/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.DirectoryProcessor;
import io.sentry.core.IEnvelopeReader;
import io.sentry.core.IEnvelopeSender;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.ISerializer;
import io.sentry.core.SentryEnvelope;
import io.sentry.core.SentryEnvelopeItem;
import io.sentry.core.SentryEnvelopeItemType;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.Session;
import io.sentry.core.hints.Flushable;
import io.sentry.core.hints.Retryable;
import io.sentry.core.hints.SubmissionResult;
import io.sentry.core.util.Objects;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EnvelopeSender
extends DirectoryProcessor
implements IEnvelopeSender {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    private final IHub hub;
    @NotNull
    private final IEnvelopeReader envelopeReader;
    @NotNull
    private final ISerializer serializer;
    @NotNull
    private final ILogger logger;

    public EnvelopeSender(@NotNull IHub hub, @NotNull IEnvelopeReader envelopeReader, @NotNull ISerializer serializer, @NotNull ILogger logger, long flushTimeoutMillis) {
        super(logger, flushTimeoutMillis);
        this.hub = Objects.requireNonNull(hub, "Hub is required.");
        this.envelopeReader = Objects.requireNonNull(envelopeReader, "Envelope reader is required.");
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required.");
        this.logger = Objects.requireNonNull(logger, "Logger is required.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFile(@NotNull File file, @Nullable Object hint) {
        Objects.requireNonNull(file, "File is required.");
        if (!this.isRelevantFileName(file.getName())) {
            this.logger.log(SentryLevel.DEBUG, "File '%s' should be ignored.", file.getName());
            return;
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            SentryEnvelope envelope = this.envelopeReader.read(stream);
            if (envelope == null) {
                this.logger.log(SentryLevel.ERROR, "Stream from path %s resulted in a null envelope.", file.getAbsolutePath());
            } else {
                this.processEnvelope(envelope, hint);
            }
        }
        catch (IOException e) {
            this.logger.log(SentryLevel.ERROR, "Error processing envelope.", e);
        }
        finally {
            if (hint instanceof Retryable && !((Retryable)hint).isRetry()) {
                try {
                    file.delete();
                }
                catch (RuntimeException e) {
                    this.logger.log(SentryLevel.ERROR, "Failed to delete.", e);
                }
            }
        }
    }

    @Override
    protected boolean isRelevantFileName(@Nullable String fileName) {
        return fileName != null && !fileName.startsWith("session");
    }

    @Override
    public void processEnvelopeFile(@NotNull String path, @Nullable Object hint) {
        Objects.requireNonNull(path, "Path is required.");
        this.processFile(new File(path), hint);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processEnvelope(@NotNull SentryEnvelope envelope, @Nullable Object hint) throws IOException {
        int items;
        block29: {
            this.logger.log(SentryLevel.DEBUG, "Envelope for event Id: %s", envelope.getHeader().getEventId());
            items = 0;
            Iterator<SentryEnvelopeItem> iterator = envelope.getItems().iterator();
            while (iterator.hasNext()) {
                block28: {
                    Throwable throwable;
                    SentryEnvelopeItem item = iterator.next();
                    ++items;
                    if (item.getHeader() == null) {
                        this.logger.log(SentryLevel.ERROR, "Item %d has no header", items);
                        continue;
                    }
                    if (SentryEnvelopeItemType.Event.getType().equals(item.getHeader().getType())) {
                        try {
                            BufferedReader eventReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));
                            throwable = null;
                            try {
                                SentryEvent event = this.serializer.deserializeEvent(eventReader);
                                if (event == null) {
                                    this.logger.log(SentryLevel.ERROR, "Item %d of type %s returned null by the parser.", items, item.getHeader().getType());
                                    break block28;
                                } else {
                                    if (envelope.getHeader().getEventId() != null && !envelope.getHeader().getEventId().equals(event.getEventId())) {
                                        this.logger.log(SentryLevel.ERROR, "Item %d of has a different event id (%s) to the envelope header (%s)", items, envelope.getHeader().getEventId(), event.getEventId());
                                        continue;
                                    }
                                    this.hub.captureEvent(event, hint);
                                    this.logger.log(SentryLevel.DEBUG, "Item %d is being captured.", items);
                                    if (hint instanceof Flushable && !((Flushable)hint).waitFlush()) {
                                        this.logger.log(SentryLevel.WARNING, "Timed out waiting for event submission: %s", event.getEventId());
                                        return;
                                    }
                                }
                                break block28;
                            }
                            catch (Throwable event) {
                                throwable = event;
                                throw event;
                            }
                            finally {
                                EnvelopeSender.$closeResource(throwable, eventReader);
                                continue;
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(SentryLevel.ERROR, "Item failed to process.", e);
                            break block28;
                        }
                    }
                    if (SentryEnvelopeItemType.Session.getType().equals(item.getHeader().getType())) {
                        try {
                            throwable = null;
                            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(item.getData()), UTF_8));){
                                Session session = this.serializer.deserializeSession(reader);
                                if (session == null) {
                                    this.logger.log(SentryLevel.ERROR, "Item %d of type %s returned null by the parser.", items, item.getHeader().getType());
                                } else {
                                    this.hub.captureEnvelope(SentryEnvelope.fromSession(this.serializer, session), hint);
                                    this.logger.log(SentryLevel.DEBUG, "Item %d is being captured.", items);
                                    if (hint instanceof Flushable && !((Flushable)hint).waitFlush()) {
                                        this.logger.log(SentryLevel.WARNING, "Timed out waiting for item submission: %s", session.getSessionId());
                                        return;
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Exception e) {
                            this.logger.log(SentryLevel.ERROR, "Item failed to process.", e);
                        }
                    } else {
                        this.logger.log(SentryLevel.WARNING, "Item %d of type: %s ignored.", items, item.getHeader().getType());
                    }
                }
                if (!(hint instanceof SubmissionResult) || ((SubmissionResult)hint).isSuccess()) {
                    continue;
                }
                break block29;
            }
            return;
        }
        this.logger.log(SentryLevel.WARNING, "Envelope for event Id: %s had a failed capture at item %d. No more items will be sent.", envelope.getHeader().getEventId(), items);
    }
}

