/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.SentryStackTraceFactory;
import io.sentry.core.protocol.SentryStackFrame;
import io.sentry.core.protocol.SentryStackTrace;
import io.sentry.core.protocol.SentryThread;
import io.sentry.core.util.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

final class SentryThreadFactory {
    private final SentryStackTraceFactory sentryStackTraceFactory;

    public SentryThreadFactory(SentryStackTraceFactory sentryStackTraceFactory) {
        this.sentryStackTraceFactory = Objects.requireNonNull(sentryStackTraceFactory, "The SentryStackTraceFactory is required.");
    }

    List<SentryThread> getCurrentThreadsForCrash() {
        return this.getCurrentThreads(Thread.currentThread().getId());
    }

    List<SentryThread> getCurrentThreads() {
        return this.getCurrentThreads(null);
    }

    List<SentryThread> getCurrentThreads(@Nullable Long crashedThreadId) {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        ArrayList<SentryThread> result = new ArrayList<SentryThread>();
        Thread currentThread = Thread.currentThread();
        for (Map.Entry<Thread, StackTraceElement[]> item : threads.entrySet()) {
            result.add(this.getSentryThread(crashedThreadId, currentThread, item.getValue(), item.getKey()));
        }
        return result;
    }

    private SentryThread getSentryThread(@Nullable Long crashedThreadId, Thread currentThread, StackTraceElement[] stackFramesElements, Thread thread) {
        SentryThread sentryThread = new SentryThread();
        sentryThread.setName(thread.getName());
        sentryThread.setPriority(thread.getPriority());
        sentryThread.setId(thread.getId());
        sentryThread.setDaemon(thread.isDaemon());
        sentryThread.setState(thread.getState().name());
        if (crashedThreadId != null) {
            sentryThread.setCrashed(crashedThreadId.longValue() == thread.getId());
        }
        sentryThread.setErrored(thread == currentThread);
        List<SentryStackFrame> frames = this.sentryStackTraceFactory.getStackFrames(stackFramesElements);
        if (frames.size() > 0) {
            sentryThread.setStacktrace(new SentryStackTrace(frames));
        }
        return sentryThread;
    }
}

