/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.AsyncConnectionFactory;
import io.sentry.core.Breadcrumb;
import io.sentry.core.EventProcessor;
import io.sentry.core.ILogger;
import io.sentry.core.ISentryClient;
import io.sentry.core.Scope;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.cache.DiskCache;
import io.sentry.core.hints.Cached;
import io.sentry.core.protocol.SentryId;
import io.sentry.core.transport.Connection;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.Nullable;

public final class SentryClient
implements ISentryClient {
    static final String SENTRY_PROTOCOL_VERSION = "7";
    private boolean enabled;
    private final SentryOptions options;
    private final Connection connection;
    private final Random random;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    SentryClient(SentryOptions options) {
        this(options, null);
    }

    public SentryClient(SentryOptions options, @Nullable Connection connection) {
        this.options = options;
        this.enabled = true;
        if (connection == null) {
            DiskCache cache = new DiskCache(options);
            connection = AsyncConnectionFactory.create(options, cache);
        }
        this.connection = connection;
        this.random = options.getSampling() == null ? null : new Random();
    }

    @Override
    public SentryId captureEvent(SentryEvent event, @Nullable Scope scope, @Nullable Object hint) {
        if (!this.sample()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "Event %s was dropped due to sampling decision.", event.getEventId());
            return SentryId.EMPTY_ID;
        }
        ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "Capturing event: %s", event.getEventId());
        if (!(hint instanceof Cached)) {
            this.applyScope(event, scope);
        } else {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "Event was cached so not applying scope: %s", event.getEventId());
        }
        for (EventProcessor processor : this.options.getEventProcessors()) {
            processor.process(event, hint);
        }
        if ((event = this.executeBeforeSend(event, hint)) == null) {
            return SentryId.EMPTY_ID;
        }
        try {
            this.connection.send(event, hint);
        }
        catch (IOException e) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Capturing event " + event.getEventId() + " failed.", e);
        }
        return event.getEventId();
    }

    private void applyScope(SentryEvent event, @Nullable Scope scope) {
        if (scope != null) {
            if (event.getTransaction() == null) {
                event.setTransaction(scope.getTransaction());
            }
            if (event.getUser() == null) {
                event.setUser(scope.getUser());
            }
            if (event.getFingerprints() == null) {
                event.setFingerprints(scope.getFingerprint());
            }
            if (event.getBreadcrumbs() == null) {
                event.setBreadcrumbs(new ArrayList<Breadcrumb>(scope.getBreadcrumbs()));
            } else {
                event.getBreadcrumbs().addAll(scope.getBreadcrumbs());
            }
            if (event.getTags() == null) {
                event.setTags(new HashMap<String, String>(scope.getTags()));
            } else {
                for (Map.Entry<String, String> entry : scope.getTags().entrySet()) {
                    if (event.getTags().containsKey(entry.getKey())) continue;
                    event.getTags().put(entry.getKey(), entry.getValue());
                }
            }
            if (event.getExtras() == null) {
                event.setExtras(new HashMap<String, Object>(scope.getExtras()));
            } else {
                for (Map.Entry<String, Object> entry : scope.getExtras().entrySet()) {
                    if (event.getExtras().containsKey(entry.getKey())) continue;
                    event.getExtras().put(entry.getKey(), entry.getValue());
                }
            }
            if (scope.getLevel() != null) {
                event.setLevel(scope.getLevel());
            }
        }
    }

    private SentryEvent executeBeforeSend(SentryEvent event, @Nullable Object hint) {
        SentryOptions.BeforeSendCallback beforeSend = this.options.getBeforeSend();
        if (beforeSend != null) {
            try {
                event = beforeSend.execute(event, hint);
            }
            catch (Exception e) {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "The BeforeSend callback threw an exception. It will be added as breadcrumb and continue.", e);
                Breadcrumb breadcrumb = new Breadcrumb();
                breadcrumb.setMessage("BeforeSend callback failed.");
                breadcrumb.setCategory("SentryClient");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("sentry:message", e.getMessage());
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                data.put("sentry:stacktrace", sw.toString());
                breadcrumb.setLevel(SentryLevel.ERROR);
                breadcrumb.setData(data);
                event.addBreadcrumb(breadcrumb);
            }
        }
        return event;
    }

    @Override
    public void close() {
        ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.INFO, "Closing SDK.", new Object[0]);
        try {
            this.flush(this.options.getShutdownTimeout());
            this.connection.close();
        }
        catch (IOException e) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Failed to close the connection to the Sentry Server.", e);
        }
        this.enabled = false;
    }

    @Override
    public void flush(long timeoutMills) {
    }

    private boolean sample() {
        double sampling;
        return this.options.getSampling() == null || this.random == null || !((sampling = this.options.getSampling().doubleValue()) < this.random.nextDouble());
    }
}

