/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.InvalidDsnException;
import java.net.URI;

final class Dsn {
    private final String projectId;
    private final String path;
    private final String secretKey;
    private final String publicKey;
    private final URI sentryUri;

    public String getProjectId() {
        return this.projectId;
    }

    public String getPath() {
        return this.path;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    URI getSentryUri() {
        return this.sentryUri;
    }

    Dsn(String dsn) throws InvalidDsnException {
        try {
            URI uri = new URI(dsn);
            String userInfo = uri.getUserInfo();
            if (userInfo == null || userInfo.isEmpty()) {
                throw new IllegalArgumentException("Invalid DSN: No public key provided.");
            }
            String[] keys = userInfo.split(":", -1);
            this.publicKey = keys[0];
            if (this.publicKey == null || this.publicKey.isEmpty()) {
                throw new IllegalArgumentException("Invalid DSN: No public key provided.");
            }
            this.secretKey = keys.length > 1 ? keys[1] : null;
            String uriPath = uri.getPath();
            int projectIdStart = uriPath.lastIndexOf("/") + 1;
            this.path = uriPath.substring(0, projectIdStart);
            this.projectId = uriPath.substring(projectIdStart);
            if (this.projectId.isEmpty()) {
                throw new IllegalArgumentException("Invalid DSN: A Project Id is required.");
            }
            this.sentryUri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), this.path + "/api/" + this.projectId + "/store/", null, null);
        }
        catch (Exception e) {
            throw new InvalidDsnException(dsn, e);
        }
    }
}

