/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.ILogger;
import io.sentry.core.SentryLevel;
import java.io.File;
import org.jetbrains.annotations.NotNull;

abstract class DirectoryProcessor {
    private ILogger logger;

    protected DirectoryProcessor(@NotNull ILogger logger) {
        this.logger = logger;
    }

    void processDirectory(@NotNull File directory) {
        try {
            if (!directory.exists()) {
                ILogger.logIfNotNull(this.logger, SentryLevel.WARNING, "Directory '%s' doesn't exist. No cached events to send.", directory.getAbsolutePath());
                return;
            }
            if (!directory.isDirectory()) {
                ILogger.logIfNotNull(this.logger, SentryLevel.ERROR, "Cache dir %s is not a directory.", directory.getAbsolutePath());
                return;
            }
            File[] listFiles = directory.listFiles();
            if (listFiles == null) {
                ILogger.logIfNotNull(this.logger, SentryLevel.ERROR, "Cache dir %s is null.", directory.getAbsolutePath());
                return;
            }
            File[] filteredListFiles = directory.listFiles((d, name) -> this.isRelevantFileName(name));
            ILogger.logIfNotNull(this.logger, SentryLevel.DEBUG, "Processing %d items from cache dir %s", filteredListFiles != null ? filteredListFiles.length : 0, directory.getAbsolutePath());
            for (File file : listFiles) {
                this.processFile(file);
            }
        }
        catch (Exception e) {
            ILogger.logIfNotNull(this.logger, SentryLevel.ERROR, e, "Failed processing '%s'", directory.getAbsolutePath());
        }
    }

    protected abstract void processFile(File var1);

    protected abstract boolean isRelevantFileName(String var1);
}

