/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core.transport;

import io.sentry.core.ILogger;
import io.sentry.core.ISerializer;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.transport.IConnectionConfigurator;
import io.sentry.core.transport.ITransport;
import io.sentry.core.transport.TransportResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import javax.net.ssl.HttpsURLConnection;
import org.jetbrains.annotations.Nullable;

public class HttpTransport
implements ITransport {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @Nullable
    private final Proxy proxy;
    private final IConnectionConfigurator connectionConfigurator;
    private final ISerializer serializer;
    private final int connectionTimeout;
    private final int readTimeout;
    private final boolean bypassSecurity;
    private final URL sentryUrl;
    private final SentryOptions options;

    public HttpTransport(SentryOptions options, IConnectionConfigurator connectionConfigurator, int connectionTimeoutMills, int readTimeoutMills, boolean bypassSecurity, URL sentryUrl) {
        this.proxy = options.getProxy();
        this.connectionConfigurator = connectionConfigurator;
        this.serializer = options.getSerializer();
        this.connectionTimeout = connectionTimeoutMills;
        this.readTimeout = readTimeoutMills;
        this.options = options;
        this.bypassSecurity = bypassSecurity;
        this.sentryUrl = sentryUrl;
    }

    protected HttpURLConnection open(URL url, Proxy proxy) throws IOException {
        return (HttpURLConnection)(proxy == null ? this.sentryUrl.openConnection() : this.sentryUrl.openConnection(proxy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public TransportResult send(SentryEvent event) throws IOException {
        HttpURLConnection connection = this.open(this.sentryUrl, this.proxy);
        this.connectionConfigurator.configure(connection);
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Encoding", "UTF-8");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Connection", "close");
        connection.setConnectTimeout(this.connectionTimeout);
        connection.setReadTimeout(this.readTimeout);
        if (this.bypassSecurity && connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setHostnameVerifier((__, ___) -> true);
        }
        connection.connect();
        try {
            TransportResult transportResult;
            Throwable throwable;
            OutputStream outputStream;
            block25: {
                block26: {
                    outputStream = connection.getOutputStream();
                    throwable = null;
                    this.serializer.serialize(event, new OutputStreamWriter(outputStream, UTF_8));
                    connection.getInputStream().close();
                    transportResult = TransportResult.success();
                    if (outputStream == null) break block25;
                    if (throwable == null) break block26;
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block25;
                }
                outputStream.close();
            }
            return transportResult;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                outputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    long retryAfterMs = 1000L;
                    String retryAfterHeader = connection.getHeaderField("Retry-After");
                    if (retryAfterHeader != null) {
                        try {
                            retryAfterMs = (long)(Double.parseDouble(retryAfterHeader) * 1000.0);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    int responseCode = -1;
                    try {
                        responseCode = connection.getResponseCode();
                        if (responseCode == 403 && this.options.isDebug()) {
                            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "Event '" + event.getEventId() + "' was rejected by the Sentry server due to a filter.", new Object[0]);
                        }
                        this.logErrorInPayload(connection);
                        TransportResult transportResult2 = TransportResult.error(retryAfterMs, responseCode);
                        return transportResult2;
                    }
                    catch (IOException responseCodeException) {
                        ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Failed to obtain response code while analyzing event send failure.", e);
                        this.logErrorInPayload(connection);
                        TransportResult transportResult3 = TransportResult.error(retryAfterMs, responseCode);
                        return transportResult3;
                    }
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private void logErrorInPayload(HttpURLConnection connection) {
        if (this.options.isDebug()) {
            String errorMessage = null;
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                errorMessage = this.getErrorMessageFromStream(errorStream);
            }
            if (null == errorMessage || errorMessage.isEmpty()) {
                errorMessage = "An exception occurred while submitting the event to the Sentry server.";
            }
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, errorMessage, new Object[0]);
        }
    }

    private String getErrorMessageFromStream(InputStream errorStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(errorStream, UTF_8));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            boolean first = true;
            while ((line = reader.readLine()) != null) {
                if (!first) {
                    sb.append("\n");
                }
                sb.append(line);
                first = false;
            }
        }
        catch (Exception e2) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Exception while reading the error message from the connection: " + e2.getMessage(), new Object[0]);
        }
        return sb.toString();
    }

    @Override
    public void close() throws IOException {
    }
}

