/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.Breadcrumb;
import io.sentry.core.IHub;
import io.sentry.core.ILogger;
import io.sentry.core.ISentryClient;
import io.sentry.core.Integration;
import io.sentry.core.NoOpSentryClient;
import io.sentry.core.Scope;
import io.sentry.core.ScopeCallback;
import io.sentry.core.SentryClient;
import io.sentry.core.SentryEvent;
import io.sentry.core.SentryLevel;
import io.sentry.core.SentryOptions;
import io.sentry.core.protocol.SentryId;
import io.sentry.core.util.Objects;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Hub
implements IHub {
    @NotNull
    private volatile SentryId lastEventId;
    @NotNull
    private final SentryOptions options;
    private volatile boolean isEnabled;
    private final Deque<StackItem> stack = new LinkedBlockingDeque<StackItem>();

    public Hub(@NotNull SentryOptions options) {
        this(options, Hub.createRootStackItem(options));
        for (Integration integration : options.getIntegrations()) {
            integration.register(this, options);
        }
    }

    private Hub(@NotNull SentryOptions options, @Nullable StackItem rootStackItem) {
        Hub.validateOptions(options);
        this.options = options;
        if (rootStackItem != null) {
            this.stack.push(rootStackItem);
        }
        this.lastEventId = SentryId.EMPTY_ID;
        this.isEnabled = true;
    }

    private static void validateOptions(@NotNull SentryOptions options) {
        Objects.requireNonNull(options, "SentryOptions is required.");
        if (options.getDsn() == null || options.getDsn().isEmpty()) {
            throw new IllegalArgumentException("Hub requires a DSN to be instantiated. Considering using the NoOpHub is no DSN is available.");
        }
    }

    private static StackItem createRootStackItem(@NotNull SentryOptions options) {
        Hub.validateOptions(options);
        Scope scope = new Scope(options.getMaxBreadcrumbs());
        SentryClient client = new SentryClient(options);
        return new StackItem(client, scope);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @NotNull
    public SentryId captureEvent(SentryEvent event, @Nullable Object hint) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'captureEvent' call is a no-op.", new Object[0]);
        } else if (event == null) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "captureEvent called with null parameter.", new Object[0]);
        } else {
            try {
                StackItem item = this.stack.peek();
                if (item != null) {
                    sentryId = item.client.captureEvent(event, item.scope, hint);
                } else {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when captureEvent", new Object[0]);
                }
            }
            catch (Exception e) {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Error while capturing event with id: " + event.getEventId(), e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @NotNull
    public SentryId captureMessage(String message) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'captureMessage' call is a no-op.", new Object[0]);
        } else if (message == null) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "captureMessage called with null parameter.", new Object[0]);
        } else {
            try {
                StackItem item = this.stack.peek();
                if (item != null) {
                    sentryId = item.client.captureMessage(message, item.scope);
                } else {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when captureMessage", new Object[0]);
                }
            }
            catch (Exception e) {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Error while capturing message: " + message, e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    @NotNull
    public SentryId captureException(Throwable throwable, @Nullable Object hint) {
        SentryId sentryId = SentryId.EMPTY_ID;
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'captureException' call is a no-op.", new Object[0]);
        } else if (throwable == null) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "captureException called with null parameter.", new Object[0]);
        } else {
            try {
                StackItem item = this.stack.peek();
                if (item != null) {
                    sentryId = item.client.captureException(throwable, item.scope, hint);
                } else {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when captureException", new Object[0]);
                }
            }
            catch (Exception e) {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Error while capturing message: " + throwable.getMessage(), e);
            }
        }
        this.lastEventId = sentryId;
        return sentryId;
    }

    @Override
    public void close() {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'close' call is a no-op.", new Object[0]);
        } else {
            try {
                for (Integration integration : this.options.getIntegrations()) {
                    if (!(integration instanceof Closeable)) continue;
                    ((Closeable)((Object)integration)).close();
                }
                StackItem item = this.stack.peek();
                if (item != null) {
                    item.client.close();
                } else {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was NULL when closing Hub", new Object[0]);
                }
            }
            catch (Exception e) {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Error while closing the Hub.", e);
            }
            this.isEnabled = false;
        }
    }

    @Override
    public void addBreadcrumb(Breadcrumb breadcrumb, @Nullable Object hint) {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'addBreadcrumb' call is a no-op.", new Object[0]);
        } else if (breadcrumb == null) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "addBreadcrumb called with null parameter.", new Object[0]);
        } else {
            StackItem item = this.stack.peek();
            if (item != null) {
                SentryOptions.BeforeBreadcrumbCallback callback = this.options.getBeforeBreadcrumb();
                if (callback != null) {
                    breadcrumb = this.executeBeforeBreadcrumb(callback, breadcrumb, hint);
                }
                if (breadcrumb != null) {
                    item.scope.addBreadcrumb(breadcrumb);
                }
            } else {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when addBreadcrumb", new Object[0]);
            }
        }
    }

    private Breadcrumb executeBeforeBreadcrumb(SentryOptions.BeforeBreadcrumbCallback callback, Breadcrumb breadcrumb, @Nullable Object hint) {
        try {
            breadcrumb = callback.execute(breadcrumb, hint);
        }
        catch (Exception e) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "The BeforeBreadcrumbCallback callback threw an exception. It will be added as breadcrumb and continue.", e);
            Map<String, String> data = breadcrumb.getData();
            if (breadcrumb.getData() == null) {
                data = new HashMap<String, String>();
            }
            data.put("sentry:message", e.getMessage());
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            data.put("sentry:stacktrace", sw.toString());
            breadcrumb.setData(data);
        }
        return breadcrumb;
    }

    @Override
    @NotNull
    public SentryId getLastEventId() {
        return this.lastEventId;
    }

    @Override
    public void pushScope() {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'addBreadcrumb' call is a no-op.", new Object[0]);
        } else {
            StackItem item = this.stack.peek();
            if (item != null) {
                Scope clone = null;
                try {
                    clone = item.scope.clone();
                }
                catch (CloneNotSupportedException e) {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "An error has occurred when cloning a Scope", e);
                }
                if (clone != null) {
                    StackItem newItem = new StackItem(item.client, clone);
                    this.stack.push(newItem);
                }
            } else {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was NULL when pushScope", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popScope() {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'popScope' call is a no-op.", new Object[0]);
        } else {
            Deque<StackItem> deque = this.stack;
            synchronized (deque) {
                if (this.stack.size() != 1) {
                    this.stack.pop();
                } else {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Attempt to pop the root scope.", new Object[0]);
                }
            }
        }
    }

    @Override
    public void withScope(@NotNull ScopeCallback callback) {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'withScope' call is a no-op.", new Object[0]);
        } else {
            this.pushScope();
            StackItem item = this.stack.peek();
            if (item != null) {
                try {
                    callback.run(item.scope);
                }
                catch (Exception e) {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Error in the 'withScope' callback.", e);
                }
            } else {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when withScope", new Object[0]);
            }
            this.popScope();
        }
    }

    @Override
    public void configureScope(@NotNull ScopeCallback callback) {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'withScope' call is a no-op.", new Object[0]);
        } else {
            StackItem item = this.stack.peek();
            if (item != null) {
                try {
                    callback.run(item.scope);
                }
                catch (Exception e) {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Error in the 'configureScope' callback.", e);
                }
            } else {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when configureScope", new Object[0]);
            }
        }
    }

    @Override
    public void bindClient(ISentryClient client) {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'bindClient' call is a no-op.", new Object[0]);
        } else {
            StackItem item = this.stack.peek();
            if (item != null) {
                if (client != null) {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "New client bound to scope.", new Object[0]);
                    item.client = client;
                } else {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.DEBUG, "NoOp client bound to scope.", new Object[0]);
                    item.client = NoOpSentryClient.getInstance();
                }
            } else {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when bindClient", new Object[0]);
            }
        }
    }

    @Override
    public void flush(long timeoutMills) {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Instance is disabled and this 'flush' call is a no-op.", new Object[0]);
        } else {
            StackItem item = this.stack.peek();
            if (item != null) {
                try {
                    item.client.flush(timeoutMills);
                }
                catch (Exception e) {
                    ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.ERROR, "Error in the 'client.flush'.", e);
                }
            } else {
                ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.FATAL, "Stack peek was null when flush", new Object[0]);
            }
        }
    }

    @Override
    @NotNull
    public IHub clone() {
        if (!this.isEnabled()) {
            ILogger.logIfNotNull(this.options.getLogger(), SentryLevel.WARNING, "Disabled Hub cloned.", new Object[0]);
        }
        Hub clone = new Hub(this.options, null);
        for (StackItem item : this.stack) {
            clone.stack.push(item);
        }
        return clone;
    }

    private static final class StackItem {
        @NotNull
        private volatile ISentryClient client;
        @NotNull
        private volatile Scope scope;

        StackItem(@NotNull ISentryClient client, @NotNull Scope scope) {
            this.client = client;
            this.scope = scope;
        }
    }
}

