/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.core;

import io.sentry.core.DateUtils;
import io.sentry.core.IUnknownPropertiesConsumer;
import io.sentry.core.SentryLevel;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Breadcrumb
implements Cloneable,
IUnknownPropertiesConsumer {
    private Date timestamp;
    private String message;
    private String type;
    private Map<String, String> data;
    private String category;
    private SentryLevel level;
    private Map<String, Object> unknown;

    Breadcrumb(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Breadcrumb() {
        this(DateUtils.getCurrentDateTime());
    }

    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = data;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(SentryLevel level) {
        this.level = level;
    }

    @Override
    public void acceptUnknownProperties(Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    Map<String, Object> getUnknown() {
        return this.unknown;
    }

    public Breadcrumb clone() throws CloneNotSupportedException {
        Breadcrumb clone = (Breadcrumb)super.clone();
        Date date = clone.timestamp = this.timestamp != null ? (Date)this.timestamp.clone() : null;
        if (this.data != null) {
            ConcurrentHashMap<String, String> dataClone = new ConcurrentHashMap<String, String>();
            for (Map.Entry<String, String> entry : this.data.entrySet()) {
                if (entry == null) continue;
                dataClone.put(entry.getKey(), entry.getValue());
            }
            clone.data = dataClone;
        } else {
            clone.data = null;
        }
        if (this.unknown != null) {
            HashMap<String, Object> unknownClone = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : this.unknown.entrySet()) {
                if (entry == null) continue;
                unknownClone.put(entry.getKey(), entry.getValue());
            }
            clone.unknown = unknownClone;
        } else {
            clone.unknown = null;
        }
        clone.level = this.level != null ? SentryLevel.valueOf(this.level.name().toUpperCase(Locale.ROOT)) : null;
        return clone;
    }
}

