/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose.viewhierarchy;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import io.sentry.ILogger;
import io.sentry.compose.SentryComposeHelper;
import io.sentry.internal.viewhierarchy.ViewHierarchyExporter;
import io.sentry.protocol.ViewHierarchyNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposeViewHierarchyExporter
implements ViewHierarchyExporter {
    @NotNull
    private final ILogger logger;
    @Nullable
    private volatile SentryComposeHelper composeHelper;

    public ComposeViewHierarchyExporter(@NotNull ILogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(@NotNull ViewHierarchyNode parent, @NotNull Object element) {
        if (!(element instanceof Owner)) {
            return false;
        }
        if (this.composeHelper == null) {
            ComposeViewHierarchyExporter composeViewHierarchyExporter = this;
            synchronized (composeViewHierarchyExporter) {
                if (this.composeHelper == null) {
                    this.composeHelper = new SentryComposeHelper(this.logger);
                }
            }
        }
        LayoutNode rootNode = ((Owner)element).getRoot();
        ComposeViewHierarchyExporter.addChild(this.composeHelper, parent, null, rootNode);
        return true;
    }

    private static void addChild(@NotNull SentryComposeHelper composeHelper, @NotNull ViewHierarchyNode parent, @Nullable LayoutNode parentNode, @NotNull LayoutNode node) {
        if (node.isPlaced()) {
            ViewHierarchyNode vhNode = new ViewHierarchyNode();
            ComposeViewHierarchyExporter.setTag(node, vhNode);
            ComposeViewHierarchyExporter.setBounds(composeHelper, node, parentNode, vhNode);
            if (vhNode.getTag() != null) {
                vhNode.setType(vhNode.getTag());
            } else {
                vhNode.setType("@Composable");
            }
            if (parent.getChildren() == null) {
                parent.setChildren(new ArrayList());
            }
            parent.getChildren().add(vhNode);
            MutableVector children = node.getZSortedChildren();
            int childrenCount = children.getSize();
            for (int i = 0; i < childrenCount; ++i) {
                LayoutNode child = (LayoutNode)children.get(i);
                ComposeViewHierarchyExporter.addChild(composeHelper, vhNode, node, child);
            }
        }
    }

    private static void setTag(@NotNull LayoutNode node, @NotNull ViewHierarchyNode vhNode) {
        List modifiers = node.getModifierInfo();
        for (ModifierInfo modifierInfo : modifiers) {
            if (!(modifierInfo.getModifier() instanceof SemanticsModifier)) continue;
            SemanticsModifier semanticsModifierCore = (SemanticsModifier)modifierInfo.getModifier();
            SemanticsConfiguration semanticsConfiguration = semanticsModifierCore.getSemanticsConfiguration();
            for (Map.Entry entry : semanticsConfiguration) {
                String key = ((SemanticsPropertyKey)entry.getKey()).getName();
                if (!"SentryTag".equals(key) && !"TestTag".equals(key) || !(entry.getValue() instanceof String)) continue;
                vhNode.setTag((String)entry.getValue());
            }
        }
    }

    private static void setBounds(@NotNull SentryComposeHelper composeHelper, @NotNull LayoutNode node, @Nullable LayoutNode parentNode, @NotNull ViewHierarchyNode vhNode) {
        int nodeHeight = node.getHeight();
        int nodeWidth = node.getWidth();
        vhNode.setHeight(Double.valueOf(nodeHeight));
        vhNode.setWidth(Double.valueOf(nodeWidth));
        Rect bounds = composeHelper.getLayoutNodeBoundsInWindow(node);
        if (bounds != null) {
            Rect parentBounds;
            double x = bounds.getLeft();
            double y = bounds.getTop();
            if (parentNode != null && (parentBounds = composeHelper.getLayoutNodeBoundsInWindow(parentNode)) != null) {
                x -= (double)parentBounds.getLeft();
                y -= (double)parentBounds.getTop();
            }
            vhNode.setX(Double.valueOf(x));
            vhNode.setY(Double.valueOf(y));
        }
    }
}

