/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.compose.gestures;

import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.ModifierInfo;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsModifier;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import io.sentry.ILogger;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.compose.SentryComposeHelper;
import io.sentry.internal.gestures.GestureTargetLocator;
import io.sentry.internal.gestures.UiElement;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposeGestureTargetLocator
implements GestureTargetLocator {
    @NotNull
    private final ILogger logger;
    @Nullable
    private volatile SentryComposeHelper composeHelper;

    public ComposeGestureTargetLocator(@NotNull ILogger logger) {
        this.logger = logger;
        SentryIntegrationPackageStorage.getInstance().addIntegration("ComposeUserInteraction");
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-compose", "6.26.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public UiElement locate(@NotNull Object root, float x, float y, UiElement.Type targetType) {
        if (this.composeHelper == null) {
            ComposeGestureTargetLocator composeGestureTargetLocator = this;
            synchronized (composeGestureTargetLocator) {
                if (this.composeHelper == null) {
                    this.composeHelper = new SentryComposeHelper(this.logger);
                }
            }
        }
        String targetTag = null;
        if (!(root instanceof Owner)) {
            return null;
        }
        LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
        queue.add(((Owner)root).getRoot());
        while (!queue.isEmpty()) {
            LayoutNode node = (LayoutNode)queue.poll();
            if (node == null) continue;
            if (node.isPlaced() && ComposeGestureTargetLocator.layoutNodeBoundsContain(this.composeHelper, node, x, y)) {
                boolean isClickable = false;
                boolean isScrollable = false;
                String testTag = null;
                List modifiers = node.getModifierInfo();
                for (ModifierInfo modifierInfo : modifiers) {
                    if (!(modifierInfo.getModifier() instanceof SemanticsModifier)) continue;
                    SemanticsModifier semanticsModifierCore = (SemanticsModifier)modifierInfo.getModifier();
                    SemanticsConfiguration semanticsConfiguration = semanticsModifierCore.getSemanticsConfiguration();
                    for (Map.Entry entry : semanticsConfiguration) {
                        String key = ((SemanticsPropertyKey)entry.getKey()).getName();
                        if ("ScrollBy".equals(key)) {
                            isScrollable = true;
                            continue;
                        }
                        if ("OnClick".equals(key)) {
                            isClickable = true;
                            continue;
                        }
                        if (!"SentryTag".equals(key) && !"TestTag".equals(key) || !(entry.getValue() instanceof String)) continue;
                        testTag = (String)entry.getValue();
                    }
                }
                if (isClickable && targetType == UiElement.Type.CLICKABLE) {
                    targetTag = testTag;
                }
                if (isScrollable && targetType == UiElement.Type.SCROLLABLE) {
                    targetTag = testTag;
                    break;
                }
            }
            queue.addAll(node.getZSortedChildren().asMutableList());
        }
        if (targetTag == null) {
            return null;
        }
        return new UiElement(null, null, null, targetTag);
    }

    private static boolean layoutNodeBoundsContain(@NotNull SentryComposeHelper composeHelper, @NotNull LayoutNode node, float x, float y) {
        Rect bounds = composeHelper.getLayoutNodeBoundsInWindow(node);
        if (bounds == null) {
            return false;
        }
        return x >= bounds.getLeft() && x <= bounds.getRight() && y >= bounds.getTop() && y <= bounds.getBottom();
    }
}

