/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.ReplayBreadcrumbConverter;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.DefaultReplayBreadcrumbConverter;
import io.sentry.rrweb.RRWebBreadcrumbEvent;
import io.sentry.rrweb.RRWebEvent;
import io.sentry.rrweb.RRWebSpanEvent;
import io.sentry.util.network.NetworkBody;
import io.sentry.util.network.NetworkRequestData;
import io.sentry.util.network.ReplayNetworkRequestOrResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0002\u0016\u0017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\f\u0010\u0011\u001a\u00020\u0012*\u00020\bH\u0002J\f\u0010\u0013\u001a\u00020\r*\u00020\rH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\bH\u0002RN\u0010\u0006\u001aB\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n \t* \u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n\u0018\u00010\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/sentry/android/replay/DefaultReplayBreadcrumbConverter;", "Lio/sentry/ReplayBreadcrumbConverter;", "options", "Lio/sentry/SentryOptions;", "(Lio/sentry/SentryOptions;)V", "()V", "httpNetworkDetails", "", "Lio/sentry/Breadcrumb;", "kotlin.jvm.PlatformType", "Lio/sentry/util/network/NetworkRequestData;", "", "lastConnectivityState", "", "convert", "Lio/sentry/rrweb/RRWebEvent;", "breadcrumb", "isValidForRRWebSpan", "", "snakeToCamelCase", "toRRWebSpanEvent", "Lio/sentry/rrweb/RRWebSpanEvent;", "Companion", "ReplayBeforeBreadcrumbCallback", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDefaultReplayBreadcrumbConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultReplayBreadcrumbConverter.kt\nio/sentry/android/replay/DefaultReplayBreadcrumbConverter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n478#2,7:294\n1#3:301\n1549#4:302\n1620#4,3:303\n1549#4:306\n1620#4,3:307\n*S KotlinDebug\n*F\n+ 1 DefaultReplayBreadcrumbConverter.kt\nio/sentry/android/replay/DefaultReplayBreadcrumbConverter\n*L\n169#1:294,7\n247#1:302\n247#1:303,3\n266#1:306\n266#1:307,3\n*E\n"})
public class DefaultReplayBreadcrumbConverter
implements ReplayBreadcrumbConverter {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private SentryOptions options;
    @Nullable
    private String lastConnectivityState;
    private final Map<Breadcrumb, NetworkRequestData> httpNetworkDetails;
    public static final int $stable;
    private static final int MAX_HTTP_NETWORK_DETAILS = 32;
    @NotNull
    private static final Lazy<Regex> snakecasePattern$delegate;
    @NotNull
    private static final HashSet<String> supportedNetworkData;

    public DefaultReplayBreadcrumbConverter() {
        this.httpNetworkDetails = Collections.synchronizedMap(new LinkedHashMap<Breadcrumb, NetworkRequestData>(){

            protected boolean removeEldestEntry(Map.Entry<Breadcrumb, NetworkRequestData> eldest) {
                return this.size() > 32;
            }
        });
    }

    public DefaultReplayBreadcrumbConverter(@NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this();
        SentryOptions sentryOptions = this.options = options;
        if (sentryOptions != null) {
            sentryOptions.setBeforeBreadcrumb((SentryOptions.BeforeBreadcrumbCallback)new ReplayBeforeBreadcrumbCallback(options.getBeforeBreadcrumb()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public RRWebEvent convert(@NotNull Breadcrumb breadcrumb) {
        RRWebBreadcrumbEvent rRWebBreadcrumbEvent;
        Intrinsics.checkNotNullParameter((Object)breadcrumb, (String)"breadcrumb");
        String breadcrumbMessage = null;
        String breadcrumbCategory = null;
        SentryLevel breadcrumbLevel = null;
        Map breadcrumbData = new LinkedHashMap();
        if (Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"http")) {
            if (!this.isValidForRRWebSpan(breadcrumb)) return null;
            RRWebEvent rRWebEvent = (RRWebEvent)this.toRRWebSpanEvent(breadcrumb);
            return rRWebEvent;
        }
        if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"navigation") && Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"app.lifecycle")) {
            breadcrumbCategory = "app." + breadcrumb.getData().get("state");
        } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"navigation") && Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"device.orientation")) {
            String string = breadcrumb.getCategory();
            Intrinsics.checkNotNull((Object)string);
            breadcrumbCategory = string;
            Object v = breadcrumb.getData().get("position");
            if (!Intrinsics.areEqual(v, (Object)"landscape")) {
                if (!Intrinsics.areEqual(v, (Object)"portrait")) return null;
            }
            breadcrumbData.put("position", v);
        } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"navigation")) {
            String string;
            breadcrumbCategory = "navigation";
            Map map = breadcrumbData;
            String string2 = "to";
            if (Intrinsics.areEqual(breadcrumb.getData().get("state"), (Object)"resumed")) {
                Object v = breadcrumb.getData().get("screen");
                if (!(v instanceof String)) return null;
                String string3 = (String)v;
                if (string3 == null) return null;
                string = StringsKt.substringAfterLast$default((String)string3, (char)'.', null, (int)2, null);
            } else {
                Map map2 = breadcrumb.getData();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getData(...)");
                Map map3 = map2;
                if (!map3.containsKey("to")) return null;
                Object v = breadcrumb.getData().get("to");
                if (!(v instanceof String)) return null;
                string = (String)v;
            }
            if (string == null) {
                return null;
            }
            String string4 = string;
            map.put(string2, string4);
        } else if (Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"ui.click")) {
            Object v;
            breadcrumbCategory = "ui.tap";
            Object v2 = breadcrumb.getData().get("view.id");
            if (v2 == null && (v2 = breadcrumb.getData().get("view.tag")) == null) {
                v2 = breadcrumb.getData().get("view.class");
            }
            if (!((v = v2) instanceof String)) return null;
            String string = (String)v;
            if (string == null) {
                return null;
            }
            breadcrumbMessage = string;
            Map map = breadcrumb.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
            breadcrumbData.putAll(map);
        } else if (Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"system") && Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"network.event")) {
            Object object;
            String string;
            breadcrumbCategory = "device.connectivity";
            Map map = breadcrumbData;
            String string5 = "state";
            if (Intrinsics.areEqual(breadcrumb.getData().get("action"), (Object)"NETWORK_LOST")) {
                string = "offline";
            } else {
                Map map4 = breadcrumb.getData();
                Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"getData(...)");
                object = map4;
                if (!object.containsKey("network_type")) return null;
                object = breadcrumb.getData().get("network_type");
                object = object instanceof String ? (String)object : null;
                if (object == null) return null;
                if (object.length() == 0) {
                    return null;
                }
                boolean bl = false;
                if (bl) return null;
                string = breadcrumb.getData().get("network_type");
            }
            object = string;
            map.put(string5, object);
            if (Intrinsics.areEqual((Object)this.lastConnectivityState, breadcrumbData.get("state"))) {
                return null;
            }
            Object v = breadcrumbData.get("state");
            this.lastConnectivityState = v instanceof String ? (String)v : null;
        } else if (Intrinsics.areEqual(breadcrumb.getData().get("action"), (Object)"BATTERY_CHANGED")) {
            breadcrumbCategory = "device.battery";
            Map map = breadcrumb.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
            Map map5 = map;
            Map map6 = breadcrumbData;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : map5.entrySet()) {
                String it = (String)entry$iv.getKey();
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)"level") || Intrinsics.areEqual((Object)it, (Object)"charging"))) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map6.putAll(result$iv);
        } else {
            breadcrumbCategory = breadcrumb.getCategory();
            breadcrumbMessage = breadcrumb.getMessage();
            breadcrumbLevel = breadcrumb.getLevel();
            Map map = breadcrumb.getData();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
            breadcrumbData.putAll(map);
        }
        CharSequence charSequence = breadcrumbCategory;
        if (charSequence == null) return null;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl = false;
        if (bl) return null;
        RRWebBreadcrumbEvent $this$convert_u24lambda_u241 = rRWebBreadcrumbEvent = new RRWebBreadcrumbEvent();
        boolean bl2 = false;
        $this$convert_u24lambda_u241.setTimestamp(breadcrumb.getTimestamp().getTime());
        $this$convert_u24lambda_u241.setBreadcrumbTimestamp((double)breadcrumb.getTimestamp().getTime() / 1000.0);
        $this$convert_u24lambda_u241.setBreadcrumbType("default");
        $this$convert_u24lambda_u241.setCategory(breadcrumbCategory);
        $this$convert_u24lambda_u241.setMessage(breadcrumbMessage);
        $this$convert_u24lambda_u241.setLevel(breadcrumbLevel);
        $this$convert_u24lambda_u241.setData(breadcrumbData);
        RRWebEvent rRWebEvent = (RRWebEvent)rRWebBreadcrumbEvent;
        return rRWebEvent;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isValidForRRWebSpan(Breadcrumb $this$isValidForRRWebSpan) {
        Object v = $this$isValidForRRWebSpan.getData().get("url");
        CharSequence charSequence = v instanceof String ? (String)v : null;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        Map map = $this$isValidForRRWebSpan.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
        Map map2 = map;
        if (!map2.containsKey("http.start_timestamp")) return false;
        Map map3 = $this$isValidForRRWebSpan.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getData(...)");
        Map map4 = map3;
        if (!map4.containsKey("http.end_timestamp")) return false;
        return true;
    }

    private final String snakeToCamelCase(String $this$snakeToCamelCase) {
        CharSequence charSequence = $this$snakeToCamelCase;
        Regex regex = DefaultReplayBreadcrumbConverter.Companion.getSnakecasePattern();
        Function1 function1 = snakeToCamelCase.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    private final RRWebSpanEvent toRRWebSpanEvent(Breadcrumb $this$toRRWebSpanEvent) {
        NetworkRequestData networkDetailData;
        double d;
        double d2;
        RRWebSpanEvent rRWebSpanEvent;
        Breadcrumb breadcrumb = $this$toRRWebSpanEvent;
        Object httpStartTimestamp = breadcrumb.getData().get("http.start_timestamp");
        Object httpEndTimestamp = breadcrumb.getData().get("http.end_timestamp");
        RRWebSpanEvent $this$toRRWebSpanEvent_u24lambda_u2417 = rRWebSpanEvent = new RRWebSpanEvent();
        boolean bl = false;
        $this$toRRWebSpanEvent_u24lambda_u2417.setTimestamp(breadcrumb.getTimestamp().getTime());
        $this$toRRWebSpanEvent_u24lambda_u2417.setOp("resource.http");
        Object v = breadcrumb.getData().get("url");
        Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
        $this$toRRWebSpanEvent_u24lambda_u2417.setDescription((String)v);
        if (httpStartTimestamp instanceof Double) {
            d2 = ((Number)httpStartTimestamp).doubleValue() / 1000.0;
        } else {
            Intrinsics.checkNotNull(httpStartTimestamp, (String)"null cannot be cast to non-null type kotlin.Long");
            d2 = (double)((Long)httpStartTimestamp).longValue() / 1000.0;
        }
        $this$toRRWebSpanEvent_u24lambda_u2417.setStartTimestamp(d2);
        if (httpEndTimestamp instanceof Double) {
            d = ((Number)httpEndTimestamp).doubleValue() / 1000.0;
        } else {
            Intrinsics.checkNotNull(httpEndTimestamp, (String)"null cannot be cast to non-null type kotlin.Long");
            d = (double)((Long)httpEndTimestamp).longValue() / 1000.0;
        }
        $this$toRRWebSpanEvent_u24lambda_u2417.setEndTimestamp(d);
        Map breadcrumbData = new LinkedHashMap();
        NetworkRequestData networkRequestData = networkDetailData = this.httpNetworkDetails.remove(breadcrumb);
        if (networkRequestData != null) {
            NetworkBody.NetworkBodyWarning warning;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            String string;
            Map map;
            List warnings;
            Long it;
            Object it2;
            NetworkRequestData networkData = networkRequestData;
            boolean bl2 = false;
            String string2 = networkData.getMethod();
            if (string2 != null) {
                it2 = string2;
                boolean bl3 = false;
                breadcrumbData.put("method", it2);
            }
            Integer n = networkData.getStatusCode();
            if (n != null) {
                it2 = n;
                boolean bl4 = false;
                breadcrumbData.put("statusCode", it2);
            }
            Long l = networkData.getRequestBodySize();
            if (l != null) {
                it2 = l;
                boolean bl5 = false;
                breadcrumbData.put("requestBodySize", it2);
            }
            Long l2 = networkData.getResponseBodySize();
            if (l2 != null) {
                it2 = l2;
                boolean bl6 = false;
                breadcrumbData.put("responseBodySize", it2);
            }
            ReplayNetworkRequestOrResponse replayNetworkRequestOrResponse = networkData.getRequest();
            if (replayNetworkRequestOrResponse != null) {
                ReplayNetworkRequestOrResponse request = replayNetworkRequestOrResponse;
                boolean bl7 = false;
                Map requestData = new LinkedHashMap();
                Long l3 = request.getSize();
                if (l3 != null) {
                    it = l3;
                    boolean bl8 = false;
                    requestData.put("size", it);
                }
                NetworkBody networkBody = request.getBody();
                if (networkBody != null) {
                    it = networkBody;
                    boolean bl9 = false;
                    requestData.put("body", it.getBody());
                    List list = it.getWarnings();
                    if (list != null) {
                        warnings = list;
                        boolean bl10 = false;
                        map = requestData;
                        string = "warnings";
                        Intrinsics.checkNotNull((Object)warnings);
                        $this$map$iv = warnings;
                        $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            NetworkBody.NetworkBodyWarning networkBodyWarning = (NetworkBody.NetworkBodyWarning)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl11 = false;
                            collection.add(warning.getValue());
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        map.put(string, $this$map$iv);
                    }
                }
                Map map2 = request.getHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getHeaders(...)");
                if (!map2.isEmpty()) {
                    requestData.put("headers", request.getHeaders());
                }
                if (!requestData.isEmpty()) {
                    breadcrumbData.put("request", requestData);
                }
            }
            ReplayNetworkRequestOrResponse replayNetworkRequestOrResponse2 = networkData.getResponse();
            if (replayNetworkRequestOrResponse2 != null) {
                ReplayNetworkRequestOrResponse response = replayNetworkRequestOrResponse2;
                boolean bl12 = false;
                Map responseData = new LinkedHashMap();
                Long l4 = response.getSize();
                if (l4 != null) {
                    it = l4;
                    boolean bl13 = false;
                    responseData.put("size", it);
                }
                NetworkBody networkBody = response.getBody();
                if (networkBody != null) {
                    it = networkBody;
                    boolean bl14 = false;
                    responseData.put("body", it.getBody());
                    List list = it.getWarnings();
                    if (list != null) {
                        warnings = list;
                        boolean bl15 = false;
                        map = responseData;
                        string = "warnings";
                        Intrinsics.checkNotNull((Object)warnings);
                        $this$map$iv = warnings;
                        $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            warning = (NetworkBody.NetworkBodyWarning)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl16 = false;
                            collection.add(warning.getValue());
                        }
                        List list2 = (List)destination$iv$iv;
                        map.put(string, list2);
                    }
                }
                Map map3 = response.getHeaders();
                Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getHeaders(...)");
                if (!map3.isEmpty()) {
                    responseData.put("headers", response.getHeaders());
                }
                if (!responseData.isEmpty()) {
                    breadcrumbData.put("response", responseData);
                }
            }
        }
        Map map = breadcrumb.getData();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getData(...)");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!supportedNetworkData.contains(key)) continue;
            Intrinsics.checkNotNull((Object)key);
            String formattedKey = this.snakeToCamelCase(StringsKt.substringAfter$default((String)StringsKt.replace$default((String)key, (String)"content_length", (String)"body_size", (boolean)false, (int)4, null), (String)".", null, (int)2, null));
            breadcrumbData.put(formattedKey, value);
        }
        $this$toRRWebSpanEvent_u24lambda_u2417.setData(breadcrumbData);
        return rRWebSpanEvent;
    }

    static {
        HashSet<String> hashSet;
        Companion = new Companion(null);
        $stable = 8;
        snakecasePattern$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)Companion.snakecasePattern.2.INSTANCE);
        HashSet<String> $this$supportedNetworkData_u24lambda_u2418 = hashSet = new HashSet<String>();
        boolean bl = false;
        $this$supportedNetworkData_u24lambda_u2418.add("status_code");
        $this$supportedNetworkData_u24lambda_u2418.add("method");
        $this$supportedNetworkData_u24lambda_u2418.add("response_content_length");
        $this$supportedNetworkData_u24lambda_u2418.add("request_content_length");
        $this$supportedNetworkData_u24lambda_u2418.add("http.response_content_length");
        $this$supportedNetworkData_u24lambda_u2418.add("http.request_content_length");
        supportedNetworkData = hashSet;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/sentry/android/replay/DefaultReplayBreadcrumbConverter$Companion;", "", "()V", "MAX_HTTP_NETWORK_DETAILS", "", "snakecasePattern", "Lkotlin/text/Regex;", "getSnakecasePattern", "()Lkotlin/text/Regex;", "snakecasePattern$delegate", "Lkotlin/Lazy;", "supportedNetworkData", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Regex getSnakecasePattern() {
            Lazy lazy = snakecasePattern$delegate;
            return (Regex)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/sentry/android/replay/DefaultReplayBreadcrumbConverter$ReplayBeforeBreadcrumbCallback;", "Lio/sentry/SentryOptions$BeforeBreadcrumbCallback;", "delegate", "(Lio/sentry/android/replay/DefaultReplayBreadcrumbConverter;Lio/sentry/SentryOptions$BeforeBreadcrumbCallback;)V", "execute", "Lio/sentry/Breadcrumb;", "breadcrumb", "hint", "Lio/sentry/Hint;", "extractNetworkRequestDataFromHint", "Lio/sentry/util/network/NetworkRequestData;", "breadcrumbHint", "sentry-android-replay_release"})
    private final class ReplayBeforeBreadcrumbCallback
    implements SentryOptions.BeforeBreadcrumbCallback {
        @Nullable
        private final SentryOptions.BeforeBreadcrumbCallback delegate;

        public ReplayBeforeBreadcrumbCallback(SentryOptions.BeforeBreadcrumbCallback delegate) {
            this.delegate = delegate;
        }

        @Nullable
        public Breadcrumb execute(@NotNull Breadcrumb breadcrumb, @NotNull Hint hint) {
            Breadcrumb resultBreadcrumb;
            block1: {
                Intrinsics.checkNotNullParameter((Object)breadcrumb, (String)"breadcrumb");
                Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
                Breadcrumb breadcrumb2 = resultBreadcrumb = this.delegate != null ? this.delegate.execute(breadcrumb, hint) : breadcrumb;
                if (breadcrumb2 == null) break block1;
                Breadcrumb breadcrumb3 = breadcrumb2;
                DefaultReplayBreadcrumbConverter defaultReplayBreadcrumbConverter = DefaultReplayBreadcrumbConverter.this;
                Breadcrumb finalBreadcrumb = breadcrumb3;
                boolean bl = false;
                NetworkRequestData networkRequestData = this.extractNetworkRequestDataFromHint(finalBreadcrumb, hint);
                if (networkRequestData != null) {
                    NetworkRequestData networkData = networkRequestData;
                    boolean bl2 = false;
                    Map map = defaultReplayBreadcrumbConverter.httpNetworkDetails;
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"access$getHttpNetworkDetails$p(...)");
                    map.put(finalBreadcrumb, networkData);
                }
            }
            return resultBreadcrumb;
        }

        private final NetworkRequestData extractNetworkRequestDataFromHint(Breadcrumb breadcrumb, Hint breadcrumbHint) {
            if (!Intrinsics.areEqual((Object)breadcrumb.getType(), (Object)"http") && !Intrinsics.areEqual((Object)breadcrumb.getCategory(), (Object)"http")) {
                return null;
            }
            Object object = breadcrumbHint.get("sentry:replayNetworkDetails");
            return object instanceof NetworkRequestData ? (NetworkRequestData)object : null;
        }
    }
}

