/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.screenshot;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.view.PixelCopy;
import android.view.Surface;
import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ExecutorProvider;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.screenshot.ScreenshotStrategy;
import io.sentry.android.replay.screenshot.TextIgnoringDelegateCanvas;
import io.sentry.android.replay.util.ReplayRunnable;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.IntegrationUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0017J\b\u0010'\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020$H\u0016J\b\u0010\r\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020$H\u0016J\u0012\u0010+\u001a\u00020$*\u00020,2\u0006\u0010-\u001a\u00020.R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/sentry/android/replay/screenshot/CanvasStrategy;", "Lio/sentry/android/replay/screenshot/ScreenshotStrategy;", "executor", "Lio/sentry/android/replay/ExecutorProvider;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "options", "Lio/sentry/SentryOptions;", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "(Lio/sentry/android/replay/ExecutorProvider;Lio/sentry/android/replay/ScreenshotRecorderCallback;Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderConfig;)V", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastCaptureSuccessful", "pictureRenderTask", "Ljava/lang/Runnable;", "prescaledMatrix", "Landroid/graphics/Matrix;", "getPrescaledMatrix", "()Landroid/graphics/Matrix;", "prescaledMatrix$delegate", "Lkotlin/Lazy;", "screenshot", "Landroid/graphics/Bitmap;", "screenshotLock", "Lio/sentry/util/AutoClosableReentrantLock;", "surface", "Landroid/view/Surface;", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "textIgnoringCanvas", "Lio/sentry/android/replay/screenshot/TextIgnoringDelegateCanvas;", "unprocessedPictureRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Landroid/graphics/Picture;", "capture", "", "root", "Landroid/view/View;", "close", "emitLastScreenshot", "", "onContentChanged", "postSafely", "Landroid/os/Handler;", "runnable", "Lio/sentry/android/replay/util/ReplayRunnable;", "sentry-android-replay_release"})
@SuppressLint(value={"NewApi", "UseKtx"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCanvasStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasStrategy.kt\nio/sentry/android/replay/screenshot/CanvasStrategy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1015:1\n1#2:1016\n*E\n"})
public final class CanvasStrategy
implements ScreenshotStrategy {
    @NotNull
    private final ExecutorProvider executor;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ScreenshotRecorderConfig config;
    @Nullable
    private volatile Bitmap screenshot;
    @NotNull
    private AtomicReference<Picture> unprocessedPictureRef;
    @NotNull
    private final AutoClosableReentrantLock screenshotLock;
    @NotNull
    private final Lazy prescaledMatrix$delegate;
    @NotNull
    private final AtomicBoolean lastCaptureSuccessful;
    @NotNull
    private final TextIgnoringDelegateCanvas textIgnoringCanvas;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final SurfaceTexture surfaceTexture;
    @NotNull
    private final Surface surface;
    @SuppressLint(value={"NewApi"})
    @NotNull
    private final Runnable pictureRenderTask;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public CanvasStrategy(@NotNull ExecutorProvider executor, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback, @NotNull SentryOptions options, @NotNull ScreenshotRecorderConfig config) {
        void $this$surfaceTexture_u24lambda_u240;
        SurfaceTexture surfaceTexture;
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.executor = executor;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.options = options;
        this.config = config;
        this.unprocessedPictureRef = new AtomicReference<Object>(null);
        this.screenshotLock = new AutoClosableReentrantLock();
        this.prescaledMatrix$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Matrix>(this){
            final /* synthetic */ CanvasStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Matrix invoke() {
                Matrix matrix = new Matrix();
                CanvasStrategy canvasStrategy = this.this$0;
                Matrix $this$invoke_u24lambda_u240 = matrix;
                boolean bl = false;
                $this$invoke_u24lambda_u240.preScale(CanvasStrategy.access$getConfig$p(canvasStrategy).getScaleFactorX(), CanvasStrategy.access$getConfig$p(canvasStrategy).getScaleFactorY());
                return matrix;
            }
        }));
        this.lastCaptureSuccessful = new AtomicBoolean(false);
        this.textIgnoringCanvas = new TextIgnoringDelegateCanvas();
        this.isClosed = new AtomicBoolean(false);
        SurfaceTexture surfaceTexture2 = surfaceTexture = new SurfaceTexture(false);
        CanvasStrategy canvasStrategy = this;
        boolean bl = false;
        $this$surfaceTexture_u24lambda_u240.setDefaultBufferSize(this.config.getRecordingWidth(), this.config.getRecordingHeight());
        canvasStrategy.surfaceTexture = surfaceTexture;
        this.surface = new Surface(this.surfaceTexture);
        IntegrationUtils.addIntegrationToSdkVersion((String)"ReplayCanvasStrategy");
        this.pictureRenderTask = () -> CanvasStrategy.pictureRenderTask$lambda$3(this);
    }

    private final Matrix getPrescaledMatrix() {
        Lazy lazy = this.prescaledMatrix$delegate;
        return (Matrix)lazy.getValue();
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public void capture(@NotNull View root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (this.isClosed.get()) {
            return;
        }
        Picture picture = new Picture();
        Canvas canvas = picture.beginRecording(this.config.getRecordingWidth(), this.config.getRecordingHeight());
        Intrinsics.checkNotNullExpressionValue((Object)canvas, (String)"beginRecording(...)");
        Canvas canvas2 = canvas;
        this.textIgnoringCanvas.setDelegate(canvas2);
        this.textIgnoringCanvas.setMatrix(this.getPrescaledMatrix());
        root.draw((Canvas)this.textIgnoringCanvas);
        picture.endRecording();
        if (!this.isClosed.get()) {
            this.unprocessedPictureRef.set(picture);
            this.postSafely(this.executor.getBackgroundHandler(), new ReplayRunnable("screenshot_recorder.canvas", this.pictureRenderTask));
        }
    }

    @Override
    public void onContentChanged() {
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.postSafely(this.executor.getBackgroundHandler(), new ReplayRunnable("CanvasStrategy.close", () -> CanvasStrategy.close$lambda$6(this)));
        this.unprocessedPictureRef.getAndSet(null);
    }

    @Override
    public boolean lastCaptureSuccessful() {
        return this.lastCaptureSuccessful.get();
    }

    @Override
    public void emitLastScreenshot() {
        block1: {
            Bitmap bitmap;
            if (!this.lastCaptureSuccessful() || (bitmap = this.screenshot) == null || bitmap.isRecycled()) break block1;
            ScreenshotRecorderCallback screenshotRecorderCallback = this.screenshotRecorderCallback;
            if (screenshotRecorderCallback != null) {
                screenshotRecorderCallback.onScreenshotRecorded(bitmap);
            }
        }
    }

    public final void postSafely(@NotNull Handler $this$postSafely, @NotNull ReplayRunnable runnable) {
        Intrinsics.checkNotNullParameter((Object)$this$postSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            $this$postSafely.post((Runnable)runnable);
        }
        catch (Throwable t) {
            this.options.getLogger().log(SentryLevel.ERROR, "Canvas Strategy: failed to post runnable " + runnable.getTaskName(), t);
        }
    }

    private static final void pictureRenderTask$lambda$3$lambda$2(CanvasStrategy this$0, int result) {
        if (this$0.isClosed.get()) {
            this$0.options.getLogger().log(SentryLevel.DEBUG, "CanvasStrategy is closed, ignoring capture result", new Object[0]);
            return;
        }
        if (result == 0) {
            this$0.lastCaptureSuccessful.set(true);
            Bitmap bitmap = this$0.screenshot;
            if (bitmap != null && !bitmap.isRecycled()) {
                ScreenshotRecorderCallback screenshotRecorderCallback = this$0.screenshotRecorderCallback;
                if (screenshotRecorderCallback != null) {
                    screenshotRecorderCallback.onScreenshotRecorded(bitmap);
                }
            }
        } else {
            this$0.options.getLogger().log(SentryLevel.ERROR, "Canvas Strategy: PixelCopy failed with code " + result, new Object[0]);
            this$0.lastCaptureSuccessful.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void pictureRenderTask$lambda$3(CanvasStrategy this$0) {
        if (this$0.isClosed.get()) {
            this$0.options.getLogger().log(SentryLevel.DEBUG, "Canvas Strategy already closed, skipping picture render", new Object[0]);
            return;
        }
        Picture picture = this$0.unprocessedPictureRef.getAndSet(null);
        if (picture == null) {
            return;
        }
        Picture picture2 = picture;
        try {
            Canvas surfaceCanvas = this$0.surface.lockHardwareCanvas();
            try {
                surfaceCanvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
                picture2.draw(surfaceCanvas);
            }
            finally {
                this$0.surface.unlockCanvasAndPost(surfaceCanvas);
            }
            if (this$0.screenshot == null) {
                AutoCloseable autoCloseable = (AutoCloseable)this$0.screenshotLock.acquire();
                Throwable throwable = null;
                try {
                    ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                    boolean bl = false;
                    if (this$0.screenshot == null) {
                        this$0.screenshot = Bitmap.createBitmap((int)this$0.config.getRecordingWidth(), (int)this$0.config.getRecordingHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            if (this$0.isClosed.get()) {
                this$0.options.getLogger().log(SentryLevel.DEBUG, "Canvas Strategy already closed, skipping pixel copy request", new Object[0]);
                return;
            }
            Surface surface = this$0.surface;
            Bitmap bitmap = this$0.screenshot;
            Intrinsics.checkNotNull((Object)bitmap);
            PixelCopy.request((Surface)surface, (Bitmap)bitmap, arg_0 -> CanvasStrategy.pictureRenderTask$lambda$3$lambda$2(this$0, arg_0), (Handler)this$0.executor.getBackgroundHandler());
        }
        catch (Throwable t) {
            this$0.options.getLogger().log(SentryLevel.ERROR, "Canvas Strategy: picture render failed", t);
            this$0.lastCaptureSuccessful.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void close$lambda$6(CanvasStrategy this$0) {
        Bitmap bitmap = this$0.screenshot;
        if (bitmap != null) {
            Bitmap it = bitmap;
            boolean bl = false;
            Bitmap bitmap2 = it;
            synchronized (bitmap2) {
                boolean bl2 = false;
                if (!it.isRecycled()) {
                    it.recycle();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        this$0.surface.release();
        this$0.surfaceTexture.release();
    }

    public static final /* synthetic */ ScreenshotRecorderConfig access$getConfig$p(CanvasStrategy $this) {
        return $this.config;
    }
}

