/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.SentryReplayOptions;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B5\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003JE\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\""}, d2={"Lio/sentry/android/replay/ScreenshotRecorderConfig;", "", "scaleFactorX", "", "scaleFactorY", "(FF)V", "recordingWidth", "", "recordingHeight", "frameRate", "bitRate", "(IIFFII)V", "getBitRate", "()I", "getFrameRate", "getRecordingHeight", "getRecordingWidth", "getScaleFactorX", "()F", "getScaleFactorY", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "sentry-android-replay_release"})
@StabilityInferred(parameters=1)
public final class ScreenshotRecorderConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int recordingWidth;
    private final int recordingHeight;
    private final float scaleFactorX;
    private final float scaleFactorY;
    private final int frameRate;
    private final int bitRate;
    public static final int $stable;

    public ScreenshotRecorderConfig(int recordingWidth, int recordingHeight, float scaleFactorX, float scaleFactorY, int frameRate, int bitRate) {
        this.recordingWidth = recordingWidth;
        this.recordingHeight = recordingHeight;
        this.scaleFactorX = scaleFactorX;
        this.scaleFactorY = scaleFactorY;
        this.frameRate = frameRate;
        this.bitRate = bitRate;
    }

    public final int getRecordingWidth() {
        return this.recordingWidth;
    }

    public final int getRecordingHeight() {
        return this.recordingHeight;
    }

    public final float getScaleFactorX() {
        return this.scaleFactorX;
    }

    public final float getScaleFactorY() {
        return this.scaleFactorY;
    }

    public final int getFrameRate() {
        return this.frameRate;
    }

    public final int getBitRate() {
        return this.bitRate;
    }

    public ScreenshotRecorderConfig(float scaleFactorX, float scaleFactorY) {
        this(0, 0, scaleFactorX, scaleFactorY, 0, 0);
    }

    public final int component1() {
        return this.recordingWidth;
    }

    public final int component2() {
        return this.recordingHeight;
    }

    public final float component3() {
        return this.scaleFactorX;
    }

    public final float component4() {
        return this.scaleFactorY;
    }

    public final int component5() {
        return this.frameRate;
    }

    public final int component6() {
        return this.bitRate;
    }

    @NotNull
    public final ScreenshotRecorderConfig copy(int recordingWidth, int recordingHeight, float scaleFactorX, float scaleFactorY, int frameRate, int bitRate) {
        return new ScreenshotRecorderConfig(recordingWidth, recordingHeight, scaleFactorX, scaleFactorY, frameRate, bitRate);
    }

    public static /* synthetic */ ScreenshotRecorderConfig copy$default(ScreenshotRecorderConfig screenshotRecorderConfig, int n, int n2, float f, float f2, int n3, int n4, int n5, Object object) {
        if ((n5 & 1) != 0) {
            n = screenshotRecorderConfig.recordingWidth;
        }
        if ((n5 & 2) != 0) {
            n2 = screenshotRecorderConfig.recordingHeight;
        }
        if ((n5 & 4) != 0) {
            f = screenshotRecorderConfig.scaleFactorX;
        }
        if ((n5 & 8) != 0) {
            f2 = screenshotRecorderConfig.scaleFactorY;
        }
        if ((n5 & 0x10) != 0) {
            n3 = screenshotRecorderConfig.frameRate;
        }
        if ((n5 & 0x20) != 0) {
            n4 = screenshotRecorderConfig.bitRate;
        }
        return screenshotRecorderConfig.copy(n, n2, f, f2, n3, n4);
    }

    @NotNull
    public String toString() {
        return "ScreenshotRecorderConfig(recordingWidth=" + this.recordingWidth + ", recordingHeight=" + this.recordingHeight + ", scaleFactorX=" + this.scaleFactorX + ", scaleFactorY=" + this.scaleFactorY + ", frameRate=" + this.frameRate + ", bitRate=" + this.bitRate + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.recordingWidth);
        result = result * 31 + Integer.hashCode(this.recordingHeight);
        result = result * 31 + Float.hashCode(this.scaleFactorX);
        result = result * 31 + Float.hashCode(this.scaleFactorY);
        result = result * 31 + Integer.hashCode(this.frameRate);
        result = result * 31 + Integer.hashCode(this.bitRate);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ScreenshotRecorderConfig)) {
            return false;
        }
        ScreenshotRecorderConfig screenshotRecorderConfig = (ScreenshotRecorderConfig)other;
        if (this.recordingWidth != screenshotRecorderConfig.recordingWidth) {
            return false;
        }
        if (this.recordingHeight != screenshotRecorderConfig.recordingHeight) {
            return false;
        }
        if (Float.compare(this.scaleFactorX, screenshotRecorderConfig.scaleFactorX) != 0) {
            return false;
        }
        if (Float.compare(this.scaleFactorY, screenshotRecorderConfig.scaleFactorY) != 0) {
            return false;
        }
        if (this.frameRate != screenshotRecorderConfig.frameRate) {
            return false;
        }
        return this.bitRate == screenshotRecorderConfig.bitRate;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\f\u0010\f\u001a\u00020\n*\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lio/sentry/android/replay/ScreenshotRecorderConfig$Companion;", "", "()V", "fromSize", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "context", "Landroid/content/Context;", "sessionReplay", "Lio/sentry/SentryReplayOptions;", "windowWidth", "", "windowHeight", "adjustToBlockSize", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int adjustToBlockSize(int $this$adjustToBlockSize) {
            int remainder = $this$adjustToBlockSize % 16;
            return remainder <= 8 ? Math.max(16, $this$adjustToBlockSize - remainder) : $this$adjustToBlockSize + (16 - remainder);
        }

        @NotNull
        public final ScreenshotRecorderConfig fromSize(@NotNull Context context, @NotNull SentryReplayOptions sessionReplay, int windowWidth, int windowHeight) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)sessionReplay, (String)"sessionReplay");
            Pair pair = TuplesKt.to((Object)this.adjustToBlockSize(MathKt.roundToInt((float)((float)windowHeight / context.getResources().getDisplayMetrics().density * sessionReplay.getQuality().sizeScale))), (Object)this.adjustToBlockSize(MathKt.roundToInt((float)((float)windowWidth / context.getResources().getDisplayMetrics().density * sessionReplay.getQuality().sizeScale))));
            int height = ((Number)pair.component1()).intValue();
            int width = ((Number)pair.component2()).intValue();
            return new ScreenshotRecorderConfig(width, height, (float)width / (float)windowWidth, (float)height / (float)windowHeight, sessionReplay.getFrameRate(), sessionReplay.getQuality().bitRate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

