/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.screenshot;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.media.Image;
import android.media.ImageReader;
import android.view.Surface;
import android.view.View;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ExecutorProvider;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.screenshot.PictureReaderHolder;
import io.sentry.android.replay.screenshot.ScreenshotStrategy;
import io.sentry.android.replay.screenshot.TextIgnoringDelegateCanvas;
import io.sentry.android.replay.util.ReplayRunnable;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.IntegrationUtils;
import java.nio.Buffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0017J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020\u0017H\u0016J\b\u0010\u0011\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0014\u0012\b\b\u0015\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00170\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lio/sentry/android/replay/screenshot/CanvasStrategy;", "Lio/sentry/android/replay/screenshot/ScreenshotStrategy;", "executor", "Lio/sentry/android/replay/ExecutorProvider;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "options", "Lio/sentry/SentryOptions;", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "(Lio/sentry/android/replay/ExecutorProvider;Lio/sentry/android/replay/ScreenshotRecorderCallback;Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderConfig;)V", "freePictureRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/sentry/android/replay/screenshot/PictureReaderHolder;", "kotlin.jvm.PlatformType", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastCaptureSuccessful", "onImageAvailableListener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "holder", "", "pictureRenderTask", "Ljava/lang/Runnable;", "prescaledMatrix", "Landroid/graphics/Matrix;", "getPrescaledMatrix", "()Landroid/graphics/Matrix;", "prescaledMatrix$delegate", "Lkotlin/Lazy;", "screenshot", "Landroid/graphics/Bitmap;", "screenshotLock", "Lio/sentry/util/AutoClosableReentrantLock;", "textIgnoringCanvas", "Lio/sentry/android/replay/screenshot/TextIgnoringDelegateCanvas;", "unprocessedPictureRef", "capture", "root", "Landroid/view/View;", "close", "emitLastScreenshot", "", "onContentChanged", "sentry-android-replay_release"})
@SuppressLint(value={"UseKtx"})
@StabilityInferred(parameters=0)
public final class CanvasStrategy
implements ScreenshotStrategy {
    @NotNull
    private final ExecutorProvider executor;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final SentryOptions options;
    @NotNull
    private final ScreenshotRecorderConfig config;
    @Nullable
    private volatile Bitmap screenshot;
    @NotNull
    private final AutoClosableReentrantLock screenshotLock;
    @NotNull
    private final Lazy prescaledMatrix$delegate;
    @NotNull
    private final AtomicBoolean lastCaptureSuccessful;
    @NotNull
    private final TextIgnoringDelegateCanvas textIgnoringCanvas;
    @NotNull
    private final AtomicBoolean isClosed;
    @NotNull
    private final Function1<PictureReaderHolder, Unit> onImageAvailableListener;
    @NotNull
    private AtomicReference<PictureReaderHolder> freePictureRef;
    @NotNull
    private AtomicReference<PictureReaderHolder> unprocessedPictureRef;
    @SuppressLint(value={"NewApi"})
    @NotNull
    private final Runnable pictureRenderTask;
    public static final int $stable = 8;

    public CanvasStrategy(@NotNull ExecutorProvider executor, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback, @NotNull SentryOptions options, @NotNull ScreenshotRecorderConfig config) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.executor = executor;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.options = options;
        this.config = config;
        this.screenshotLock = new AutoClosableReentrantLock();
        this.prescaledMatrix$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Matrix>(this){
            final /* synthetic */ CanvasStrategy this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Matrix invoke() {
                Matrix matrix = new Matrix();
                CanvasStrategy canvasStrategy = this.this$0;
                Matrix $this$invoke_u24lambda_u240 = matrix;
                boolean bl = false;
                $this$invoke_u24lambda_u240.preScale(CanvasStrategy.access$getConfig$p(canvasStrategy).getScaleFactorX(), CanvasStrategy.access$getConfig$p(canvasStrategy).getScaleFactorY());
                return matrix;
            }
        }));
        this.lastCaptureSuccessful = new AtomicBoolean(false);
        this.textIgnoringCanvas = new TextIgnoringDelegateCanvas();
        this.isClosed = new AtomicBoolean(false);
        this.onImageAvailableListener = (Function1)new Function1<PictureReaderHolder, Unit>(this){
            final /* synthetic */ CanvasStrategy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(PictureReaderHolder holder) {
                block28: {
                    Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                    if (CanvasStrategy.access$isClosed$p(this.this$0).get()) {
                        CanvasStrategy.access$getOptions$p(this.this$0).getLogger().log(SentryLevel.ERROR, "CanvasStrategy already closed, skipping image", new Object[0]);
                        holder.close();
                    } else {
                        try {
                            Image image = holder.getReader().acquireLatestImage();
                            try {
                                Bitmap bitmap;
                                Bitmap bitmap2;
                                Object object;
                                if (image.getPlanes().length <= 0) break block28;
                                Image.Plane plane = image.getPlanes()[0];
                                if (CanvasStrategy.access$getScreenshot$p(this.this$0) == null) {
                                    AutoCloseable autoCloseable = (AutoCloseable)CanvasStrategy.access$getScreenshotLock$p(this.this$0).acquire();
                                    CanvasStrategy canvasStrategy = this.this$0;
                                    object = null;
                                    try {
                                        ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                                        boolean bl = false;
                                        if (CanvasStrategy.access$getScreenshot$p(canvasStrategy) == null) {
                                            CanvasStrategy.access$setScreenshot$p(canvasStrategy, Bitmap.createBitmap((int)holder.getWidth(), (int)holder.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888));
                                        }
                                        bitmap2 = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable) {
                                        object = throwable;
                                        throw throwable;
                                    }
                                    finally {
                                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
                                    }
                                }
                                if ((bitmap = CanvasStrategy.access$getScreenshot$p(this.this$0)) == null) break block28;
                                Buffer buffer = plane.getBuffer().rewind();
                                object = this.this$0;
                                bitmap2 = bitmap;
                                synchronized (bitmap2) {
                                    boolean bl = false;
                                    if (!bitmap.isRecycled()) {
                                        bitmap.copyPixelsFromBuffer(buffer);
                                        CanvasStrategy.access$getLastCaptureSuccessful$p((CanvasStrategy)object).set(true);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                ScreenshotRecorderCallback screenshotRecorderCallback = CanvasStrategy.access$getScreenshotRecorderCallback$p(this.this$0);
                                if (screenshotRecorderCallback != null) {
                                    screenshotRecorderCallback.onScreenshotRecorded(bitmap);
                                }
                            }
                            finally {
                                try {
                                    image.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                        catch (Throwable e) {
                            CanvasStrategy.access$getOptions$p(this.this$0).getLogger().log(SentryLevel.ERROR, "CanvasStrategy: image processing failed", e);
                        }
                        finally {
                            if (CanvasStrategy.access$isClosed$p(this.this$0).get()) {
                                holder.close();
                            } else {
                                CanvasStrategy.access$getFreePictureRef$p(this.this$0).set(holder);
                            }
                        }
                    }
                }
            }
        };
        this.freePictureRef = new AtomicReference<PictureReaderHolder>(new PictureReaderHolder(this.config.getRecordingWidth(), this.config.getRecordingHeight(), this.onImageAvailableListener));
        this.unprocessedPictureRef = new AtomicReference<Object>(null);
        IntegrationUtils.addIntegrationToSdkVersion((String)"ReplayCanvasStrategy");
        this.pictureRenderTask = () -> CanvasStrategy.pictureRenderTask$lambda$0(this);
    }

    private final Matrix getPrescaledMatrix() {
        Lazy lazy = this.prescaledMatrix$delegate;
        return (Matrix)lazy.getValue();
    }

    @Override
    @SuppressLint(value={"UnclosedTrace"})
    public void capture(@NotNull View root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (this.isClosed.get()) {
            return;
        }
        PictureReaderHolder holder = this.freePictureRef.getAndSet(null);
        if (holder == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "No free Picture available, skipping capture", new Object[0]);
            this.lastCaptureSuccessful.set(false);
            return;
        }
        Canvas canvas = holder.getPicture().beginRecording(this.config.getRecordingWidth(), this.config.getRecordingHeight());
        Intrinsics.checkNotNullExpressionValue((Object)canvas, (String)"beginRecording(...)");
        Canvas pictureCanvas = canvas;
        this.textIgnoringCanvas.setDelegate(pictureCanvas);
        this.textIgnoringCanvas.setMatrix(this.getPrescaledMatrix());
        root.draw((Canvas)this.textIgnoringCanvas);
        holder.getPicture().endRecording();
        if (this.isClosed.get()) {
            holder.close();
        } else {
            this.unprocessedPictureRef.set(holder);
            this.executor.getExecutor().submit(new ReplayRunnable("screenshot_recorder.canvas", this.pictureRenderTask));
        }
    }

    @Override
    public void onContentChanged() {
    }

    @Override
    public void close() {
        block1: {
            PictureReaderHolder pictureReaderHolder;
            this.isClosed.set(true);
            this.executor.getExecutor().submit(new ReplayRunnable("CanvasStrategy.close", () -> CanvasStrategy.close$lambda$3(this)));
            PictureReaderHolder pictureReaderHolder2 = this.freePictureRef.getAndSet(null);
            if (pictureReaderHolder2 != null && (pictureReaderHolder2 = pictureReaderHolder2.getReader()) != null) {
                pictureReaderHolder2.close();
            }
            if ((pictureReaderHolder = (PictureReaderHolder)this.unprocessedPictureRef.getAndSet(null)) == null || (pictureReaderHolder = pictureReaderHolder.getReader()) == null) break block1;
            pictureReaderHolder.close();
        }
    }

    @Override
    public boolean lastCaptureSuccessful() {
        return this.lastCaptureSuccessful.get();
    }

    @Override
    public void emitLastScreenshot() {
        block1: {
            Bitmap bitmap;
            if (!this.lastCaptureSuccessful() || (bitmap = this.screenshot) == null || bitmap.isRecycled()) break block1;
            ScreenshotRecorderCallback screenshotRecorderCallback = this.screenshotRecorderCallback;
            if (screenshotRecorderCallback != null) {
                screenshotRecorderCallback.onScreenshotRecorded(bitmap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void pictureRenderTask$lambda$0(CanvasStrategy this$0) {
        if (this$0.isClosed.get()) {
            this$0.options.getLogger().log(SentryLevel.DEBUG, "Canvas Strategy already closed, skipping picture render", new Object[0]);
            return;
        }
        PictureReaderHolder pictureReaderHolder = this$0.unprocessedPictureRef.getAndSet(null);
        if (pictureReaderHolder == null) {
            return;
        }
        PictureReaderHolder holder = pictureReaderHolder;
        try {
            if (!holder.getSetup().getAndSet(true)) {
                holder.getReader().setOnImageAvailableListener((ImageReader.OnImageAvailableListener)holder, this$0.executor.getBackgroundHandler());
            }
            Surface surface = holder.getReader().getSurface();
            Canvas canvas = surface.lockHardwareCanvas();
            try {
                canvas.drawColor(-16777216, PorterDuff.Mode.CLEAR);
                holder.getPicture().draw(canvas);
            }
            finally {
                surface.unlockCanvasAndPost(canvas);
            }
        }
        catch (Throwable t) {
            if (this$0.isClosed.get()) {
                holder.close();
            } else {
                this$0.freePictureRef.set(holder);
            }
            this$0.options.getLogger().log(SentryLevel.ERROR, "Canvas Strategy: picture render failed", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void close$lambda$3(CanvasStrategy this$0) {
        Bitmap bitmap = this$0.screenshot;
        if (bitmap != null) {
            Bitmap it = bitmap;
            boolean bl = false;
            Bitmap bitmap2 = it;
            synchronized (bitmap2) {
                boolean bl2 = false;
                if (!it.isRecycled()) {
                    it.recycle();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public static final /* synthetic */ ScreenshotRecorderConfig access$getConfig$p(CanvasStrategy $this) {
        return $this.config;
    }

    public static final /* synthetic */ AtomicBoolean access$isClosed$p(CanvasStrategy $this) {
        return $this.isClosed;
    }

    public static final /* synthetic */ SentryOptions access$getOptions$p(CanvasStrategy $this) {
        return $this.options;
    }

    public static final /* synthetic */ Bitmap access$getScreenshot$p(CanvasStrategy $this) {
        return $this.screenshot;
    }

    public static final /* synthetic */ AutoClosableReentrantLock access$getScreenshotLock$p(CanvasStrategy $this) {
        return $this.screenshotLock;
    }

    public static final /* synthetic */ ScreenshotRecorderCallback access$getScreenshotRecorderCallback$p(CanvasStrategy $this) {
        return $this.screenshotRecorderCallback;
    }

    public static final /* synthetic */ AtomicReference access$getFreePictureRef$p(CanvasStrategy $this) {
        return $this.freePictureRef;
    }

    public static final /* synthetic */ void access$setScreenshot$p(CanvasStrategy $this, Bitmap bitmap) {
        $this.screenshot = bitmap;
    }

    public static final /* synthetic */ AtomicBoolean access$getLastCaptureSuccessful$p(CanvasStrategy $this) {
        return $this.lastCaptureSuccessful;
    }
}

