/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.annotation.TargetApi;
import android.graphics.Point;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.ExecutorProvider;
import io.sentry.android.replay.OnRootViewsChangedListener;
import io.sentry.android.replay.Recorder;
import io.sentry.android.replay.ScreenshotRecorder;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.WindowCallback;
import io.sentry.android.replay.WindowsKt;
import io.sentry.android.replay.util.MainLooperHandler;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.util.AutoClosableReentrantLock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u00014B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\"\u001a\u00020#H\u0016J\u000e\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u001fJ\b\u0010&\u001a\u00020\u0010H\u0016J\b\u0010'\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020\u000bH\u0016J\u0010\u0010)\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020#2\u0006\u0010%\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020#H\u0016J\b\u00100\u001a\u00020#H\u0016J\b\u00101\u001a\u00020#H\u0016J\b\u00102\u001a\u00020#H\u0016J\b\u00103\u001a\u00020#H\u0016R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001c\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001dj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e` X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lio/sentry/android/replay/WindowRecorder;", "Lio/sentry/android/replay/Recorder;", "Lio/sentry/android/replay/OnRootViewsChangedListener;", "Lio/sentry/android/replay/ExecutorProvider;", "options", "Lio/sentry/SentryOptions;", "screenshotRecorderCallback", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "windowCallback", "Lio/sentry/android/replay/WindowCallback;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "replayExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/ScreenshotRecorderCallback;Lio/sentry/android/replay/WindowCallback;Lio/sentry/android/replay/util/MainLooperHandler;Ljava/util/concurrent/ScheduledExecutorService;)V", "backgroundProcessingHandler", "Landroid/os/Handler;", "backgroundProcessingHandlerLock", "Lio/sentry/util/AutoClosableReentrantLock;", "backgroundProcessingHandlerThread", "Landroid/os/HandlerThread;", "capturer", "Lio/sentry/android/replay/WindowRecorder$Capturer;", "capturerLock", "isRecording", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastKnownWindowSize", "Landroid/graphics/Point;", "rootViews", "Ljava/util/ArrayList;", "Ljava/lang/ref/WeakReference;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "rootViewsLock", "close", "", "determineWindowSize", "root", "getBackgroundHandler", "getExecutor", "getMainLooperHandler", "onConfigurationChanged", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "onRootViewsChanged", "added", "", "pause", "reset", "resume", "start", "stop", "Capturer", "sentry-android-replay_release"})
@TargetApi(value=26)
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWindowRecorder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1855#2,2:275\n1#3:277\n*S KotlinDebug\n*F\n+ 1 WindowRecorder.kt\nio/sentry/android/replay/WindowRecorder\n*L\n223#1:275,2\n*E\n"})
public final class WindowRecorder
implements Recorder,
OnRootViewsChangedListener,
ExecutorProvider {
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final ScreenshotRecorderCallback screenshotRecorderCallback;
    @NotNull
    private final WindowCallback windowCallback;
    @NotNull
    private final MainLooperHandler mainLooperHandler;
    @NotNull
    private final ScheduledExecutorService replayExecutor;
    @NotNull
    private final AtomicBoolean isRecording;
    @NotNull
    private final ArrayList<WeakReference<View>> rootViews;
    @NotNull
    private Point lastKnownWindowSize;
    @NotNull
    private final AutoClosableReentrantLock rootViewsLock;
    @NotNull
    private final AutoClosableReentrantLock capturerLock;
    @NotNull
    private final AutoClosableReentrantLock backgroundProcessingHandlerLock;
    @Nullable
    private volatile Capturer capturer;
    @Nullable
    private volatile HandlerThread backgroundProcessingHandlerThread;
    @Nullable
    private volatile Handler backgroundProcessingHandler;
    public static final int $stable = 8;

    public WindowRecorder(@NotNull SentryOptions options, @Nullable ScreenshotRecorderCallback screenshotRecorderCallback, @NotNull WindowCallback windowCallback, @NotNull MainLooperHandler mainLooperHandler, @NotNull ScheduledExecutorService replayExecutor2) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)windowCallback, (String)"windowCallback");
        Intrinsics.checkNotNullParameter((Object)mainLooperHandler, (String)"mainLooperHandler");
        Intrinsics.checkNotNullParameter((Object)replayExecutor2, (String)"replayExecutor");
        this.options = options;
        this.screenshotRecorderCallback = screenshotRecorderCallback;
        this.windowCallback = windowCallback;
        this.mainLooperHandler = mainLooperHandler;
        this.replayExecutor = replayExecutor2;
        this.isRecording = new AtomicBoolean(false);
        this.rootViews = new ArrayList();
        this.lastKnownWindowSize = new Point();
        this.rootViewsLock = new AutoClosableReentrantLock();
        this.capturerLock = new AutoClosableReentrantLock();
        this.backgroundProcessingHandlerLock = new AutoClosableReentrantLock();
    }

    public /* synthetic */ WindowRecorder(SentryOptions sentryOptions, ScreenshotRecorderCallback screenshotRecorderCallback, WindowCallback windowCallback, MainLooperHandler mainLooperHandler, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            screenshotRecorderCallback = null;
        }
        this(sentryOptions, screenshotRecorderCallback, windowCallback, mainLooperHandler, scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRootViewsChanged(@NotNull View root, boolean added) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        AutoCloseable autoCloseable = (AutoCloseable)this.rootViewsLock.acquire();
        Throwable throwable = null;
        try {
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            if (added) {
                if (WindowsKt.getPhoneWindow(root) == null) {
                    this.options.getLogger().log(SentryLevel.WARNING, "Root view does not have a phone window, skipping.", new Object[0]);
                    return;
                }
                this.rootViews.add(new WeakReference<View>(root));
                Object object = this.capturer;
                if (object != null && (object = ((Capturer)object).getRecorder()) != null) {
                    ((ScreenshotRecorder)object).bind(root);
                }
                this.determineWindowSize(root);
            } else {
                View newRoot;
                Object object = this.capturer;
                if (object != null && (object = ((Capturer)object).getRecorder()) != null) {
                    ((ScreenshotRecorder)object).unbind(root);
                }
                CollectionsKt.removeAll((List)this.rootViews, (Function1)((Function1)new Function1<WeakReference<View>, Boolean>(root){
                    final /* synthetic */ View $root;
                    {
                        this.$root = $root;
                        super(1);
                    }

                    public final Boolean invoke(WeakReference<View> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return Intrinsics.areEqual(it.get(), (Object)this.$root);
                    }
                }));
                WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)this.rootViews);
                Object object2 = newRoot = weakReference != null ? (View)weakReference.get() : null;
                if (newRoot != null && !Intrinsics.areEqual((Object)root, (Object)newRoot)) {
                    Object object3 = this.capturer;
                    if (object3 != null && (object3 = ((Capturer)object3).getRecorder()) != null) {
                        ((ScreenshotRecorder)object3).bind(newRoot);
                    }
                    this.determineWindowSize(newRoot);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void determineWindowSize(@NotNull View root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (ViewsKt.hasSize(root)) {
            if (root.getWidth() != this.lastKnownWindowSize.x && root.getHeight() != this.lastKnownWindowSize.y) {
                this.lastKnownWindowSize.set(root.getWidth(), root.getHeight());
                this.windowCallback.onWindowSizeChanged(root.getWidth(), root.getHeight());
            }
        } else {
            ViewsKt.addOnPreDrawListenerSafe(root, new ViewTreeObserver.OnPreDrawListener(this, root){
                final /* synthetic */ WindowRecorder this$0;
                final /* synthetic */ View $root;
                {
                    this.this$0 = $receiver;
                    this.$root = $root;
                }

                public boolean onPreDraw() {
                    View currentRoot;
                    WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)WindowRecorder.access$getRootViews$p(this.this$0));
                    Object object = currentRoot = weakReference != null ? (View)weakReference.get() : null;
                    if (!Intrinsics.areEqual((Object)this.$root, (Object)currentRoot)) {
                        ViewsKt.removeOnPreDrawListenerSafe(this.$root, this);
                        return true;
                    }
                    if (ViewsKt.hasSize(this.$root)) {
                        ViewsKt.removeOnPreDrawListenerSafe(this.$root, this);
                        if (this.$root.getWidth() != WindowRecorder.access$getLastKnownWindowSize$p((WindowRecorder)this.this$0).x && this.$root.getHeight() != WindowRecorder.access$getLastKnownWindowSize$p((WindowRecorder)this.this$0).y) {
                            WindowRecorder.access$getLastKnownWindowSize$p(this.this$0).set(this.$root.getWidth(), this.$root.getHeight());
                            WindowRecorder.access$getWindowCallback$p(this.this$0).onWindowSizeChanged(this.$root.getWidth(), this.$root.getHeight());
                        }
                    }
                    return true;
                }
            });
        }
    }

    @Override
    public void start() {
        this.isRecording.getAndSet(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig config) {
        Object object;
        View newRoot;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.isRecording.get()) {
            return;
        }
        if (this.capturer == null) {
            AutoCloseable autoCloseable = (AutoCloseable)this.capturerLock.acquire();
            Throwable throwable = null;
            try {
                ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                boolean bl = false;
                if (this.capturer == null) {
                    this.capturer = new Capturer(this.options, this.mainLooperHandler);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        Capturer capturer = this.capturer;
        if (capturer != null) {
            capturer.setConfig(config);
        }
        Capturer capturer2 = this.capturer;
        if (capturer2 != null) {
            capturer2.setRecorder(new ScreenshotRecorder(config, this.options, this, this.screenshotRecorderCallback));
        }
        WeakReference weakReference = (WeakReference)CollectionsKt.lastOrNull((List)this.rootViews);
        Object object2 = newRoot = weakReference != null ? (View)weakReference.get() : null;
        if (newRoot != null && (object = this.capturer) != null && (object = ((Capturer)object).getRecorder()) != null) {
            ((ScreenshotRecorder)object).bind(newRoot);
        }
        this.mainLooperHandler.removeCallbacks(this.capturer);
        boolean posted = this.mainLooperHandler.postDelayed(this.capturer, 100L);
        if (!posted) {
            this.options.getLogger().log(SentryLevel.WARNING, "Failed to post the capture runnable, main looper is shutting down.", new Object[0]);
        }
    }

    @Override
    public void resume() {
        block0: {
            Capturer capturer = this.capturer;
            if (capturer == null) break block0;
            capturer.resume();
        }
    }

    @Override
    public void pause() {
        block0: {
            Capturer capturer = this.capturer;
            if (capturer == null) break block0;
            capturer.pause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lastKnownWindowSize.set(0, 0);
        AutoCloseable autoCloseable = (AutoCloseable)this.rootViewsLock.acquire();
        Throwable throwable = null;
        try {
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            Iterable $this$forEach$iv = this.rootViews;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WeakReference it2 = (WeakReference)element$iv;
                boolean bl2 = false;
                Object object = this.capturer;
                if (object == null || (object = ((Capturer)object).getRecorder()) == null) continue;
                ((ScreenshotRecorder)object).unbind((View)it2.get());
            }
            this.rootViews.clear();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Capturer capturer = this.capturer;
        if (capturer != null) {
            capturer.stop();
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.capturerLock.acquire();
        Throwable throwable = null;
        try {
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            this.capturer = null;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.isRecording.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.reset();
        this.mainLooperHandler.removeCallbacks(this.capturer);
        AutoCloseable autoCloseable = (AutoCloseable)this.backgroundProcessingHandlerLock.acquire();
        Throwable throwable = null;
        try {
            ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
            boolean bl = false;
            Handler handler = this.backgroundProcessingHandler;
            if (handler != null) {
                handler.removeCallbacksAndMessages(null);
            }
            HandlerThread handlerThread = this.backgroundProcessingHandlerThread;
            Boolean bl2 = handlerThread != null ? Boolean.valueOf(handlerThread.quitSafely()) : null;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.stop();
    }

    @Override
    @NotNull
    public ScheduledExecutorService getExecutor() {
        return this.replayExecutor;
    }

    @Override
    @NotNull
    public MainLooperHandler getMainLooperHandler() {
        return this.mainLooperHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Handler getBackgroundHandler() {
        if (this.backgroundProcessingHandler == null) {
            AutoCloseable autoCloseable = (AutoCloseable)this.backgroundProcessingHandlerLock.acquire();
            Throwable throwable = null;
            try {
                ISentryLifecycleToken it = (ISentryLifecycleToken)autoCloseable;
                boolean bl = false;
                if (this.backgroundProcessingHandler == null) {
                    HandlerThread handlerThread = this.backgroundProcessingHandlerThread = new HandlerThread("SentryReplayBackgroundProcessing");
                    if (handlerThread != null) {
                        handlerThread.start();
                    }
                    HandlerThread handlerThread2 = this.backgroundProcessingHandlerThread;
                    Intrinsics.checkNotNull((Object)handlerThread2);
                    this.backgroundProcessingHandler = new Handler(handlerThread2.getLooper());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        Handler handler = this.backgroundProcessingHandler;
        Intrinsics.checkNotNull((Object)handler);
        return handler;
    }

    public static final /* synthetic */ ArrayList access$getRootViews$p(WindowRecorder $this) {
        return $this.rootViews;
    }

    public static final /* synthetic */ Point access$getLastKnownWindowSize$p(WindowRecorder $this) {
        return $this.lastKnownWindowSize;
    }

    public static final /* synthetic */ WindowCallback access$getWindowCallback$p(WindowRecorder $this) {
        return $this.windowCallback;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0006\u0010\u0019\u001a\u00020\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lio/sentry/android/replay/WindowRecorder$Capturer;", "Ljava/lang/Runnable;", "options", "Lio/sentry/SentryOptions;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "(Lio/sentry/SentryOptions;Lio/sentry/android/replay/util/MainLooperHandler;)V", "config", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "getConfig", "()Lio/sentry/android/replay/ScreenshotRecorderConfig;", "setConfig", "(Lio/sentry/android/replay/ScreenshotRecorderConfig;)V", "isRecording", "Ljava/util/concurrent/atomic/AtomicBoolean;", "recorder", "Lio/sentry/android/replay/ScreenshotRecorder;", "getRecorder", "()Lio/sentry/android/replay/ScreenshotRecorder;", "setRecorder", "(Lio/sentry/android/replay/ScreenshotRecorder;)V", "pause", "", "resume", "run", "stop", "sentry-android-replay_release"})
    private static final class Capturer
    implements Runnable {
        @NotNull
        private final SentryOptions options;
        @NotNull
        private final MainLooperHandler mainLooperHandler;
        @Nullable
        private ScreenshotRecorder recorder;
        @Nullable
        private ScreenshotRecorderConfig config;
        @NotNull
        private final AtomicBoolean isRecording;

        public Capturer(@NotNull SentryOptions options, @NotNull MainLooperHandler mainLooperHandler) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)mainLooperHandler, (String)"mainLooperHandler");
            this.options = options;
            this.mainLooperHandler = mainLooperHandler;
            this.isRecording = new AtomicBoolean(true);
        }

        @Nullable
        public final ScreenshotRecorder getRecorder() {
            return this.recorder;
        }

        public final void setRecorder(@Nullable ScreenshotRecorder screenshotRecorder) {
            this.recorder = screenshotRecorder;
        }

        @Nullable
        public final ScreenshotRecorderConfig getConfig() {
            return this.config;
        }

        public final void setConfig(@Nullable ScreenshotRecorderConfig screenshotRecorderConfig) {
            this.config = screenshotRecorderConfig;
        }

        public final void resume() {
            if (this.options.getSessionReplay().isDebug()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Resuming the capture runnable.", new Object[0]);
            }
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder != null) {
                screenshotRecorder.resume();
            }
            this.isRecording.getAndSet(true);
            this.mainLooperHandler.removeCallbacks(this);
            boolean posted = this.mainLooperHandler.post(this);
            if (!posted) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to post the capture runnable, main looper is not ready.", new Object[0]);
            }
        }

        public final void pause() {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder != null) {
                screenshotRecorder.pause();
            }
            this.isRecording.getAndSet(false);
        }

        public final void stop() {
            ScreenshotRecorder screenshotRecorder = this.recorder;
            if (screenshotRecorder != null) {
                screenshotRecorder.close();
            }
            this.recorder = null;
            this.isRecording.getAndSet(false);
        }

        @Override
        public void run() {
            if (!this.isRecording.get()) {
                if (this.options.getSessionReplay().isDebug()) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "Not capturing frames, recording is not running.", new Object[0]);
                }
                return;
            }
            try {
                if (this.options.getSessionReplay().isDebug()) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "Capturing a frame.", new Object[0]);
                }
                ScreenshotRecorder screenshotRecorder = this.recorder;
                if (screenshotRecorder != null) {
                    screenshotRecorder.capture();
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.ERROR, "Failed to capture a frame", e);
            }
            if (this.options.getSessionReplay().isDebug()) {
                ScreenshotRecorderConfig screenshotRecorderConfig = this.config;
                this.options.getLogger().log(SentryLevel.DEBUG, "Posting the capture runnable again, frame rate is " + (screenshotRecorderConfig != null ? screenshotRecorderConfig.getFrameRate() : 1) + " fps.", new Object[0]);
            }
            ScreenshotRecorderConfig screenshotRecorderConfig = this.config;
            boolean posted = this.mainLooperHandler.postDelayed(this, 1000L / (long)(screenshotRecorderConfig != null ? screenshotRecorderConfig.getFrameRate() : 1));
            if (!posted) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to post the capture runnable, main looper is shutting down.", new Object[0]);
            }
        }
    }
}

