/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.gestures;

import android.view.MotionEvent;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.rrweb.RRWebIncrementalSnapshotEvent;
import io.sentry.rrweb.RRWebInteractionEvent;
import io.sentry.rrweb.RRWebInteractionMoveEvent;
import io.sentry.transport.ICurrentDateProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015RJ\u0010\u0005\u001a>\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n0\u0006j\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/sentry/android/replay/gestures/ReplayGestureConverter;", "", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "(Lio/sentry/transport/ICurrentDateProvider;)V", "currentPositions", "Ljava/util/LinkedHashMap;", "", "Ljava/util/ArrayList;", "Lio/sentry/rrweb/RRWebInteractionMoveEvent$Position;", "Lkotlin/collections/ArrayList;", "Lkotlin/collections/LinkedHashMap;", "lastCapturedMoveEvent", "", "touchMoveBaseline", "convert", "", "Lio/sentry/rrweb/RRWebIncrementalSnapshotEvent;", "event", "Landroid/view/MotionEvent;", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "Companion", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nReplayGestureConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplayGestureConverter.kt\nio/sentry/android/replay/gestures/ReplayGestureConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n1855#2,2:151\n1549#2:153\n1620#2,3:154\n*S KotlinDebug\n*F\n+ 1 ReplayGestureConverter.kt\nio/sentry/android/replay/gestures/ReplayGestureConverter\n*L\n38#1:151,2\n69#1:153\n69#1:154,3\n*E\n"})
public final class ReplayGestureConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @NotNull
    private final LinkedHashMap<Integer, ArrayList<RRWebInteractionMoveEvent.Position>> currentPositions;
    private long touchMoveBaseline;
    private long lastCapturedMoveEvent;
    public static final int $stable = 8;
    private static final int TOUCH_MOVE_DEBOUNCE_THRESHOLD = 50;
    private static final int CAPTURE_MOVE_EVENT_THRESHOLD = 500;

    public ReplayGestureConverter(@NotNull ICurrentDateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this.dateProvider = dateProvider;
        this.currentPositions = new LinkedHashMap(10);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<RRWebIncrementalSnapshotEvent> convert(@NotNull MotionEvent event, @NotNull ScreenshotRecorderConfig recorderConfig) {
        List list;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        switch (event.getActionMasked()) {
            case 2: {
                List list2;
                RRWebInteractionMoveEvent.Position position;
                Collection collection;
                long now = this.dateProvider.getCurrentTimeMillis();
                if (this.lastCapturedMoveEvent != 0L && this.lastCapturedMoveEvent + (long)50 > now) {
                    return null;
                }
                this.lastCapturedMoveEvent = now;
                Set<Integer> set = this.currentPositions.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
                Iterable $this$forEach$iv = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Integer pId = (Integer)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)pId);
                    int pIndex = event.findPointerIndex(pId.intValue());
                    if (pIndex == -1) continue;
                    if (this.touchMoveBaseline == 0L) {
                        this.touchMoveBaseline = now;
                    }
                    ArrayList<RRWebInteractionMoveEvent.Position> arrayList = this.currentPositions.get(pId);
                    Intrinsics.checkNotNull(arrayList);
                    collection = arrayList;
                    RRWebInteractionMoveEvent.Position $this$convert_u24lambda_u241_u24lambda_u240 = position = new RRWebInteractionMoveEvent.Position();
                    boolean bl2 = false;
                    $this$convert_u24lambda_u241_u24lambda_u240.setX(event.getX(pIndex) * recorderConfig.getScaleFactorX());
                    $this$convert_u24lambda_u241_u24lambda_u240.setY(event.getY(pIndex) * recorderConfig.getScaleFactorY());
                    $this$convert_u24lambda_u241_u24lambda_u240.setId(0);
                    $this$convert_u24lambda_u241_u24lambda_u240.setTimeOffset(now - this.touchMoveBaseline);
                    collection.add(position);
                }
                long totalOffset = now - this.touchMoveBaseline;
                if (totalOffset > 500L) {
                    ArrayList moveEvents = new ArrayList(this.currentPositions.size());
                    for (Map.Entry entry : ((Map)this.currentPositions).entrySet()) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        int pointerId = ((Number)entry.getKey()).intValue();
                        ArrayList positions = (ArrayList)entry.getValue();
                        if (!(!((Collection)positions).isEmpty())) continue;
                        collection = moveEvents;
                        RRWebInteractionMoveEvent.Position $this$convert_u24lambda_u243 = position = new RRWebInteractionMoveEvent();
                        boolean bl = false;
                        $this$convert_u24lambda_u243.setTimestamp(now);
                        Iterable iterable = positions;
                        RRWebInteractionMoveEvent.Position position2 = $this$convert_u24lambda_u243;
                        boolean $i$f$map = false;
                        void var19_30 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void pos;
                            RRWebInteractionMoveEvent.Position position3 = (RRWebInteractionMoveEvent.Position)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            boolean bl3 = false;
                            pos.setTimeOffset(pos.getTimeOffset() - totalOffset);
                            collection2.add(pos);
                        }
                        position2.setPositions((List)destination$iv$iv);
                        $this$convert_u24lambda_u243.setPointerId(pointerId);
                        collection.add(position);
                        ArrayList<RRWebInteractionMoveEvent.Position> arrayList = this.currentPositions.get(pointerId);
                        Intrinsics.checkNotNull(arrayList);
                        arrayList.clear();
                    }
                    this.touchMoveBaseline = 0L;
                    list2 = moveEvents;
                } else {
                    list2 = null;
                }
                return list2;
            }
            case 0: 
            case 5: {
                RRWebInteractionEvent totalOffset;
                int pId = event.getPointerId(event.getActionIndex());
                int pIndex = event.findPointerIndex(pId);
                if (pIndex == -1) {
                    return null;
                }
                ((Map)this.currentPositions).put(pId, new ArrayList(10));
                RRWebInteractionEvent $this$convert_u24lambda_u244 = totalOffset = new RRWebInteractionEvent();
                boolean bl = false;
                $this$convert_u24lambda_u244.setTimestamp(this.dateProvider.getCurrentTimeMillis());
                $this$convert_u24lambda_u244.setX(event.getX(pIndex) * recorderConfig.getScaleFactorX());
                $this$convert_u24lambda_u244.setY(event.getY(pIndex) * recorderConfig.getScaleFactorY());
                $this$convert_u24lambda_u244.setId(0);
                $this$convert_u24lambda_u244.setPointerId(pId);
                $this$convert_u24lambda_u244.setInteractionType(RRWebInteractionEvent.InteractionType.TouchStart);
                list = CollectionsKt.listOf((Object)totalOffset);
                break;
            }
            case 1: 
            case 6: {
                RRWebInteractionEvent totalOffset;
                int pId = event.getPointerId(event.getActionIndex());
                int pIndex = event.findPointerIndex(pId);
                if (pIndex == -1) {
                    return null;
                }
                this.currentPositions.remove(pId);
                RRWebInteractionEvent $this$convert_u24lambda_u245 = totalOffset = new RRWebInteractionEvent();
                boolean bl = false;
                $this$convert_u24lambda_u245.setTimestamp(this.dateProvider.getCurrentTimeMillis());
                $this$convert_u24lambda_u245.setX(event.getX(pIndex) * recorderConfig.getScaleFactorX());
                $this$convert_u24lambda_u245.setY(event.getY(pIndex) * recorderConfig.getScaleFactorY());
                $this$convert_u24lambda_u245.setId(0);
                $this$convert_u24lambda_u245.setPointerId(pId);
                $this$convert_u24lambda_u245.setInteractionType(RRWebInteractionEvent.InteractionType.TouchEnd);
                list = CollectionsKt.listOf((Object)totalOffset);
                break;
            }
            case 3: {
                RRWebInteractionEvent rRWebInteractionEvent;
                this.currentPositions.clear();
                RRWebInteractionEvent $this$convert_u24lambda_u246 = rRWebInteractionEvent = new RRWebInteractionEvent();
                boolean bl = false;
                $this$convert_u24lambda_u246.setTimestamp(this.dateProvider.getCurrentTimeMillis());
                $this$convert_u24lambda_u246.setX(event.getX() * recorderConfig.getScaleFactorX());
                $this$convert_u24lambda_u246.setY(event.getY() * recorderConfig.getScaleFactorY());
                $this$convert_u24lambda_u246.setId(0);
                $this$convert_u24lambda_u246.setPointerId(0);
                $this$convert_u24lambda_u246.setInteractionType(RRWebInteractionEvent.InteractionType.TouchCancel);
                list = CollectionsKt.listOf((Object)rRWebInteractionEvent);
                break;
            }
            default: {
                list = null;
            }
        }
        return list;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/sentry/android/replay/gestures/ReplayGestureConverter$Companion;", "", "()V", "CAPTURE_MOVE_EVENT_THRESHOLD", "", "TOUCH_MOVE_DEBOUNCE_THRESHOLD", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

