/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.viewhierarchy;

import android.annotation.TargetApi;
import android.graphics.Rect;
import android.view.View;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.text.TextLayoutResult;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.SentryReplayModifiers;
import io.sentry.android.replay.util.ComposeTextLayout;
import io.sentry.android.replay.util.NodesKt;
import io.sentry.android.replay.util.TextAttributes;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.android.replay.viewhierarchy.ViewHierarchyNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\b2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u001c\u0010\u0016\u001a\u00020\r*\u00020\b2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0017\u001a\u00020\u0018*\u00020\b2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode;", "", "()V", "_rootCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "fromComposeNode", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "node", "Landroidx/compose/ui/node/LayoutNode;", "parent", "distance", "", "isComposeRoot", "", "options", "Lio/sentry/SentryOptions;", "fromView", "view", "Landroid/view/View;", "getProxyClassName", "", "isImage", "shouldMask", "traverse", "", "parentNode", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nComposeViewHierarchyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n*L\n1#1,214:1\n652#2:215\n*S KotlinDebug\n*F\n+ 1 ComposeViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode\n*L\n103#1:215\n*E\n"})
public final class ComposeViewHierarchyNode {
    @NotNull
    public static final ComposeViewHierarchyNode INSTANCE = new ComposeViewHierarchyNode();
    @Nullable
    private static LayoutCoordinates _rootCoordinates;

    private ComposeViewHierarchyNode() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getProxyClassName(LayoutNode $this$getProxyClassName, boolean isImage) {
        boolean bl;
        if (isImage) {
            return "android.widget.ImageView";
        }
        SemanticsConfiguration semanticsConfiguration = $this$getProxyClassName.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration != null) {
            if (semanticsConfiguration.contains(SemanticsProperties.INSTANCE.getText())) {
                return "android.widget.TextView";
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return "android.widget.TextView";
        SemanticsConfiguration semanticsConfiguration2 = $this$getProxyClassName.getCollapsedSemantics$ui_release();
        if (semanticsConfiguration2 == null) return "android.view.View";
        if (!semanticsConfiguration2.contains(SemanticsActions.INSTANCE.getSetText())) return "android.view.View";
        return "android.widget.TextView";
    }

    private final boolean shouldMask(LayoutNode $this$shouldMask, boolean isImage, SentryOptions options) {
        String sentryPrivacyModifier;
        SemanticsConfiguration semanticsConfiguration = $this$shouldMask.getCollapsedSemantics$ui_release();
        String string = sentryPrivacyModifier = semanticsConfiguration != null ? (String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsConfiguration, SentryReplayModifiers.INSTANCE.getSentryPrivacy()) : null;
        if (Intrinsics.areEqual((Object)sentryPrivacyModifier, (Object)"unmask")) {
            return false;
        }
        if (Intrinsics.areEqual((Object)sentryPrivacyModifier, (Object)"mask")) {
            return true;
        }
        String className = this.getProxyClassName($this$shouldMask, isImage);
        if (options.getExperimental().getSessionReplay().getUnmaskViewClasses().contains(className)) {
            return false;
        }
        return options.getExperimental().getSessionReplay().getMaskViewClasses().contains(className);
    }

    private final ViewHierarchyNode fromComposeNode(LayoutNode node, ViewHierarchyNode parent, int distance, boolean isComposeRoot, SentryOptions options) {
        ViewHierarchyNode viewHierarchyNode;
        boolean isInTree;
        boolean bl = isInTree = node.isPlaced() && node.isAttached();
        if (!isInTree) {
            return null;
        }
        if (isComposeRoot) {
            _rootCoordinates = LayoutCoordinatesKt.findRootCoordinates((LayoutCoordinates)node.getCoordinates());
        }
        SemanticsConfiguration semantics = node.getCollapsedSemantics$ui_release();
        Rect visibleRect = NodesKt.boundsInWindow(node.getCoordinates(), _rootCoordinates);
        boolean isVisible = !node.getOuterCoordinator$ui_release().isTransparent() && (semantics == null || !semantics.contains(SemanticsProperties.INSTANCE.getInvisibleToUser())) && visibleRect.height() > 0 && visibleRect.width() > 0;
        SemanticsConfiguration semanticsConfiguration = semantics;
        boolean isEditable = semanticsConfiguration != null ? semanticsConfiguration.contains(SemanticsActions.INSTANCE.getSetText()) : false;
        long positionInWindow = LayoutCoordinatesKt.positionInWindow((LayoutCoordinates)node.getCoordinates());
        SemanticsConfiguration semanticsConfiguration2 = semantics;
        boolean bl2 = semanticsConfiguration2 != null ? semanticsConfiguration2.contains(SemanticsProperties.INSTANCE.getText()) : false;
        if (bl2 || isEditable) {
            boolean bl3;
            Color textColor;
            Function1 function1;
            TextAttributes textAttributes;
            boolean shouldMask = isVisible && this.shouldMask(node, false, options);
            ViewHierarchyNode viewHierarchyNode2 = parent;
            if (viewHierarchyNode2 != null) {
                viewHierarchyNode2.setImportantForCaptureToAncestors(true);
            }
            List textLayoutResults = new ArrayList();
            if (semantics != null && (textAttributes = (AccessibilityAction)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semantics, (SemanticsPropertyKey)SemanticsActions.INSTANCE.getGetTextLayoutResult())) != null && (function1 = (Function1)textAttributes.getAction()) != null) {
                Boolean cfr_ignored_0 = (Boolean)function1.invoke((Object)textLayoutResults);
            }
            textAttributes = NodesKt.findTextAttributes(node);
            Color color = textAttributes.component1-QN2ZGVo();
            boolean hasFillModifier = textAttributes.component2();
            TextLayoutResult textLayoutResult = (TextLayoutResult)CollectionsKt.firstOrNull((List)textLayoutResults);
            Color color2 = textColor = textLayoutResult != null && (textLayoutResult = textLayoutResult.getLayoutInput()) != null && (textLayoutResult = textLayoutResult.getStyle()) != null ? Color.box-impl((long)textLayoutResult.getColor-0d7_KjU()) : null;
            if (color2 != null) {
                long $this$isUnspecified$iv = color2.unbox-impl();
                boolean bl4 = false;
                bl3 = $this$isUnspecified$iv == Color.Companion.getUnspecified-0d7_KjU();
            } else {
                bl3 = false;
            }
            if (bl3) {
                textColor = color;
            }
            Color color3 = textColor;
            ViewHierarchyNode viewHierarchyNode3 = parent;
            viewHierarchyNode = new ViewHierarchyNode.TextViewHierarchyNode(!((Collection)textLayoutResults).isEmpty() && !isEditable ? new ComposeTextLayout((TextLayoutResult)CollectionsKt.first((List)textLayoutResults), hasFillModifier) : null, color3 != null ? Integer.valueOf(ViewsKt.toOpaque(ColorKt.toArgb-8_81llA((long)color3.unbox-impl()))) : null, 0, 0, Offset.getX-impl((long)positionInWindow), Offset.getY-impl((long)positionInWindow), node.getWidth(), node.getHeight(), viewHierarchyNode3 != null ? viewHierarchyNode3.getElevation() : 0.0f, distance, parent, shouldMask, true, isVisible, visibleRect, 12, null);
        } else {
            Painter painter = NodesKt.findPainter(node);
            if (painter != null) {
                boolean shouldMask = isVisible && this.shouldMask(node, true, options);
                ViewHierarchyNode viewHierarchyNode4 = parent;
                if (viewHierarchyNode4 != null) {
                    viewHierarchyNode4.setImportantForCaptureToAncestors(true);
                }
                float f = Offset.getX-impl((long)positionInWindow);
                float f2 = Offset.getY-impl((long)positionInWindow);
                int n = node.getWidth();
                int n2 = node.getHeight();
                ViewHierarchyNode viewHierarchyNode5 = parent;
                float f3 = viewHierarchyNode5 != null ? viewHierarchyNode5.getElevation() : 0.0f;
                boolean bl5 = shouldMask && NodesKt.isMaskable(painter);
                viewHierarchyNode = new ViewHierarchyNode.ImageViewHierarchyNode(f, f2, n, n2, f3, distance, parent, bl5, true, isVisible, visibleRect);
            } else {
                boolean shouldMask = isVisible && this.shouldMask(node, false, options);
                ViewHierarchyNode viewHierarchyNode6 = parent;
                viewHierarchyNode = new ViewHierarchyNode.GenericViewHierarchyNode(Offset.getX-impl((long)positionInWindow), Offset.getY-impl((long)positionInWindow), node.getWidth(), node.getHeight(), viewHierarchyNode6 != null ? viewHierarchyNode6.getElevation() : 0.0f, distance, parent, shouldMask, false, isVisible, visibleRect);
            }
        }
        return viewHierarchyNode;
    }

    public final boolean fromView(@NotNull View view, @Nullable ViewHierarchyNode parent, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = view.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view::class.java.name");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"AndroidComposeView", (boolean)false, (int)2, null)) {
            return false;
        }
        if (parent == null) {
            return false;
        }
        try {
            Owner owner = view instanceof Owner ? (Owner)view : null;
            if (owner == null || (owner = owner.getRoot()) == null) {
                return false;
            }
            Owner rootNode = owner;
            this.traverse((LayoutNode)rootNode, parent, true, options);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, e, "Error traversing Compose tree. Most likely you're using an unsupported version of\nandroidx.compose.ui:ui. The minimum supported version is 1.5.0. If it's a newer\nversion, please open a github issue with the version you're using, so we can add\nsupport for it.", new Object[0]);
            return false;
        }
        return true;
    }

    private final void traverse(LayoutNode $this$traverse, ViewHierarchyNode parentNode, boolean isComposeRoot, SentryOptions options) {
        List children = $this$traverse.getChildren$ui_release();
        if (children.isEmpty()) {
            return;
        }
        ArrayList<ViewHierarchyNode> childNodes = new ArrayList<ViewHierarchyNode>(children.size());
        int n = children.size();
        for (int index = 0; index < n; ++index) {
            LayoutNode child = (LayoutNode)children.get(index);
            ViewHierarchyNode childNode = this.fromComposeNode(child, parentNode, index, isComposeRoot, options);
            if (childNode == null) continue;
            childNodes.add(childNode);
            this.traverse(child, childNode, false, options);
        }
        parentNode.setChildren((List<? extends ViewHierarchyNode>)childNodes);
    }
}

