/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.viewhierarchy;

import android.annotation.TargetApi;
import android.view.View;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsConfiguration;
import androidx.compose.ui.semantics.SemanticsConfigurationKt;
import androidx.compose.ui.semantics.SemanticsProperties;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.unit.TextUnit;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.replay.SentryReplayModifiers;
import io.sentry.android.replay.util.ComposeTextLayout;
import io.sentry.android.replay.util.NodesKt;
import io.sentry.android.replay.util.ViewsKt;
import io.sentry.android.replay.viewhierarchy.ComposeViewHierarchyNode;
import io.sentry.android.replay.viewhierarchy.ViewHierarchyNode;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0017\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b!J\u001e\u0010\"\u001a\u00020\r*\u0004\u0018\u00010\u001f2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010#\u001a\u00020$*\u00020\u00112\u0006\u0010%\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode;", "", "()V", "_rootCoordinates", "Ljava/lang/ref/WeakReference;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "getSemanticsConfigurationMethod", "Ljava/lang/reflect/Method;", "getGetSemanticsConfigurationMethod", "()Ljava/lang/reflect/Method;", "getSemanticsConfigurationMethod$delegate", "Lkotlin/Lazy;", "semanticsRetrievalErrorLogged", "", "fromComposeNode", "Lio/sentry/android/replay/viewhierarchy/ViewHierarchyNode;", "node", "Landroidx/compose/ui/node/LayoutNode;", "parent", "distance", "", "isComposeRoot", "options", "Lio/sentry/SentryOptions;", "fromView", "view", "Landroid/view/View;", "getProxyClassName", "", "isImage", "config", "Landroidx/compose/ui/semantics/SemanticsConfiguration;", "retrieveSemanticsConfiguration", "retrieveSemanticsConfiguration$sentry_android_replay_release", "shouldMask", "traverse", "", "parentNode", "sentry-android-replay_release"})
@TargetApi(value=26)
@SourceDebugExtension(value={"SMAP\nComposeViewHierarchyNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n*L\n1#1,286:1\n652#2:287\n*S KotlinDebug\n*F\n+ 1 ComposeViewHierarchyNode.kt\nio/sentry/android/replay/viewhierarchy/ComposeViewHierarchyNode\n*L\n171#1:287\n*E\n"})
public final class ComposeViewHierarchyNode {
    @NotNull
    public static final ComposeViewHierarchyNode INSTANCE = new ComposeViewHierarchyNode();
    @NotNull
    private static final Lazy getSemanticsConfigurationMethod$delegate = LazyKt.lazy((Function0)getSemanticsConfigurationMethod.2.INSTANCE);
    private static boolean semanticsRetrievalErrorLogged;
    @Nullable
    private static WeakReference<LayoutCoordinates> _rootCoordinates;

    private ComposeViewHierarchyNode() {
    }

    private final Method getGetSemanticsConfigurationMethod() {
        Lazy lazy = getSemanticsConfigurationMethod$delegate;
        return (Method)lazy.getValue();
    }

    @JvmStatic
    @Nullable
    public static final SemanticsConfiguration retrieveSemanticsConfiguration$sentry_android_replay_release(@NotNull LayoutNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Method method = INSTANCE.getGetSemanticsConfigurationMethod();
        if (method != null) {
            Method it = method;
            boolean bl = false;
            return (SemanticsConfiguration)it.invoke((Object)node, new Object[0]);
        }
        return node.getCollapsedSemantics$ui_release();
    }

    private final String getProxyClassName(boolean isImage, SemanticsConfiguration config) {
        return isImage ? "android.widget.ImageView" : (config != null && (config.contains(SemanticsProperties.INSTANCE.getText()) || config.contains(SemanticsActions.INSTANCE.getSetText()) || config.contains(SemanticsProperties.INSTANCE.getEditableText())) ? "android.widget.TextView" : "android.view.View");
    }

    private final boolean shouldMask(SemanticsConfiguration $this$shouldMask, boolean isImage, SentryOptions options) {
        String sentryPrivacyModifier;
        SemanticsConfiguration semanticsConfiguration = $this$shouldMask;
        String string = sentryPrivacyModifier = semanticsConfiguration != null ? (String)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semanticsConfiguration, SentryReplayModifiers.INSTANCE.getSentryPrivacy()) : null;
        if (Intrinsics.areEqual((Object)sentryPrivacyModifier, (Object)"unmask")) {
            return false;
        }
        if (Intrinsics.areEqual((Object)sentryPrivacyModifier, (Object)"mask")) {
            return true;
        }
        String className = this.getProxyClassName(isImage, $this$shouldMask);
        if (options.getSessionReplay().getUnmaskViewClasses().contains(className)) {
            return false;
        }
        return options.getSessionReplay().getMaskViewClasses().contains(className);
    }

    /*
     * Unable to fully structure code
     */
    private final ViewHierarchyNode fromComposeNode(LayoutNode node, ViewHierarchyNode parent, int distance, boolean isComposeRoot, SentryOptions options) {
        v0 = isInTree = node.isPlaced() != false && node.isAttached() != false;
        if (!isInTree) {
            return null;
        }
        if (isComposeRoot) {
            ComposeViewHierarchyNode._rootCoordinates = new WeakReference<LayoutCoordinates>(LayoutCoordinatesKt.findRootCoordinates((LayoutCoordinates)node.getCoordinates()));
        }
        v1 = ComposeViewHierarchyNode._rootCoordinates;
        visibleRect = NodesKt.boundsInWindow(node.getCoordinates(), (LayoutCoordinates)(v1 != null ? (LayoutCoordinates)v1.get() : null));
        semantics = null;
        try {
            semantics = ComposeViewHierarchyNode.retrieveSemanticsConfiguration$sentry_android_replay_release(node);
        }
        catch (Throwable t) {
            if (!ComposeViewHierarchyNode.semanticsRetrievalErrorLogged) {
                ComposeViewHierarchyNode.semanticsRetrievalErrorLogged = true;
                options.getLogger().log(SentryLevel.ERROR, t, "Error retrieving semantics information from Compose tree. Most likely you're using\nan unsupported version of androidx.compose.ui:ui. The supported\nversion range is 1.5.0 - 1.8.0.\nIf you're using a newer version, please open a github issue with the version\nyou're using, so we can add support for it.", new Object[0]);
            }
            v2 = parent;
            return new ViewHierarchyNode.GenericViewHierarchyNode(visibleRect.left, visibleRect.top, node.getWidth(), node.getHeight(), v2 != null ? v2.getElevation() : 0.0f, distance, parent, true, false, node.getOuterCoordinator$ui_release().isTransparent() == false && visibleRect.height() > 0 && visibleRect.width() > 0, visibleRect);
        }
        isVisible = node.getOuterCoordinator$ui_release().isTransparent() == false && (semantics == null || semantics.contains(SemanticsProperties.INSTANCE.getInvisibleToUser()) == false) && visibleRect.height() > 0 && visibleRect.width() > 0;
        v3 = semantics;
        if (v3 != null ? v3.contains(SemanticsActions.INSTANCE.getSetText()) : false) ** GOTO lbl-1000
        v4 = semantics;
        v5 = v4 != null ? v4.contains(SemanticsProperties.INSTANCE.getEditableText()) : false;
        if (v5) lbl-1000:
        // 2 sources

        {
            v6 = true;
        } else {
            v6 = false;
        }
        isEditable = v6;
        v7 = semantics;
        v8 = v7 != null ? v7.contains(SemanticsProperties.INSTANCE.getText()) : false;
        if (v8 || isEditable) {
            shouldMask = isVisible != false && this.shouldMask(semantics, false, options) != false;
            v9 = parent;
            if (v9 != null) {
                v9.setImportantForCaptureToAncestors(true);
            }
            textLayoutResults = new ArrayList<E>();
            if (semantics != null && (var13_17 = (AccessibilityAction)SemanticsConfigurationKt.getOrNull((SemanticsConfiguration)semantics, (SemanticsPropertyKey)SemanticsActions.INSTANCE.getGetTextLayoutResult())) != null && (var14_19 = (Function1)var13_17.getAction()) != null) {
                (Boolean)var14_19.invoke((Object)textLayoutResults);
            }
            var13_17 = NodesKt.findTextAttributes(node);
            color = var13_17.component1-QN2ZGVo();
            hasFillModifier = var13_17.component2();
            textLayoutResult = (TextLayoutResult)CollectionsKt.firstOrNull((List)textLayoutResults);
            v10 = textLayoutResult;
            v11 = textColor = v10 != null && (v10 = v10.getLayoutInput()) != null && (v10 = v10.getStyle()) != null ? Color.box-impl((long)v10.getColor-0d7_KjU()) : null;
            if (v11 != null) {
                $this$isUnspecified$iv = v11.unbox-impl();
                $i$f$isUnspecified-8_81llA = false;
                v12 = $this$isUnspecified$iv == Color.Companion.getUnspecified-0d7_KjU();
            } else {
                v12 = false;
            }
            if (v12) {
                textColor = color;
            }
            var19_28 = (v13 = textLayoutResult) != null && (v13 = v13.getLayoutInput()) != null && (v13 = v13.getStyle()) != null ? TextUnit.box-impl((long)v13.getFontSize-XSAIIZE()) : null;
            var20_30 = TextUnit.Companion.getUnspecified-XSAIIZE();
            v14 = var19_28;
            isLaidOut = (v14 == null ? false : TextUnit.equals-impl0((long)v14.unbox-impl(), (long)var20_30)) == false;
            v15 = textColor;
            v16 = parent;
            v17 = new ViewHierarchyNode.TextViewHierarchyNode(textLayoutResult != null && isEditable == false && isLaidOut != false ? new ComposeTextLayout(textLayoutResult, hasFillModifier) : null, v15 != null ? Integer.valueOf(ViewsKt.toOpaque(ColorKt.toArgb-8_81llA((long)v15.unbox-impl()))) : null, 0, 0, visibleRect.left, visibleRect.top, node.getWidth(), node.getHeight(), v16 != null ? v16.getElevation() : 0.0f, distance, parent, shouldMask, true, isVisible, visibleRect, 12, null);
        } else {
            painter = NodesKt.findPainter(node);
            if (painter != null) {
                shouldMask = isVisible != false && this.shouldMask(semantics, true, options) != false;
                v18 = parent;
                if (v18 != null) {
                    v18.setImportantForCaptureToAncestors(true);
                }
                var13_18 = visibleRect.left;
                var14_20 = visibleRect.top;
                var15_22 = node.getWidth();
                var16_24 = node.getHeight();
                v19 = parent;
                var17_26 = v19 != null ? v19.getElevation() : 0.0f;
                var18_32 = shouldMask != false && NodesKt.isMaskable(painter) != false;
                v17 = new ViewHierarchyNode.ImageViewHierarchyNode(var13_18, var14_20, var15_22, var16_24, var17_26, distance, parent, var18_32, true, isVisible, visibleRect);
            } else {
                shouldMask = isVisible != false && this.shouldMask(semantics, false, options) != false;
                v20 = parent;
                v17 = new ViewHierarchyNode.GenericViewHierarchyNode(visibleRect.left, visibleRect.top, node.getWidth(), node.getHeight(), v20 != null ? v20.getElevation() : 0.0f, distance, parent, shouldMask, false, isVisible, visibleRect);
            }
        }
        return v17;
    }

    public final boolean fromView(@NotNull View view, @Nullable ViewHierarchyNode parent, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        String string = view.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"view::class.java.name");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"AndroidComposeView", (boolean)false, (int)2, null)) {
            return false;
        }
        if (parent == null) {
            return false;
        }
        try {
            Owner owner = view instanceof Owner ? (Owner)view : null;
            if (owner == null || (owner = owner.getRoot()) == null) {
                return false;
            }
            Owner rootNode = owner;
            this.traverse((LayoutNode)rootNode, parent, true, options);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, e, "Error traversing Compose tree. Most likely you're using an unsupported version of\nandroidx.compose.ui:ui. The minimum supported version is 1.5.0. If it's a newer\nversion, please open a github issue with the version you're using, so we can add\nsupport for it.", new Object[0]);
            return false;
        }
        return true;
    }

    private final void traverse(LayoutNode $this$traverse, ViewHierarchyNode parentNode, boolean isComposeRoot, SentryOptions options) {
        List children = $this$traverse.getChildren$ui_release();
        if (children.isEmpty()) {
            return;
        }
        ArrayList<ViewHierarchyNode> childNodes = new ArrayList<ViewHierarchyNode>(children.size());
        int n = children.size();
        for (int index = 0; index < n; ++index) {
            LayoutNode child = (LayoutNode)children.get(index);
            ViewHierarchyNode childNode = this.fromComposeNode(child, parentNode, index, isComposeRoot, options);
            if (childNode == null) continue;
            childNodes.add(childNode);
            this.traverse(child, childNode, false, options);
        }
        parentNode.setChildren((List<? extends ViewHierarchyNode>)childNodes);
    }
}

