/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.capture;

import android.graphics.Bitmap;
import io.sentry.IHub;
import io.sentry.IScope;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayEvent;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.util.ExecutorsKt;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.FileUtils;
import java.io.File;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 12\u00020\u0001:\u00011BN\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012%\b\u0002\u0010\n\u001a\u001f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0011J$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00130\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J$\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00130\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J@\u0010\"\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010$2,\u0010%\u001a(\u0012\u0004\u0012\u00020\u0010\u0012\u0013\u0012\u00110'\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00130&\u00a2\u0006\u0002\b)H\u0016J\b\u0010*\u001a\u00020\u0013H\u0016J*\u0010+\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u000f\u001a\u00020\f2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/sentry/android/replay/capture/SessionCaptureStrategy;", "Lio/sentry/android/replay/capture/BaseCaptureStrategy;", "options", "Lio/sentry/SentryOptions;", "hub", "Lio/sentry/IHub;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "replayCacheProvider", "Lkotlin/Function1;", "Lio/sentry/protocol/SentryId;", "Lkotlin/ParameterName;", "name", "replayId", "Lio/sentry/android/replay/ReplayCache;", "(Lio/sentry/SentryOptions;Lio/sentry/IHub;Lio/sentry/transport/ICurrentDateProvider;Ljava/util/concurrent/ScheduledExecutorService;Lkotlin/jvm/functions/Function1;)V", "captureReplay", "", "isTerminating", "", "onSegmentSent", "Ljava/util/Date;", "convert", "Lio/sentry/android/replay/capture/CaptureStrategy;", "createCurrentSegment", "taskName", "", "onSegmentCreated", "Lio/sentry/android/replay/capture/CaptureStrategy$ReplaySegment;", "onConfigurationChanged", "recorderConfig", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "onScreenshotRecorded", "bitmap", "Landroid/graphics/Bitmap;", "store", "Lkotlin/Function2;", "", "frameTimestamp", "Lkotlin/ExtensionFunctionType;", "pause", "start", "segmentId", "", "replayType", "Lio/sentry/SentryReplayEvent$ReplayType;", "stop", "Companion", "sentry-android-replay_release"})
public final class SessionCaptureStrategy
extends BaseCaptureStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SentryOptions options;
    @Nullable
    private final IHub hub;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @NotNull
    private static final String TAG = "SessionCaptureStrategy";

    public SessionCaptureStrategy(@NotNull SentryOptions options, @Nullable IHub hub, @NotNull ICurrentDateProvider dateProvider, @NotNull ScheduledExecutorService executor, @Nullable Function1<? super SentryId, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super(options, hub, dateProvider, executor, replayCacheProvider);
        this.options = options;
        this.hub = hub;
        this.dateProvider = dateProvider;
    }

    public /* synthetic */ SessionCaptureStrategy(SentryOptions sentryOptions, IHub iHub, ICurrentDateProvider iCurrentDateProvider, ScheduledExecutorService scheduledExecutorService, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        this(sentryOptions, iHub, iCurrentDateProvider, scheduledExecutorService, (Function1<? super SentryId, ReplayCache>)function1);
    }

    @Override
    public void start(@NotNull ScreenshotRecorderConfig recorderConfig, int segmentId, @NotNull SentryId replayId, @Nullable SentryReplayEvent.ReplayType replayType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
            Intrinsics.checkNotNullParameter((Object)replayId, (String)"replayId");
            super.start(recorderConfig, segmentId, replayId, replayType);
            IHub iHub = this.hub;
            if (iHub == null) break block0;
            iHub.configureScope(arg_0 -> SessionCaptureStrategy.start$lambda$0(this, arg_0));
        }
    }

    @Override
    public void pause() {
        this.createCurrentSegment("pause", (Function1<? super CaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<CaptureStrategy.ReplaySegment, Unit>(this){
            final /* synthetic */ SessionCaptureStrategy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
                    CaptureStrategy.ReplaySegment.Created.capture$default((CaptureStrategy.ReplaySegment.Created)segment, SessionCaptureStrategy.access$getHub$p(this.this$0), null, 2, null);
                    SessionCaptureStrategy sessionCaptureStrategy = this.this$0;
                    int n = sessionCaptureStrategy.getCurrentSegment();
                    sessionCaptureStrategy.setCurrentSegment(n + 1);
                }
            }
        }));
        super.pause();
    }

    @Override
    public void stop() {
        ReplayCache replayCache = this.getCache();
        File replayCacheDir2 = replayCache != null ? replayCache.getReplayCacheDir$sentry_android_replay_release() : null;
        this.createCurrentSegment("stop", (Function1<? super CaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<CaptureStrategy.ReplaySegment, Unit>(this, replayCacheDir2){
            final /* synthetic */ SessionCaptureStrategy this$0;
            final /* synthetic */ File $replayCacheDir;
            {
                this.this$0 = $receiver;
                this.$replayCacheDir = $replayCacheDir;
                super(1);
            }

            public final void invoke(@NotNull CaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
                    CaptureStrategy.ReplaySegment.Created.capture$default((CaptureStrategy.ReplaySegment.Created)segment, SessionCaptureStrategy.access$getHub$p(this.this$0), null, 2, null);
                }
                this.this$0.setCurrentSegment(-1);
                FileUtils.deleteRecursively((File)this.$replayCacheDir);
            }
        }));
        IHub iHub = this.hub;
        if (iHub != null) {
            iHub.configureScope(SessionCaptureStrategy::stop$lambda$1);
        }
        super.stop();
    }

    @Override
    public void captureReplay(boolean isTerminating, @NotNull Function1<? super Date, Unit> onSegmentSent) {
        Intrinsics.checkNotNullParameter(onSegmentSent, (String)"onSegmentSent");
        this.options.getLogger().log(SentryLevel.DEBUG, "Replay is already running in 'session' mode, not capturing for event", new Object[0]);
        this.isTerminating().set(isTerminating);
    }

    @Override
    public void onScreenshotRecorded(@Nullable Bitmap bitmap, @NotNull Function2<? super ReplayCache, ? super Long, Unit> store) {
        Intrinsics.checkNotNullParameter(store, (String)"store");
        long frameTimestamp = this.dateProvider.getCurrentTimeMillis();
        int height = this.getRecorderConfig().getRecordingHeight();
        int width = this.getRecorderConfig().getRecordingWidth();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "SessionCaptureStrategy.add_frame", () -> SessionCaptureStrategy.onScreenshotRecorded$lambda$3(this, store, frameTimestamp, height, width));
    }

    @Override
    public void onConfigurationChanged(@NotNull ScreenshotRecorderConfig recorderConfig) {
        Intrinsics.checkNotNullParameter((Object)recorderConfig, (String)"recorderConfig");
        this.createCurrentSegment("onConfigurationChanged", (Function1<? super CaptureStrategy.ReplaySegment, Unit>)((Function1)new Function1<CaptureStrategy.ReplaySegment, Unit>(this){
            final /* synthetic */ SessionCaptureStrategy this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CaptureStrategy.ReplaySegment segment) {
                Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
                if (segment instanceof CaptureStrategy.ReplaySegment.Created) {
                    CaptureStrategy.ReplaySegment.Created.capture$default((CaptureStrategy.ReplaySegment.Created)segment, SessionCaptureStrategy.access$getHub$p(this.this$0), null, 2, null);
                    SessionCaptureStrategy sessionCaptureStrategy = this.this$0;
                    int n = sessionCaptureStrategy.getCurrentSegment();
                    sessionCaptureStrategy.setCurrentSegment(n + 1);
                    this.this$0.setSegmentTimestamp(((CaptureStrategy.ReplaySegment.Created)segment).getReplay().getTimestamp());
                }
            }
        }));
        super.onConfigurationChanged(recorderConfig);
    }

    @Override
    @NotNull
    public CaptureStrategy convert() {
        return this;
    }

    private final void createCurrentSegment(String taskName, Function1<? super CaptureStrategy.ReplaySegment, Unit> onSegmentCreated) {
        long now = this.dateProvider.getCurrentTimeMillis();
        Date date = this.getSegmentTimestamp();
        if (date == null) {
            return;
        }
        Date currentSegmentTimestamp = date;
        long duration = now - currentSegmentTimestamp.getTime();
        SentryId replayId = this.getCurrentReplayId();
        int height = this.getRecorderConfig().getRecordingHeight();
        int width = this.getRecorderConfig().getRecordingWidth();
        ExecutorsKt.submitSafely(this.getReplayExecutor(), this.options, "SessionCaptureStrategy." + taskName, () -> SessionCaptureStrategy.createCurrentSegment$lambda$4(this, duration, currentSegmentTimestamp, replayId, height, width, onSegmentCreated));
    }

    private static final void start$lambda$0(SessionCaptureStrategy this$0, IScope it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId(this$0.getCurrentReplayId());
        String string = it.getScreen();
        this$0.setScreenAtStart(string != null ? StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null) : null);
    }

    private static final void stop$lambda$1(IScope it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setReplayId(SentryId.EMPTY_ID);
    }

    private static final void onScreenshotRecorded$lambda$3(SessionCaptureStrategy this$0, Function2 $store, long $frameTimestamp, int $height, int $width) {
        CaptureStrategy.ReplaySegment segment;
        Date currentSegmentTimestamp;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$store, (String)"$store");
        ReplayCache replayCache = this$0.getCache();
        if (replayCache != null) {
            $store.invoke((Object)replayCache, (Object)$frameTimestamp);
        }
        if ((currentSegmentTimestamp = this$0.getSegmentTimestamp()) == null) {
            SessionCaptureStrategy $this$onScreenshotRecorded_u24lambda_u243_u24lambda_u242 = this$0;
            boolean bl = false;
            $this$onScreenshotRecorded_u24lambda_u243_u24lambda_u242.options.getLogger().log(SentryLevel.DEBUG, "Segment timestamp is not set, not recording frame", new Object[0]);
            return;
        }
        if (this$0.isTerminating().get()) {
            this$0.options.getLogger().log(SentryLevel.DEBUG, "Not capturing segment, because the app is terminating, will be captured on next launch", new Object[0]);
            return;
        }
        long now = this$0.dateProvider.getCurrentTimeMillis();
        if (now - currentSegmentTimestamp.getTime() >= this$0.options.getSessionReplay().getSessionSegmentDuration() && (segment = BaseCaptureStrategy.createSegmentInternal$default(this$0, this$0.options.getSessionReplay().getSessionSegmentDuration(), currentSegmentTimestamp, this$0.getCurrentReplayId(), this$0.getCurrentSegment(), $height, $width, null, null, 0, 0, null, null, null, 8128, null)) instanceof CaptureStrategy.ReplaySegment.Created) {
            CaptureStrategy.ReplaySegment.Created.capture$default((CaptureStrategy.ReplaySegment.Created)segment, this$0.hub, null, 2, null);
            int n = this$0.getCurrentSegment();
            this$0.setCurrentSegment(n + 1);
            this$0.setSegmentTimestamp(((CaptureStrategy.ReplaySegment.Created)segment).getReplay().getTimestamp());
        }
        if (now - this$0.getReplayStartTimestamp().get() >= this$0.options.getSessionReplay().getSessionDuration()) {
            this$0.options.getReplayController().stop();
            this$0.options.getLogger().log(SentryLevel.INFO, "Session replay deadline exceeded (1h), stopping recording", new Object[0]);
        }
    }

    private static final void createCurrentSegment$lambda$4(SessionCaptureStrategy this$0, long $duration, Date $currentSegmentTimestamp, SentryId $replayId, int $height, int $width, Function1 $onSegmentCreated) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$currentSegmentTimestamp, (String)"$currentSegmentTimestamp");
        Intrinsics.checkNotNullParameter((Object)$replayId, (String)"$replayId");
        Intrinsics.checkNotNullParameter((Object)$onSegmentCreated, (String)"$onSegmentCreated");
        CaptureStrategy.ReplaySegment segment = BaseCaptureStrategy.createSegmentInternal$default(this$0, $duration, $currentSegmentTimestamp, $replayId, this$0.getCurrentSegment(), $height, $width, null, null, 0, 0, null, null, null, 8128, null);
        $onSegmentCreated.invoke((Object)segment);
    }

    public static final /* synthetic */ IHub access$getHub$p(SessionCaptureStrategy $this) {
        return $this.hub;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/sentry/android/replay/capture/SessionCaptureStrategy$Companion;", "", "()V", "TAG", "", "sentry-android-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

