/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.video;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import androidx.compose.runtime.internal.StabilityInferred;
import io.sentry.android.replay.video.SimpleFrameMuxer;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/sentry/android/replay/video/SimpleMp4FrameMuxer;", "Lio/sentry/android/replay/video/SimpleFrameMuxer;", "path", "", "fps", "", "(Ljava/lang/String;F)V", "finalVideoTime", "", "frameDurationUsec", "muxer", "Landroid/media/MediaMuxer;", "started", "", "videoFrames", "", "videoTrackIndex", "getVideoTime", "isStarted", "muxVideoFrame", "", "encodedData", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "release", "start", "videoFormat", "Landroid/media/MediaFormat;", "sentry-android-replay_release"})
@StabilityInferred(parameters=0)
public final class SimpleMp4FrameMuxer
implements SimpleFrameMuxer {
    private final long frameDurationUsec;
    @NotNull
    private final MediaMuxer muxer;
    private boolean started;
    private int videoTrackIndex;
    private int videoFrames;
    private long finalVideoTime;
    public static final int $stable = 8;

    public SimpleMp4FrameMuxer(@NotNull String path, float fps) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.frameDurationUsec = (long)((float)TimeUnit.SECONDS.toMicros(1L) / fps);
        this.muxer = new MediaMuxer(path, 0);
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start(@NotNull MediaFormat videoFormat) {
        Intrinsics.checkNotNullParameter((Object)videoFormat, (String)"videoFormat");
        this.videoTrackIndex = this.muxer.addTrack(videoFormat);
        this.muxer.start();
        this.started = true;
    }

    @Override
    public void muxVideoFrame(@NotNull ByteBuffer encodedData, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)encodedData, (String)"encodedData");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        int n = this.videoFrames;
        this.videoFrames = n + 1;
        bufferInfo.presentationTimeUs = this.finalVideoTime = this.frameDurationUsec * (long)n;
        this.muxer.writeSampleData(this.videoTrackIndex, encodedData, bufferInfo);
    }

    @Override
    public void release() {
        this.muxer.stop();
        this.muxer.release();
    }

    @Override
    public long getVideoTime() {
        if (this.videoFrames == 0) {
            return 0L;
        }
        return TimeUnit.MILLISECONDS.convert(this.finalVideoTime + this.frameDurationUsec, TimeUnit.MICROSECONDS);
    }
}

