/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.VectorDrawable;
import android.os.Build;
import android.text.Layout;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001H\u0000\u001a\u000e\u0010\f\u001a\u00020\r*\u0004\u0018\u00010\u000eH\u0001\u001a\u001a\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0010*\u00020\u0011H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0012"}, d2={"totalPaddingTopSafe", "", "Landroid/widget/TextView;", "getTotalPaddingTopSafe", "(Landroid/widget/TextView;)I", "getVisibleRects", "", "Landroid/graphics/Rect;", "Landroid/text/Layout;", "globalRect", "paddingLeft", "paddingTop", "isRedactable", "", "Landroid/graphics/drawable/Drawable;", "isVisibleToUser", "Lkotlin/Pair;", "Landroid/view/View;", "sentry-android-replay_release"})
public final class ViewsKt {
    @NotNull
    public static final Pair<Boolean, Rect> isVisibleToUser(@NotNull View $this$isVisibleToUser) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisibleToUser, (String)"<this>");
        if ($this$isVisibleToUser.isAttachedToWindow()) {
            if ($this$isVisibleToUser.getWindowVisibility() != 0) {
                return TuplesKt.to((Object)false, null);
            }
            View current = $this$isVisibleToUser;
            while (current instanceof View) {
                float transitionAlpha;
                View view = current;
                float f = transitionAlpha = Build.VERSION.SDK_INT >= 29 ? view.getTransitionAlpha() : 1.0f;
                if (view.getAlpha() <= 0.0f || transitionAlpha <= 0.0f || view.getVisibility() != 0) {
                    return TuplesKt.to((Object)false, null);
                }
                current = view.getParent();
            }
            Rect rect = new Rect();
            Point offset = new Point();
            boolean isVisible = $this$isVisibleToUser.getGlobalVisibleRect(rect, offset);
            return TuplesKt.to((Object)isVisible, (Object)rect);
        }
        return TuplesKt.to((Object)false, null);
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    @TargetApi(value=21)
    public static final boolean isRedactable(@Nullable Drawable $this$isRedactable) {
        boolean bl;
        Drawable drawable = $this$isRedactable;
        if (((drawable instanceof InsetDrawable ? true : drawable instanceof ColorDrawable) ? true : drawable instanceof VectorDrawable) ? true : drawable instanceof GradientDrawable) {
            bl = false;
        } else {
            if (drawable instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)$this$isRedactable).getBitmap();
                if (bitmap == null) {
                    return false;
                }
                Bitmap bmp = bitmap;
                return !bmp.isRecycled() && bmp.getHeight() > 10 && bmp.getWidth() > 10;
            }
            bl = true;
        }
        return bl;
    }

    @NotNull
    public static final List<Rect> getVisibleRects(@Nullable Layout $this$getVisibleRects, @NotNull Rect globalRect, int paddingLeft, int paddingTop) {
        Intrinsics.checkNotNullParameter((Object)globalRect, (String)"globalRect");
        if ($this$getVisibleRects == null) {
            return CollectionsKt.listOf((Object)globalRect);
        }
        List rects = new ArrayList();
        int n = $this$getVisibleRects.getLineCount();
        for (int i = 0; i < n; ++i) {
            int lineStart = (int)$this$getVisibleRects.getPrimaryHorizontal($this$getVisibleRects.getLineStart(i));
            int ellipsisCount = $this$getVisibleRects.getEllipsisCount(i);
            int lineEnd = (int)$this$getVisibleRects.getPrimaryHorizontal($this$getVisibleRects.getLineVisibleEnd(i) - ellipsisCount + (ellipsisCount > 0 ? 1 : 0));
            if (lineEnd == 0) {
                lineEnd = (int)$this$getVisibleRects.getPrimaryHorizontal($this$getVisibleRects.getLineVisibleEnd(i) - 1) + 1;
            }
            int lineTop = $this$getVisibleRects.getLineTop(i);
            int lineBottom = $this$getVisibleRects.getLineBottom(i);
            Rect rect = new Rect();
            rect.left = globalRect.left + paddingLeft + lineStart;
            rect.right = rect.left + (lineEnd - lineStart);
            rect.top = globalRect.top + paddingTop + lineTop;
            rect.bottom = rect.top + (lineBottom - lineTop);
            ((Collection)rects).add(rect);
        }
        return rects;
    }

    public static final int getTotalPaddingTopSafe(@NotNull TextView $this$totalPaddingTopSafe) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$totalPaddingTopSafe, (String)"<this>");
        try {
            n = $this$totalPaddingTopSafe.getTotalPaddingTop();
        }
        catch (NullPointerException e) {
            n = $this$totalPaddingTopSafe.getExtendedPaddingTop();
        }
        return n;
    }
}

