/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.replay;

import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import android.view.MotionEvent;
import io.sentry.Hint;
import io.sentry.IHub;
import io.sentry.IScopeObserver;
import io.sentry.Integration;
import io.sentry.NoOpReplayBreadcrumbConverter;
import io.sentry.ReplayBreadcrumbConverter;
import io.sentry.ReplayController;
import io.sentry.ScopeObserverAdapter;
import io.sentry.SentryEvent;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryReplayOptions;
import io.sentry.android.replay.Recorder;
import io.sentry.android.replay.ReplayCache;
import io.sentry.android.replay.ReplayIntegration;
import io.sentry.android.replay.ScreenshotRecorderCallback;
import io.sentry.android.replay.ScreenshotRecorderConfig;
import io.sentry.android.replay.TouchRecorderCallback;
import io.sentry.android.replay.WindowRecorder;
import io.sentry.android.replay.capture.BaseCaptureStrategy;
import io.sentry.android.replay.capture.BufferCaptureStrategy;
import io.sentry.android.replay.capture.CaptureStrategy;
import io.sentry.android.replay.capture.SessionCaptureStrategy;
import io.sentry.android.replay.util.MainLooperHandler;
import io.sentry.android.replay.util.SamplingKt;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.SentryId;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.IntegrationUtils;
import java.io.Closeable;
import java.io.File;
import java.security.SecureRandom;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u00b9\u0001\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012#\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010\u00128\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0017\u0012%\b\u0002\u0010\u001c\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010!B\u008a\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0012%\b\u0002\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010\u0012:\b\u0002\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\"J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u000205H\u0016J\b\u0010=\u001a\u00020\u0018H\u0016J\b\u0010*\u001a\u00020\u0011H\u0016J\u0010\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020;H\u0016J\u0010\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020DH\u0016J\u0018\u0010B\u001a\u00020;2\u0006\u0010E\u001a\u0002072\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020JH\u0016J\b\u0010K\u001a\u00020;H\u0016J\u0018\u0010L\u001a\u00020;2\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010M\u001a\u00020;H\u0016J+\u0010N\u001a\u00020;2\b\u0010O\u001a\u0004\u0018\u00010\u00112\b\u0010P\u001a\u0004\u0018\u00010Q2\b\u0010R\u001a\u0004\u0018\u00010SH\u0016\u00a2\u0006\u0002\u0010TJ\u0018\u0010U\u001a\u00020;2\u0006\u0010I\u001a\u00020V2\u0006\u0010R\u001a\u00020SH\u0016J\u0010\u0010W\u001a\u00020;2\u0006\u0010X\u001a\u000205H\u0016J\b\u0010Y\u001a\u00020;H\u0016J\b\u0010Z\u001a\u00020;H\u0016R\u0010\u0010#\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010-\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u00102\u001a\u0004\b/\u00100R\u0010\u00103\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R@\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u001c\u001a\u001f\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001d\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lio/sentry/android/replay/ReplayIntegration;", "Lio/sentry/Integration;", "Ljava/io/Closeable;", "Lio/sentry/android/replay/ScreenshotRecorderCallback;", "Lio/sentry/android/replay/TouchRecorderCallback;", "Lio/sentry/ReplayController;", "Landroid/content/ComponentCallbacks;", "context", "Landroid/content/Context;", "dateProvider", "Lio/sentry/transport/ICurrentDateProvider;", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;)V", "recorderProvider", "Lkotlin/Function0;", "Lio/sentry/android/replay/Recorder;", "recorderConfigProvider", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "configChanged", "Lio/sentry/android/replay/ScreenshotRecorderConfig;", "replayCacheProvider", "Lkotlin/Function2;", "Lio/sentry/protocol/SentryId;", "replayId", "recorderConfig", "Lio/sentry/android/replay/ReplayCache;", "replayCaptureStrategyProvider", "isFullSession", "Lio/sentry/android/replay/capture/CaptureStrategy;", "mainLooperHandler", "Lio/sentry/android/replay/util/MainLooperHandler;", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lio/sentry/android/replay/util/MainLooperHandler;)V", "(Landroid/content/Context;Lio/sentry/transport/ICurrentDateProvider;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "captureStrategy", "hub", "Lio/sentry/IHub;", "isEnabled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isEnabled$sentry_android_replay_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "isRecording", "options", "Lio/sentry/SentryOptions;", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "random$delegate", "Lkotlin/Lazy;", "recorder", "replayBreadcrumbConverter", "Lio/sentry/ReplayBreadcrumbConverter;", "replayCacheDir", "Ljava/io/File;", "getReplayCacheDir", "()Ljava/io/File;", "close", "", "getBreadcrumbConverter", "getReplayId", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onScreenshotRecorded", "bitmap", "Landroid/graphics/Bitmap;", "screenshot", "frameTimestamp", "", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "pause", "register", "resume", "sendReplay", "isCrashed", "eventId", "", "hint", "Lio/sentry/Hint;", "(Ljava/lang/Boolean;Ljava/lang/String;Lio/sentry/Hint;)V", "sendReplayForEvent", "Lio/sentry/SentryEvent;", "setBreadcrumbConverter", "converter", "start", "stop", "sentry-android-replay_release"})
public final class ReplayIntegration
implements Integration,
Closeable,
ScreenshotRecorderCallback,
TouchRecorderCallback,
ReplayController,
ComponentCallbacks {
    @NotNull
    private final Context context;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @Nullable
    private final Function0<Recorder> recorderProvider;
    @Nullable
    private final Function1<Boolean, ScreenshotRecorderConfig> recorderConfigProvider;
    @Nullable
    private final Function2<SentryId, ScreenshotRecorderConfig, ReplayCache> replayCacheProvider;
    private SentryOptions options;
    @Nullable
    private IHub hub;
    @Nullable
    private Recorder recorder;
    @NotNull
    private final Lazy random$delegate;
    @NotNull
    private final AtomicBoolean isEnabled;
    @NotNull
    private final AtomicBoolean isRecording;
    @Nullable
    private CaptureStrategy captureStrategy;
    @NotNull
    private ReplayBreadcrumbConverter replayBreadcrumbConverter;
    @Nullable
    private Function1<? super Boolean, ? extends CaptureStrategy> replayCaptureStrategyProvider;
    @NotNull
    private MainLooperHandler mainLooperHandler;
    private ScreenshotRecorderConfig recorderConfig;

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider, @Nullable Function0<? extends Recorder> recorderProvider, @Nullable Function1<? super Boolean, ScreenshotRecorderConfig> recorderConfigProvider, @Nullable Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache> replayCacheProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this.context = context;
        this.dateProvider = dateProvider;
        this.recorderProvider = recorderProvider;
        this.recorderConfigProvider = recorderConfigProvider;
        this.replayCacheProvider = replayCacheProvider;
        this.random$delegate = LazyKt.lazy((Function0)random.2.INSTANCE);
        this.isEnabled = new AtomicBoolean(false);
        this.isRecording = new AtomicBoolean(false);
        NoOpReplayBreadcrumbConverter noOpReplayBreadcrumbConverter = NoOpReplayBreadcrumbConverter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)noOpReplayBreadcrumbConverter, (String)"getInstance()");
        this.replayBreadcrumbConverter = (ReplayBreadcrumbConverter)noOpReplayBreadcrumbConverter;
        this.mainLooperHandler = new MainLooperHandler(null, 1, null);
    }

    public /* synthetic */ ReplayIntegration(Context context, ICurrentDateProvider iCurrentDateProvider, Function0 function0, Function1 function1, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = null;
        }
        if ((n & 8) != 0) {
            function1 = null;
        }
        if ((n & 0x10) != 0) {
            function2 = null;
        }
        this(context, iCurrentDateProvider, (Function0<? extends Recorder>)function0, (Function1<? super Boolean, ScreenshotRecorderConfig>)function1, (Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache>)function2);
    }

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this(context, dateProvider, null, null, null);
    }

    public ReplayIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider, @Nullable Function0<? extends Recorder> recorderProvider, @Nullable Function1<? super Boolean, ScreenshotRecorderConfig> recorderConfigProvider, @Nullable Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache> replayCacheProvider, @Nullable Function1<? super Boolean, ? extends CaptureStrategy> replayCaptureStrategyProvider, @Nullable MainLooperHandler mainLooperHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dateProvider, (String)"dateProvider");
        this(context, dateProvider, recorderProvider, recorderConfigProvider, replayCacheProvider);
        this.replayCaptureStrategyProvider = replayCaptureStrategyProvider;
        MainLooperHandler mainLooperHandler2 = mainLooperHandler;
        if (mainLooperHandler2 == null) {
            mainLooperHandler2 = new MainLooperHandler(null, 1, null);
        }
        this.mainLooperHandler = mainLooperHandler2;
    }

    public /* synthetic */ ReplayIntegration(Context context, ICurrentDateProvider iCurrentDateProvider, Function0 function0, Function1 function1, Function2 function2, Function1 function12, MainLooperHandler mainLooperHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            function12 = null;
        }
        if ((n & 0x40) != 0) {
            mainLooperHandler = null;
        }
        this(context, iCurrentDateProvider, (Function0<? extends Recorder>)function0, (Function1<? super Boolean, ScreenshotRecorderConfig>)function1, (Function2<? super SentryId, ? super ScreenshotRecorderConfig, ReplayCache>)function2, (Function1<? super Boolean, ? extends CaptureStrategy>)function12, mainLooperHandler);
    }

    private final SecureRandom getRandom() {
        Lazy lazy = this.random$delegate;
        return (SecureRandom)lazy.getValue();
    }

    @NotNull
    public final AtomicBoolean isEnabled$sentry_android_replay_release() {
        return this.isEnabled;
    }

    @Nullable
    public final File getReplayCacheDir() {
        CaptureStrategy captureStrategy = this.captureStrategy;
        return captureStrategy != null ? captureStrategy.getReplayCacheDir() : null;
    }

    public void register(@NotNull IHub hub, @NotNull SentryOptions options) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        if (Build.VERSION.SDK_INT < 26) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is only supported on API 26 and above", new Object[0]);
            return;
        }
        if (!options.getExperimental().getSessionReplay().isSessionReplayEnabled() && !options.getExperimental().getSessionReplay().isSessionReplayForErrorsEnabled()) {
            options.getLogger().log(SentryLevel.INFO, "Session replay is disabled, no sample rate specified", new Object[0]);
            return;
        }
        this.hub = hub;
        SentryOptions sentryOptions = this.options;
        if (sentryOptions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"options");
            sentryOptions = null;
        }
        sentryOptions.addScopeObserver((IScopeObserver)new ScopeObserverAdapter(this){
            final /* synthetic */ ReplayIntegration this$0;
            {
                this.this$0 = $receiver;
            }

            public void setContexts(@NotNull Contexts contexts) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)contexts, (String)"contexts");
                    CaptureStrategy captureStrategy = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                    if (captureStrategy == null) break block0;
                    Object object = contexts.getApp();
                    captureStrategy.onScreenChanged(object != null && (object = object.getViewNames()) != null && (object = (String)CollectionsKt.lastOrNull((List)object)) != null ? StringsKt.substringAfterLast$default((String)object, (char)'.', null, (int)2, null) : null);
                }
            }
        });
        Object object = this.recorderProvider;
        if (object == null || (object = (Recorder)object.invoke()) == null) {
            object = new WindowRecorder(options, this, this, this.mainLooperHandler);
        }
        this.recorder = object;
        this.isEnabled.set(true);
        try {
            this.context.registerComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.INFO, "ComponentCallbacks is not available, orientation changes won't be handled by Session replay", e);
        }
        IntegrationUtils.addIntegrationToSdkVersion(this.getClass());
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-replay", "7.12.1");
    }

    public boolean isRecording() {
        return this.isRecording.get();
    }

    public void start() {
        block19: {
            Object object;
            Object object2;
            boolean isFullSession;
            if (!this.isEnabled.get()) {
                return;
            }
            if (this.isRecording.getAndSet(true)) {
                SentryOptions sentryOptions = this.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                sentryOptions.getLogger().log(SentryLevel.DEBUG, "Session replay is already being recorded, not starting a new one", new Object[0]);
                return;
            }
            SecureRandom secureRandom = this.getRandom();
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            if (!(isFullSession = SamplingKt.sample(secureRandom, sentryOptions.getExperimental().getSessionReplay().getSessionSampleRate()))) {
                SentryOptions sentryOptions2 = this.options;
                if (sentryOptions2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions2 = null;
                }
                if (!sentryOptions2.getExperimental().getSessionReplay().isSessionReplayForErrorsEnabled()) {
                    SentryOptions sentryOptions3 = this.options;
                    if (sentryOptions3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions3 = null;
                    }
                    sentryOptions3.getLogger().log(SentryLevel.INFO, "Session replay is not started, full session was not sampled and errorSampleRate is not specified", new Object[0]);
                    return;
                }
            }
            if ((object2 = this.recorderConfigProvider) == null || (object2 = (ScreenshotRecorderConfig)object2.invoke((Object)false)) == null) {
                SentryOptions sentryOptions4 = this.options;
                if (sentryOptions4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions4 = null;
                }
                SentryReplayOptions sentryReplayOptions = sentryOptions4.getExperimental().getSessionReplay();
                Intrinsics.checkNotNullExpressionValue((Object)sentryReplayOptions, (String)"options.experimental.sessionReplay");
                object2 = this.recorderConfig = ScreenshotRecorderConfig.Companion.from(this.context, sentryReplayOptions);
            }
            if ((object = this.replayCaptureStrategyProvider) == null || (object = (CaptureStrategy)object.invoke((Object)isFullSession)) == null) {
                BaseCaptureStrategy baseCaptureStrategy;
                if (isFullSession) {
                    ScreenshotRecorderConfig screenshotRecorderConfig;
                    SentryOptions sentryOptions5 = this.options;
                    if (sentryOptions5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions5 = null;
                    }
                    if ((screenshotRecorderConfig = this.recorderConfig) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                        screenshotRecorderConfig = null;
                    }
                    baseCaptureStrategy = new SessionCaptureStrategy(sentryOptions5, this.hub, this.dateProvider, screenshotRecorderConfig, null, this.replayCacheProvider, 16, null);
                } else {
                    ScreenshotRecorderConfig screenshotRecorderConfig;
                    SentryOptions sentryOptions6 = this.options;
                    if (sentryOptions6 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                        sentryOptions6 = null;
                    }
                    if ((screenshotRecorderConfig = this.recorderConfig) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                        screenshotRecorderConfig = null;
                    }
                    baseCaptureStrategy = new BufferCaptureStrategy(sentryOptions6, this.hub, this.dateProvider, screenshotRecorderConfig, this.getRandom(), this.replayCacheProvider);
                }
                object = baseCaptureStrategy;
            }
            this.captureStrategy = object;
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                CaptureStrategy.DefaultImpls.start$default(captureStrategy, 0, null, false, 7, null);
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 == null) break block19;
            ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
            if (screenshotRecorderConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig = null;
            }
            recorder2.start(screenshotRecorderConfig);
        }
    }

    public void resume() {
        block2: {
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                captureStrategy.resume();
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 == null) break block2;
            recorder2.resume();
        }
    }

    public void sendReplayForEvent(@NotNull SentryEvent event, @NotNull Hint hint) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        if (!event.isErrored() && !event.isCrashed()) {
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            Object[] objectArray = new Object[]{event.getEventId()};
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Event is not error or crash, not capturing for event %s", objectArray);
            return;
        }
        this.sendReplay(event.isCrashed(), String.valueOf(event.getEventId()), hint);
    }

    public void sendReplay(@Nullable Boolean isCrashed, @Nullable String eventId, @Nullable Hint hint) {
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        Object object = this.captureStrategy;
        if (SentryId.EMPTY_ID.equals(object != null && (object = object.getCurrentReplayId()) != null ? (SentryId)((AtomicReference)object).get() : null)) {
            SentryOptions sentryOptions = this.options;
            if (sentryOptions == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                sentryOptions = null;
            }
            Object[] objectArray = new Object[]{eventId};
            sentryOptions.getLogger().log(SentryLevel.DEBUG, "Replay id is not set, not capturing for event %s", objectArray);
            return;
        }
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (captureStrategy != null) {
            captureStrategy.sendReplayForEvent(Intrinsics.areEqual((Object)isCrashed, (Object)true), eventId, hint, (Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ReplayIntegration this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    block0: {
                        Object object = ReplayIntegration.access$getCaptureStrategy$p(this.this$0);
                        if (object == null || (object = object.getCurrentSegment()) == null) break block0;
                        ((AtomicInteger)object).getAndIncrement();
                    }
                }
            }));
        }
        CaptureStrategy captureStrategy2 = this.captureStrategy;
        this.captureStrategy = captureStrategy2 != null ? captureStrategy2.convert() : null;
    }

    @NotNull
    public SentryId getReplayId() {
        SentryId sentryId;
        Object object = this.captureStrategy;
        if ((object != null && (object = object.getCurrentReplayId()) != null ? (SentryId)((AtomicReference)object).get() : (sentryId = null)) == null) {
            SentryId sentryId2 = SentryId.EMPTY_ID;
            sentryId = sentryId2;
            Intrinsics.checkNotNullExpressionValue((Object)sentryId2, (String)"EMPTY_ID");
        }
        return sentryId;
    }

    public void setBreadcrumbConverter(@NotNull ReplayBreadcrumbConverter converter) {
        Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
        this.replayBreadcrumbConverter = converter;
    }

    @NotNull
    public ReplayBreadcrumbConverter getBreadcrumbConverter() {
        return this.replayBreadcrumbConverter;
    }

    public void pause() {
        block2: {
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 != null) {
                recorder2.pause();
            }
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block2;
            captureStrategy.pause();
        }
    }

    public void stop() {
        if (!this.isEnabled.get() || !this.isRecording.get()) {
            return;
        }
        Recorder recorder2 = this.recorder;
        if (recorder2 != null) {
            recorder2.stop();
        }
        CaptureStrategy captureStrategy = this.captureStrategy;
        if (captureStrategy != null) {
            captureStrategy.stop();
        }
        this.isRecording.set(false);
        CaptureStrategy captureStrategy2 = this.captureStrategy;
        if (captureStrategy2 != null) {
            captureStrategy2.close();
        }
        this.captureStrategy = null;
    }

    @Override
    public void onScreenshotRecorded(@NotNull Bitmap bitmap) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block0;
            captureStrategy.onScreenshotRecorded(bitmap, (Function2<? super ReplayCache, ? super Long, Unit>)((Function2)new Function2<ReplayCache, Long, Unit>(bitmap){
                final /* synthetic */ Bitmap $bitmap;
                {
                    this.$bitmap = $bitmap;
                    super(2);
                }

                public final void invoke(@NotNull ReplayCache $this$onScreenshotRecorded, long frameTimeStamp) {
                    Intrinsics.checkNotNullParameter((Object)$this$onScreenshotRecorded, (String)"$this$onScreenshotRecorded");
                    $this$onScreenshotRecorded.addFrame$sentry_android_replay_release(this.$bitmap, frameTimeStamp);
                }
            }));
        }
    }

    @Override
    public void onScreenshotRecorded(@NotNull File screenshot, long frameTimestamp) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)screenshot, (String)"screenshot");
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block0;
            CaptureStrategy.DefaultImpls.onScreenshotRecorded$default(captureStrategy, null, (Function2)new Function2<ReplayCache, Long, Unit>(screenshot, frameTimestamp){
                final /* synthetic */ File $screenshot;
                final /* synthetic */ long $frameTimestamp;
                {
                    this.$screenshot = $screenshot;
                    this.$frameTimestamp = $frameTimestamp;
                    super(2);
                }

                public final void invoke(@NotNull ReplayCache $this$onScreenshotRecorded, long l) {
                    Intrinsics.checkNotNullParameter((Object)$this$onScreenshotRecorded, (String)"$this$onScreenshotRecorded");
                    $this$onScreenshotRecorded.addFrame(this.$screenshot, this.$frameTimestamp);
                }
            }, 1, null);
        }
    }

    @Override
    public void close() {
        if (!this.isEnabled.get()) {
            return;
        }
        try {
            this.context.unregisterComponentCallbacks((ComponentCallbacks)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stop();
        Recorder recorder2 = this.recorder;
        if (recorder2 != null) {
            recorder2.close();
        }
        this.recorder = null;
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
            if (!this.isEnabled.get() || !this.isRecording.get()) {
                return;
            }
            Recorder recorder2 = this.recorder;
            if (recorder2 != null) {
                recorder2.stop();
            }
            if ((object = this.recorderConfigProvider) == null || (object = (ScreenshotRecorderConfig)object.invoke((Object)true)) == null) {
                SentryOptions sentryOptions = this.options;
                if (sentryOptions == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"options");
                    sentryOptions = null;
                }
                SentryReplayOptions sentryReplayOptions = sentryOptions.getExperimental().getSessionReplay();
                Intrinsics.checkNotNullExpressionValue((Object)sentryReplayOptions, (String)"options.experimental.sessionReplay");
                object = ScreenshotRecorderConfig.Companion.from(this.context, sentryReplayOptions);
            }
            this.recorderConfig = object;
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy != null) {
                ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
                if (screenshotRecorderConfig == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                    screenshotRecorderConfig = null;
                }
                captureStrategy.onConfigurationChanged(screenshotRecorderConfig);
            }
            Recorder recorder3 = this.recorder;
            if (recorder3 == null) break block7;
            ScreenshotRecorderConfig screenshotRecorderConfig = this.recorderConfig;
            if (screenshotRecorderConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"recorderConfig");
                screenshotRecorderConfig = null;
            }
            recorder3.start(screenshotRecorderConfig);
        }
    }

    public void onLowMemory() {
    }

    @Override
    public void onTouchEvent(@NotNull MotionEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            CaptureStrategy captureStrategy = this.captureStrategy;
            if (captureStrategy == null) break block0;
            captureStrategy.onTouchEvent(event);
        }
    }

    public static final /* synthetic */ CaptureStrategy access$getCaptureStrategy$p(ReplayIntegration $this) {
        return $this.captureStrategy;
    }
}

