/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.okhttp;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.HttpStatusCodeRange;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.IntegrationName;
import io.sentry.SentryEvent;
import io.sentry.SentryIntegrationPackageStorage;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanStatus;
import io.sentry.android.okhttp.SentryOkHttpEvent;
import io.sentry.android.okhttp.SentryOkHttpEventListener;
import io.sentry.exception.ExceptionMechanismException;
import io.sentry.exception.SentryHttpClientException;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.Request;
import io.sentry.util.HttpUtils;
import io.sentry.util.PropagationTargetsUtils;
import io.sentry.util.UrlUtils;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u0001.B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tBE\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J,\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u001e\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J)\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010'\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010(J'\u0010)\u001a\u00020\u0013*\u0004\u0018\u00010*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00130,H\u0002\u00a2\u0006\u0002\u0010-R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/sentry/android/okhttp/SentryOkHttpInterceptor;", "Lokhttp3/Interceptor;", "Lio/sentry/IntegrationName;", "()V", "hub", "Lio/sentry/IHub;", "(Lio/sentry/IHub;)V", "beforeSpan", "Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "(Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;)V", "captureFailedRequests", "", "failedRequestStatusCodes", "", "Lio/sentry/HttpStatusCodeRange;", "failedRequestTargets", "", "(Lio/sentry/IHub;Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;ZLjava/util/List;Ljava/util/List;)V", "captureEvent", "", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "containsStatusCode", "statusCode", "", "finishSpan", "span", "Lio/sentry/ISpan;", "isFromEventListener", "getHeaders", "", "requestHeaders", "Lokhttp3/Headers;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "sendBreadcrumb", "code", "(Lokhttp3/Request;Ljava/lang/Integer;Lokhttp3/Response;)V", "ifHasValidLength", "", "fn", "Lkotlin/Function1;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "BeforeSpanCallback", "sentry-android-okhttp_release"})
@SourceDebugExtension(value={"SMAP\nSentryOkHttpInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SentryOkHttpInterceptor.kt\nio/sentry/android/okhttp/SentryOkHttpInterceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,280:1\n1#2:281\n*E\n"})
public final class SentryOkHttpInterceptor
implements Interceptor,
IntegrationName {
    @NotNull
    private final IHub hub;
    @Nullable
    private final BeforeSpanCallback beforeSpan;
    private final boolean captureFailedRequests;
    @NotNull
    private final List<HttpStatusCodeRange> failedRequestStatusCodes;
    @NotNull
    private final List<String> failedRequestTargets;

    public SentryOkHttpInterceptor(@NotNull IHub hub, @Nullable BeforeSpanCallback beforeSpan, boolean captureFailedRequests, @NotNull List<HttpStatusCodeRange> failedRequestStatusCodes, @NotNull List<String> failedRequestTargets) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        Intrinsics.checkNotNullParameter(failedRequestStatusCodes, (String)"failedRequestStatusCodes");
        Intrinsics.checkNotNullParameter(failedRequestTargets, (String)"failedRequestTargets");
        this.hub = hub;
        this.beforeSpan = beforeSpan;
        this.captureFailedRequests = captureFailedRequests;
        this.failedRequestStatusCodes = failedRequestStatusCodes;
        this.failedRequestTargets = failedRequestTargets;
        this.addIntegrationToSdkVersion();
        SentryIntegrationPackageStorage.getInstance().addPackage("maven:io.sentry:sentry-android-okhttp", "6.22.0");
    }

    public /* synthetic */ SentryOkHttpInterceptor(IHub iHub, BeforeSpanCallback beforeSpanCallback, boolean bl, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            beforeSpanCallback = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.listOf((Object)new HttpStatusCodeRange(500, 599));
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.listOf((Object)".*");
        }
        this(iHub, beforeSpanCallback, bl, list, list2);
    }

    public SentryOkHttpInterceptor() {
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
        this((IHub)hubAdapter);
    }

    public SentryOkHttpInterceptor(@NotNull IHub hub) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, null, false, null, null, 28, null);
    }

    public SentryOkHttpInterceptor(@NotNull BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)beforeSpan, (String)"beforeSpan");
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"getInstance()");
        this((IHub)hubAdapter, beforeSpan, false, null, null, 28, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        okhttp3.Request request = chain.request();
        UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.url().toString());
        Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(request.url.toString())");
        UrlUtils.UrlDetails urlDetails2 = urlDetails;
        String string = urlDetails2.getUrlOrFallback();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlDetails.urlOrFallback");
        String url = string;
        String method = request.method();
        ISpan span = null;
        boolean isFromEventListener = false;
        if (SentryOkHttpEventListener.Companion.getEventMap$sentry_android_okhttp_release().containsKey(chain.call())) {
            SentryOkHttpEvent sentryOkHttpEvent = SentryOkHttpEventListener.Companion.getEventMap$sentry_android_okhttp_release().get(chain.call());
            span = sentryOkHttpEvent != null ? sentryOkHttpEvent.getCallRootSpan$sentry_android_okhttp_release() : null;
            isFromEventListener = true;
        } else {
            ISpan iSpan = this.hub.getSpan();
            span = iSpan != null ? iSpan.startChild("http.client", method + ' ' + url) : null;
            isFromEventListener = false;
        }
        urlDetails2.applyToSpan(span);
        Response response = null;
        Integer code = null;
        try {
            Request.Builder requestBuilder = request.newBuilder();
            if (span != null && !span.isNoOp() && PropagationTargetsUtils.contain((List)this.hub.getOptions().getTracePropagationTargets(), (String)request.url().toString())) {
                SentryTraceHeader it = span.toSentryTrace();
                boolean bl = false;
                String string2 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                String string3 = it.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.value");
                requestBuilder.addHeader(string2, string3);
                BaggageHeader baggageHeader = span.toBaggageHeader(request.headers("baggage"));
                if (baggageHeader != null) {
                    BaggageHeader it2 = baggageHeader;
                    boolean bl2 = false;
                    requestBuilder.removeHeader("baggage");
                    String string4 = it2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.name");
                    String string5 = it2.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"it.value");
                    requestBuilder.addHeader(string4, string5);
                }
            }
            request = requestBuilder.build();
            response = chain.proceed(request);
            code = response.code();
            ISpan iSpan = span;
            if (iSpan != null) {
                iSpan.setStatus(SpanStatus.fromHttpStatusCode((int)code));
            }
            this.captureEvent(request, response);
            Response response2 = response;
            this.finishSpan(span, request, response, isFromEventListener);
            if (!isFromEventListener) {
                this.sendBreadcrumb(request, code, response);
            }
            return response2;
        }
        catch (IOException e) {
            try {
                ISpan iSpan = span;
                if (iSpan != null) {
                    ISpan iSpan2;
                    ISpan $this$intercept_u24lambda_u242 = iSpan2 = iSpan;
                    boolean bl = false;
                    $this$intercept_u24lambda_u242.setThrowable((Throwable)e);
                    $this$intercept_u24lambda_u242.setStatus(SpanStatus.INTERNAL_ERROR);
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.finishSpan(span, request, response, isFromEventListener);
                if (!isFromEventListener) {
                    this.sendBreadcrumb(request, code, response);
                }
                throw throwable;
            }
        }
    }

    private final void sendBreadcrumb(okhttp3.Request request, Integer code, Response response) {
        Hint hint;
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.url().toString(), (String)request.method(), (Integer)code);
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"http(request.url.toString(), request.method, code)");
        Breadcrumb breadcrumb2 = breadcrumb;
        RequestBody requestBody = request.body();
        this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
            final /* synthetic */ Breadcrumb $breadcrumb;
            {
                this.$breadcrumb = $breadcrumb;
                super(1);
            }

            public final void invoke(long it) {
                this.$breadcrumb.setData("http.request_content_length", (Object)it);
            }
        }));
        Hint it = hint = new Hint();
        boolean bl = false;
        it.set("okHttp:request", (Object)request);
        Hint hint2 = hint;
        Response response2 = response;
        if (response2 != null) {
            it = response2;
            boolean bl2 = false;
            ResponseBody responseBody = it.body();
            this.ifHasValidLength(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                final /* synthetic */ Breadcrumb $breadcrumb;
                {
                    this.$breadcrumb = $breadcrumb;
                    super(1);
                }

                public final void invoke(long responseBodySize) {
                    this.$breadcrumb.setData("http.response_content_length", (Object)responseBodySize);
                }
            }));
            hint2.set("okHttp:response", (Object)it);
        }
        this.hub.addBreadcrumb(breadcrumb2, hint2);
    }

    private final void finishSpan(ISpan span, okhttp3.Request request, Response response, boolean isFromEventListener) {
        if (span == null) {
            return;
        }
        if (this.beforeSpan != null) {
            ISpan result = this.beforeSpan.execute(span, request, response);
            if (result == null) {
                span.getSpanContext().setSampled(Boolean.valueOf(false));
            } else if (!isFromEventListener) {
                span.finish();
            }
        } else if (!isFromEventListener) {
            span.finish();
        }
    }

    private final void ifHasValidLength(Long $this$ifHasValidLength, Function1<? super Long, Unit> fn) {
        if ($this$ifHasValidLength != null) {
            long l = -1L;
            if ($this$ifHasValidLength != l) {
                fn.invoke((Object)$this$ifHasValidLength);
            }
        }
    }

    private final void captureEvent(okhttp3.Request request, Response response) {
        io.sentry.protocol.Response response2;
        Request request2;
        Mechanism mechanism;
        if (!this.captureFailedRequests || !this.containsStatusCode(response.code())) {
            return;
        }
        UrlUtils.UrlDetails urlDetails = UrlUtils.parse((String)request.url().toString());
        Intrinsics.checkNotNullExpressionValue((Object)urlDetails, (String)"parse(request.url.toString())");
        UrlUtils.UrlDetails urlDetails2 = urlDetails;
        if (!PropagationTargetsUtils.contain(this.failedRequestTargets, (String)request.url().toString())) {
            return;
        }
        Mechanism $this$captureEvent_u24lambda_u245 = mechanism = new Mechanism();
        boolean bl = false;
        $this$captureEvent_u24lambda_u245.setType("SentryOkHttpInterceptor");
        Mechanism mechanism2 = mechanism;
        SentryHttpClientException exception = new SentryHttpClientException("HTTP Client Error with status code: " + response.code());
        ExceptionMechanismException mechanismException = new ExceptionMechanismException(mechanism2, (Throwable)exception, Thread.currentThread(), true);
        SentryEvent event = new SentryEvent((Throwable)mechanismException);
        Hint hint = new Hint();
        hint.set("okHttp:request", (Object)request);
        hint.set("okHttp:response", (Object)response);
        Request $this$captureEvent_u24lambda_u246 = request2 = new Request();
        boolean bl2 = false;
        urlDetails2.applyToRequest($this$captureEvent_u24lambda_u246);
        $this$captureEvent_u24lambda_u246.setCookies(this.hub.getOptions().isSendDefaultPii() ? request.headers().get("Cookie") : null);
        $this$captureEvent_u24lambda_u246.setMethod(request.method());
        $this$captureEvent_u24lambda_u246.setHeaders(this.getHeaders(request.headers()));
        RequestBody requestBody = request.body();
        this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>($this$captureEvent_u24lambda_u246){
            final /* synthetic */ Request $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(long it) {
                this.$this_apply.setBodySize(Long.valueOf(it));
            }
        }));
        Request sentryRequest2 = request2;
        io.sentry.protocol.Response $this$captureEvent_u24lambda_u247 = response2 = new io.sentry.protocol.Response();
        boolean bl3 = false;
        $this$captureEvent_u24lambda_u247.setCookies(this.hub.getOptions().isSendDefaultPii() ? response.headers().get("Set-Cookie") : null);
        $this$captureEvent_u24lambda_u247.setHeaders(this.getHeaders(response.headers()));
        $this$captureEvent_u24lambda_u247.setStatusCode(Integer.valueOf(response.code()));
        ResponseBody responseBody = response.body();
        this.ifHasValidLength(responseBody != null ? Long.valueOf(responseBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>($this$captureEvent_u24lambda_u247){
            final /* synthetic */ io.sentry.protocol.Response $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(long it) {
                this.$this_apply.setBodySize(Long.valueOf(it));
            }
        }));
        io.sentry.protocol.Response sentryResponse2 = response2;
        event.setRequest(sentryRequest2);
        event.getContexts().setResponse(sentryResponse2);
        this.hub.captureEvent(event, hint);
    }

    private final boolean containsStatusCode(int statusCode) {
        for (HttpStatusCodeRange item : this.failedRequestStatusCodes) {
            if (!item.isInRange(statusCode)) continue;
            return true;
        }
        return false;
    }

    private final Map<String, String> getHeaders(Headers requestHeaders) {
        if (!this.hub.getOptions().isSendDefaultPii()) {
            return null;
        }
        Map headers = new LinkedHashMap();
        int n = requestHeaders.size();
        for (int i = 0; i < n; ++i) {
            String name = requestHeaders.name(i);
            if (HttpUtils.containsSensitiveHeader((String)name)) continue;
            String value = requestHeaders.value(i);
            headers.put(name, value);
        }
        return headers;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "", "execute", "Lio/sentry/ISpan;", "span", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "sentry-android-okhttp_release"})
    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull okhttp3.Request var2, @Nullable Response var3);
    }
}

