/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.okhttp;

import io.sentry.Breadcrumb;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ISpan;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SpanContext;
import io.sentry.SpanStatus;
import io.sentry.TraceStateHeader;
import io.sentry.TracingOrigins;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J'\u0010\u0014\u001a\u00020\n*\u0004\u0018\u00010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/sentry/android/okhttp/SentryOkHttpInterceptor;", "Lokhttp3/Interceptor;", "hub", "Lio/sentry/IHub;", "(Lio/sentry/IHub;)V", "beforeSpan", "Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "(Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;)V", "(Lio/sentry/IHub;Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;)V", "finishSpan", "", "span", "Lio/sentry/ISpan;", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "ifHasValidLength", "", "fn", "Lkotlin/Function1;", "(Ljava/lang/Long;Lkotlin/jvm/functions/Function1;)V", "BeforeSpanCallback", "sentry-android-okhttp_release"})
public final class SentryOkHttpInterceptor
implements Interceptor {
    private final IHub hub;
    private final BeforeSpanCallback beforeSpan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        SentryTraceHeader sentryTraceHeader;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Request request = chain.request();
        String url = request.url().toString();
        String method = request.method();
        ISpan iSpan = this.hub.getSpan();
        ISpan span = iSpan != null ? iSpan.startChild("http.client", method + ' ' + url) : null;
        Response response = null;
        Integer code = null;
        try {
            Request.Builder requestBuilder = request.newBuilder();
            if (span != null) {
                SentryOptions sentryOptions = this.hub.getOptions();
                Intrinsics.checkNotNullExpressionValue((Object)sentryOptions, (String)"hub.options");
                if (TracingOrigins.contain((List)sentryOptions.getTracingOrigins(), (String)request.url().toString())) {
                    sentryTraceHeader = span.toSentryTrace();
                    boolean bl = false;
                    boolean bl2 = false;
                    SentryTraceHeader it = sentryTraceHeader;
                    boolean bl3 = false;
                    SentryTraceHeader sentryTraceHeader2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)sentryTraceHeader2, (String)"it");
                    String string = sentryTraceHeader2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    String string2 = it.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.value");
                    requestBuilder.addHeader(string, string2);
                    TraceStateHeader traceStateHeader = span.toTraceStateHeader();
                    if (traceStateHeader != null) {
                        sentryTraceHeader = traceStateHeader;
                        bl = false;
                        bl2 = false;
                        it = sentryTraceHeader;
                        boolean bl4 = false;
                        SentryTraceHeader sentryTraceHeader3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)sentryTraceHeader3, (String)"it");
                        String string3 = sentryTraceHeader3.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                        String string4 = it.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.value");
                        requestBuilder.addHeader(string3, string4);
                    }
                }
            }
            request = requestBuilder.build();
            response = chain.proceed(request);
            code = response.code();
            ISpan iSpan2 = span;
            if (iSpan2 != null) {
                iSpan2.setStatus(SpanStatus.fromHttpStatusCode((int)code));
            }
            sentryTraceHeader = response;
            this.finishSpan(span, request, response);
        }
        catch (IOException e) {
            try {
                ISpan iSpan3 = span;
                if (iSpan3 != null) {
                    ISpan iSpan4 = iSpan3;
                    boolean bl = false;
                    boolean bl5 = false;
                    ISpan $this$apply = iSpan4;
                    boolean bl6 = false;
                    $this$apply.setThrowable((Throwable)e);
                    $this$apply.setStatus(SpanStatus.INTERNAL_ERROR);
                }
                throw (Throwable)e;
            }
            catch (Throwable throwable) {
                this.finishSpan(span, request, response);
                Breadcrumb breadcrumb = Breadcrumb.http((String)request.url().toString(), (String)request.method(), (Integer)code);
                Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"Breadcrumb.http(request.\u2026(), request.method, code)");
                Breadcrumb breadcrumb2 = breadcrumb;
                RequestBody requestBody = request.body();
                this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                    final /* synthetic */ Breadcrumb $breadcrumb;

                    public final void invoke(long it) {
                        this.$breadcrumb.setData("request_body_size", (Object)it);
                    }
                    {
                        this.$breadcrumb = breadcrumb;
                        super(1);
                    }
                }));
                Response response2 = response;
                this.ifHasValidLength(response2 != null && (response2 = response2.body()) != null ? Long.valueOf(response2.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(breadcrumb2){
                    final /* synthetic */ Breadcrumb $breadcrumb;

                    public final void invoke(long it) {
                        this.$breadcrumb.setData("response_body_size", (Object)it);
                    }
                    {
                        this.$breadcrumb = breadcrumb;
                        super(1);
                    }
                }));
                this.hub.addBreadcrumb(breadcrumb2);
                throw throwable;
            }
        }
        Breadcrumb breadcrumb = Breadcrumb.http((String)request.url().toString(), (String)request.method(), (Integer)code);
        Intrinsics.checkNotNullExpressionValue((Object)breadcrumb, (String)"Breadcrumb.http(request.\u2026(), request.method, code)");
        Breadcrumb breadcrumb3 = breadcrumb;
        RequestBody requestBody = request.body();
        this.ifHasValidLength(requestBody != null ? Long.valueOf(requestBody.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
        Response response3 = response;
        this.ifHasValidLength(response3 != null && (response3 = response3.body()) != null ? Long.valueOf(response3.contentLength()) : null, (Function1<? super Long, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
        this.hub.addBreadcrumb(breadcrumb3);
        return sentryTraceHeader;
    }

    private final void finishSpan(ISpan span, Request request, Response response) {
        if (span != null) {
            if (this.beforeSpan != null) {
                ISpan result = this.beforeSpan.execute(span, request, response);
                if (result == null) {
                    SpanContext spanContext = span.getSpanContext();
                    Intrinsics.checkNotNullExpressionValue((Object)spanContext, (String)"span.spanContext");
                    spanContext.setSampled(Boolean.valueOf(false));
                } else {
                    span.finish();
                }
            } else {
                span.finish();
            }
        }
    }

    private final void ifHasValidLength(Long $this$ifHasValidLength, Function1<? super Long, Unit> fn) {
        if ($this$ifHasValidLength != null && $this$ifHasValidLength != -1L) {
            fn.invoke((Object)$this$ifHasValidLength);
        }
    }

    public SentryOkHttpInterceptor(@NotNull IHub hub, @Nullable BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this.hub = hub;
        this.beforeSpan = beforeSpan;
    }

    public /* synthetic */ SentryOkHttpInterceptor(IHub iHub, BeforeSpanCallback beforeSpanCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            HubAdapter hubAdapter = HubAdapter.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"HubAdapter.getInstance()");
            iHub = (IHub)hubAdapter;
        }
        if ((n & 2) != 0) {
            beforeSpanCallback = null;
        }
        this(iHub, beforeSpanCallback);
    }

    public SentryOkHttpInterceptor() {
        this(null, null, 3, null);
    }

    public SentryOkHttpInterceptor(@NotNull IHub hub) {
        Intrinsics.checkNotNullParameter((Object)hub, (String)"hub");
        this(hub, null);
    }

    public SentryOkHttpInterceptor(@NotNull BeforeSpanCallback beforeSpan) {
        Intrinsics.checkNotNullParameter((Object)beforeSpan, (String)"beforeSpan");
        HubAdapter hubAdapter = HubAdapter.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)hubAdapter, (String)"HubAdapter.getInstance()");
        this((IHub)hubAdapter, beforeSpan);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lio/sentry/android/okhttp/SentryOkHttpInterceptor$BeforeSpanCallback;", "", "execute", "Lio/sentry/ISpan;", "span", "request", "Lokhttp3/Request;", "response", "Lokhttp3/Response;", "sentry-android-okhttp_release"})
    public static interface BeforeSpanCallback {
        @Nullable
        public ISpan execute(@NotNull ISpan var1, @NotNull Request var2, @Nullable Response var3);
    }
}

