package io.sentry.android.gradle.util

import java.io.File
import java.security.DigestInputStream
import java.security.MessageDigest

fun ByteArray.toHex(): String {
    val result = CharArray(size * 2) { ' ' }
    var i = 0
    forEach {
        val n = it.toInt()
        result[i++] = Character.forDigit(n shr 4 and 0xF, 16)
        result[i++] = Character.forDigit(n and 0xF, 16)
    }
    return String(result)
}

/**
 * Returns md5/sha256 hash of the file contents
 */
fun File.contentHash(): String {
    // first try to read hash generated by R8, which is located in the first 20 lines of mapping
    // lines are lazily iterated over, so even on huge files performance should not be a problem
    var hash: String? = null
    var index = 0
    bufferedReader().lines().use { lines ->
        for (line in lines) {
            hash = line.substringAfter("# pg_map_hash: SHA-256 ", missingDelimiterValue = "")
            if (++index > 20 || !hash.isNullOrBlank()) {
                break
            }
        }
    }
    if (!hash.isNullOrBlank()) {
        return hash!!
    }

    // otherwise fall back to calculating hash ourselves
    val md = MessageDigest.getInstance("MD5")
    DigestInputStream(inputStream(), md).buffered().readAllBytes()
    return md.digest().toHex()
}
