/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.app.ApplicationExitInfo;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.sentry.Attachment;
import io.sentry.DateUtils;
import io.sentry.Hint;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.Integration;
import io.sentry.SentryEnvelope;
import io.sentry.SentryEnvelopeItem;
import io.sentry.SentryEvent;
import io.sentry.SentryItemType;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.ApplicationExitInfoHistoryDispatcher;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.NativeEventCollector;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.cache.AndroidEnvelopeCache;
import io.sentry.android.core.internal.tombstone.NativeExceptionMechanism;
import io.sentry.android.core.internal.tombstone.TombstoneParser;
import io.sentry.hints.Backfillable;
import io.sentry.hints.BlockingFlushHint;
import io.sentry.hints.NativeCrashExit;
import io.sentry.protocol.DebugMeta;
import io.sentry.protocol.Mechanism;
import io.sentry.protocol.SentryException;
import io.sentry.protocol.SentryId;
import io.sentry.transport.CurrentDateProvider;
import io.sentry.transport.ICurrentDateProvider;
import io.sentry.util.HintUtils;
import io.sentry.util.IntegrationUtils;
import io.sentry.util.Objects;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class TombstoneIntegration
implements Integration,
Closeable {
    @NotNull
    private final Context context;
    @NotNull
    private final ICurrentDateProvider dateProvider;
    @Nullable
    private SentryAndroidOptions options;

    public TombstoneIntegration(@NotNull Context context) {
        this(context, CurrentDateProvider.getInstance());
    }

    TombstoneIntegration(@NotNull Context context, @NotNull ICurrentDateProvider dateProvider) {
        this.context = ContextUtils.getApplicationContext(context);
        this.dateProvider = dateProvider;
    }

    public void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)(options instanceof SentryAndroidOptions ? (SentryAndroidOptions)options : null)), (String)"SentryAndroidOptions is required"));
        this.options.getLogger().log(SentryLevel.DEBUG, "TombstoneIntegration enabled: %s", new Object[]{this.options.isTombstoneEnabled()});
        if (this.options.isTombstoneEnabled()) {
            if (this.options.getCacheDirPath() == null) {
                this.options.getLogger().log(SentryLevel.INFO, "Cache dir is not set, unable to process Tombstones", new Object[0]);
                return;
            }
            try {
                options.getExecutorService().submit((Runnable)new ApplicationExitInfoHistoryDispatcher(this.context, scopes, this.options, this.dateProvider, new TombstonePolicy(this.options, this.context)));
            }
            catch (Throwable e) {
                options.getLogger().log(SentryLevel.DEBUG, "Failed to start tombstone processor.", e);
            }
            options.getLogger().log(SentryLevel.DEBUG, "TombstoneIntegration installed.", new Object[0]);
            IntegrationUtils.addIntegrationToSdkVersion((String)"Tombstone");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.options != null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "TombstoneIntegration removed.", new Object[0]);
        }
    }

    @ApiStatus.Internal
    public static class TombstonePolicy
    implements ApplicationExitInfoHistoryDispatcher.ApplicationExitInfoPolicy {
        @NotNull
        private final SentryAndroidOptions options;
        @NotNull
        private final NativeEventCollector nativeEventCollector;
        @NotNull
        private final Context context;

        public TombstonePolicy(@NotNull SentryAndroidOptions options, @NotNull Context context) {
            this.options = options;
            this.nativeEventCollector = new NativeEventCollector(options);
            this.context = context;
        }

        @Override
        @NotNull
        public String getLabel() {
            return "Tombstone";
        }

        @Override
        @RequiresApi(api=30)
        public int getTargetReason() {
            return 5;
        }

        @Override
        public boolean shouldReportHistorical() {
            return this.options.isReportHistoricalTombstones();
        }

        @Override
        @Nullable
        public Long getLastReportedTimestamp() {
            return AndroidEnvelopeCache.lastReportedTombstone(this.options);
        }

        @Override
        @RequiresApi(api=30)
        @Nullable
        public ApplicationExitInfoHistoryDispatcher.Report buildReport(@NotNull ApplicationExitInfo exitInfo, boolean enrich) {
            SentryEvent event;
            try {
                InputStream tombstoneInputStream = exitInfo.getTraceInputStream();
                if (tombstoneInputStream == null) {
                    this.options.getLogger().log(SentryLevel.WARNING, "No tombstone InputStream available for ApplicationExitInfo from %s", new Object[]{DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(exitInfo.getTimestamp()))});
                    return null;
                }
                try (TombstoneParser parser = new TombstoneParser(tombstoneInputStream, this.options.getInAppIncludes(), this.options.getInAppExcludes(), this.context.getApplicationInfo().nativeLibraryDir);){
                    event = parser.parse();
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to parse tombstone from %s: %s", new Object[]{DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(exitInfo.getTimestamp())), e.getMessage()});
                return null;
            }
            long tombstoneTimestamp = exitInfo.getTimestamp();
            event.setTimestamp(DateUtils.getDateTime((long)tombstoneTimestamp));
            TombstoneHint tombstoneHint = new TombstoneHint(this.options.getFlushTimeoutMillis(), this.options.getLogger(), tombstoneTimestamp, enrich);
            Hint hint = HintUtils.createWithTypeCheckHint((Object)((Object)tombstoneHint));
            try {
                @Nullable SentryEvent mergedEvent = this.mergeWithMatchingNativeEvents(tombstoneTimestamp, event, hint);
                if (mergedEvent != null) {
                    event = mergedEvent;
                }
            }
            catch (Throwable e) {
                this.options.getLogger().log(SentryLevel.WARNING, "Failed to merge native event with tombstone, continuing without merge: %s", new Object[]{e.getMessage()});
            }
            return new ApplicationExitInfoHistoryDispatcher.Report(event, hint, tombstoneHint);
        }

        @Nullable
        private SentryEvent mergeWithMatchingNativeEvents(long tombstoneTimestamp, SentryEvent tombstoneEvent, Hint hint) {
            @Nullable NativeEventCollector.NativeEventData matchingNativeEvent = this.nativeEventCollector.findAndRemoveMatchingNativeEvent(tombstoneTimestamp);
            if (matchingNativeEvent == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "No matching native event found for tombstone.", new Object[0]);
                return null;
            }
            this.options.getLogger().log(SentryLevel.DEBUG, "Found matching native event for tombstone, removing from outbox: %s", new Object[]{matchingNativeEvent.getFile().getName()});
            boolean deletionSuccess = this.nativeEventCollector.deleteNativeEventFile(matchingNativeEvent);
            if (deletionSuccess) {
                SentryEvent nativeEvent = matchingNativeEvent.getEvent();
                this.mergeNativeCrashes(nativeEvent, tombstoneEvent);
                this.addNativeAttachmentsToTombstoneHint(matchingNativeEvent, hint);
                return nativeEvent;
            }
            return null;
        }

        private void addNativeAttachmentsToTombstoneHint(@NonNull NativeEventCollector.NativeEventData matchingNativeEvent, Hint hint) {
            @NotNull SentryEnvelope nativeEnvelope = matchingNativeEvent.getEnvelope();
            for (SentryEnvelopeItem item : nativeEnvelope.getItems()) {
                try {
                    @Nullable String attachmentFileName = item.getHeader().getFileName();
                    if (item.getHeader().getType() != SentryItemType.Attachment || attachmentFileName == null) continue;
                    hint.addAttachment(new Attachment(item.getData(), attachmentFileName, item.getHeader().getContentType(), item.getHeader().getAttachmentType(), false));
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "Failed to process envelope item: %s", new Object[]{e.getMessage()});
                }
            }
        }

        private void mergeNativeCrashes(@NotNull SentryEvent nativeEvent, @NotNull SentryEvent tombstoneEvent) {
            @Nullable List tombstoneExceptions = tombstoneEvent.getExceptions();
            @Nullable DebugMeta tombstoneDebugMeta = tombstoneEvent.getDebugMeta();
            @Nullable List tombstoneThreads = tombstoneEvent.getThreads();
            if (tombstoneExceptions != null && !tombstoneExceptions.isEmpty() && tombstoneDebugMeta != null && tombstoneThreads != null) {
                SentryException exception = (SentryException)tombstoneExceptions.get(0);
                @Nullable Mechanism mechanism = exception.getMechanism();
                if (mechanism != null) {
                    mechanism.setType(NativeExceptionMechanism.TOMBSTONE_MERGED.getValue());
                }
                if (nativeEvent.getMessage() == null || nativeEvent.getMessage().getMessage() == null || nativeEvent.getMessage().getMessage().isEmpty()) {
                    nativeEvent.setMessage(tombstoneEvent.getMessage());
                }
                nativeEvent.setExceptions(tombstoneExceptions);
                nativeEvent.setDebugMeta(tombstoneDebugMeta);
                nativeEvent.setThreads(tombstoneThreads);
            }
        }
    }

    @ApiStatus.Internal
    public static final class TombstoneHint
    extends BlockingFlushHint
    implements Backfillable,
    NativeCrashExit {
        private final long tombstoneTimestamp;
        private final boolean shouldEnrich;

        public TombstoneHint(long flushTimeoutMillis, @NotNull ILogger logger, long tombstoneTimestamp, boolean shouldEnrich) {
            super(flushTimeoutMillis, logger);
            this.tombstoneTimestamp = tombstoneTimestamp;
            this.shouldEnrich = shouldEnrich;
        }

        @NotNull
        public Long timestamp() {
            return this.tombstoneTimestamp;
        }

        public boolean shouldEnrich() {
            return this.shouldEnrich;
        }

        public boolean isFlushable(@Nullable SentryId eventId) {
            return true;
        }

        public void setFlushable(@NotNull SentryId eventId) {
        }
    }
}

