/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.content.Context;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryUUID;
import io.sentry.util.AutoClosableReentrantLock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class Installation {
    @TestOnly
    @Nullable
    static String deviceId = null;
    @TestOnly
    static final String INSTALLATION = "INSTALLATION";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @NotNull
    protected static final AutoClosableReentrantLock staticLock = new AutoClosableReentrantLock();

    private Installation() {
    }

    public static String id(@NotNull Context context) throws RuntimeException {
        try (@NotNull ISentryLifecycleToken ignored = staticLock.acquire();){
            if (deviceId == null) {
                File installation;
                block11: {
                    installation = new File(context.getFilesDir(), INSTALLATION);
                    try {
                        if (installation.exists()) break block11;
                        String string = deviceId = Installation.writeInstallationFile(installation);
                        return string;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
                deviceId = Installation.readInstallationFile(installation);
            }
            String string = deviceId;
            return string;
        }
    }

    @TestOnly
    @NotNull
    static String readInstallationFile(@NotNull File installation) throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(installation, "r");){
            byte[] bytes = new byte[(int)f.length()];
            f.readFully(bytes);
            String string = new String(bytes, UTF_8);
            return string;
        }
    }

    @TestOnly
    @NotNull
    static String writeInstallationFile(@NotNull File installation) throws IOException {
        try (FileOutputStream out = new FileOutputStream(installation);){
            String id = SentryUUID.generateSentryId();
            ((OutputStream)out).write(id.getBytes(UTF_8));
            out.flush();
            String string = id;
            return string;
        }
    }
}

