/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.IEnvelopeSender;
import io.sentry.ILogger;
import io.sentry.IScopes;
import io.sentry.ISentryLifecycleToken;
import io.sentry.Integration;
import io.sentry.OutboxSender;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.EnvelopeFileObserver;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class EnvelopeFileObserverIntegration
implements Integration,
Closeable {
    @Nullable
    private EnvelopeFileObserver observer;
    @Nullable
    private ILogger logger;
    private boolean isClosed = false;
    @NotNull
    protected final AutoClosableReentrantLock startLock = new AutoClosableReentrantLock();

    @NotNull
    public static EnvelopeFileObserverIntegration getOutboxFileObserver() {
        return new OutboxEnvelopeFileObserverIntegration();
    }

    public final void register(@NotNull IScopes scopes, @NotNull SentryOptions options) {
        Objects.requireNonNull((Object)scopes, (String)"Scopes are required");
        Objects.requireNonNull((Object)options, (String)"SentryOptions is required");
        this.logger = options.getLogger();
        String path = this.getPath(options);
        if (path == null) {
            this.logger.log(SentryLevel.WARNING, "Null given as a path to EnvelopeFileObserverIntegration. Nothing will be registered.", new Object[0]);
        } else {
            this.logger.log(SentryLevel.DEBUG, "Registering EnvelopeFileObserverIntegration for path: %s", new Object[]{path});
            try {
                options.getExecutorService().submit(() -> {
                    try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
                        if (!this.isClosed) {
                            this.startOutboxSender(scopes, options, path);
                        }
                    }
                });
            }
            catch (Throwable e) {
                this.logger.log(SentryLevel.DEBUG, "Failed to start EnvelopeFileObserverIntegration on executor thread.", e);
            }
        }
    }

    private void startOutboxSender(@NotNull IScopes scopes, @NotNull SentryOptions options, @NotNull String path) {
        OutboxSender outboxSender = new OutboxSender(scopes, options.getEnvelopeReader(), options.getSerializer(), options.getLogger(), options.getFlushTimeoutMillis(), options.getMaxQueueSize());
        this.observer = new EnvelopeFileObserver(path, (IEnvelopeSender)outboxSender, options.getLogger(), options.getFlushTimeoutMillis());
        try {
            this.observer.startWatching();
            options.getLogger().log(SentryLevel.DEBUG, "EnvelopeFileObserverIntegration installed.", new Object[0]);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to initialize EnvelopeFileObserverIntegration.", e);
        }
    }

    @Override
    public void close() {
        try (@NotNull ISentryLifecycleToken ignored = this.startLock.acquire();){
            this.isClosed = true;
        }
        if (this.observer != null) {
            this.observer.stopWatching();
            if (this.logger != null) {
                this.logger.log(SentryLevel.DEBUG, "EnvelopeFileObserverIntegration removed.", new Object[0]);
            }
        }
    }

    @TestOnly
    @Nullable
    abstract String getPath(@NotNull SentryOptions var1);

    private static final class OutboxEnvelopeFileObserverIntegration
    extends EnvelopeFileObserverIntegration {
        private OutboxEnvelopeFileObserverIntegration() {
        }

        @Override
        @Nullable
        protected String getPath(@NotNull SentryOptions options) {
            return options.getOutboxPath();
        }
    }
}

