/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.PixelCopy;
import android.view.View;
import android.view.Window;
import androidx.annotation.Nullable;
import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.internal.util.AndroidThreadChecker;
import io.sentry.util.thread.IThreadChecker;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ScreenshotUtils {
    private static final long CAPTURE_TIMEOUT_MS = 1000L;

    @Nullable
    public static byte[] takeScreenshot(@NotNull Activity activity, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        return ScreenshotUtils.takeScreenshot(activity, AndroidThreadChecker.getInstance(), logger, buildInfoProvider);
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static byte[] takeScreenshot(@NotNull Activity activity, @NotNull IThreadChecker threadChecker, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        Bitmap screenshot = ScreenshotUtils.captureScreenshot(activity, threadChecker, logger, buildInfoProvider);
        return ScreenshotUtils.compressBitmapToPng(screenshot, logger);
    }

    @Nullable
    public static Bitmap captureScreenshot(@NotNull Activity activity, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        return ScreenshotUtils.captureScreenshot(activity, AndroidThreadChecker.getInstance(), logger, buildInfoProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"NewApi"})
    @Nullable
    public static Bitmap captureScreenshot(@NotNull Activity activity, @NotNull IThreadChecker threadChecker, @NotNull ILogger logger, @NotNull BuildInfoProvider buildInfoProvider) {
        if (!ScreenshotUtils.isActivityValid(activity)) {
            logger.log(SentryLevel.DEBUG, "Activity isn't valid, not taking screenshot.", new Object[0]);
            return null;
        }
        Window window = activity.getWindow();
        if (window == null) {
            logger.log(SentryLevel.DEBUG, "Activity window is null, not taking screenshot.", new Object[0]);
            return null;
        }
        View decorView = window.peekDecorView();
        if (decorView == null) {
            logger.log(SentryLevel.DEBUG, "DecorView is null, not taking screenshot.", new Object[0]);
            return null;
        }
        View view = decorView.getRootView();
        if (view == null) {
            logger.log(SentryLevel.DEBUG, "Root view is null, not taking screenshot.", new Object[0]);
            return null;
        }
        if (view.getWidth() <= 0 || view.getHeight() <= 0) {
            logger.log(SentryLevel.DEBUG, "View's width and height is zeroed, not taking screenshot.", new Object[0]);
            return null;
        }
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            @NotNull CountDownLatch latch = new CountDownLatch(1);
            if (buildInfoProvider.getSdkInfoVersion() >= 26) {
                HandlerThread thread = new HandlerThread("SentryScreenshot");
                thread.start();
                boolean success = false;
                try {
                    Handler handler = new Handler(thread.getLooper());
                    AtomicBoolean copyResultSuccess = new AtomicBoolean(false);
                    PixelCopy.request((Window)window, (Bitmap)bitmap, copyResult -> {
                        copyResultSuccess.set(copyResult == 0);
                        latch.countDown();
                    }, (Handler)handler);
                    success = latch.await(1000L, TimeUnit.MILLISECONDS) && copyResultSuccess.get();
                }
                catch (Throwable e) {
                    logger.log(SentryLevel.ERROR, "Taking screenshot using PixelCopy failed.", e);
                }
                finally {
                    thread.quit();
                }
                if (!success) {
                    return null;
                }
            } else {
                Canvas canvas = new Canvas(bitmap);
                if (threadChecker.isMainThread()) {
                    view.draw(canvas);
                    latch.countDown();
                } else {
                    activity.runOnUiThread(() -> {
                        try {
                            view.draw(canvas);
                        }
                        catch (Throwable e) {
                            logger.log(SentryLevel.ERROR, "Taking screenshot failed (view.draw).", e);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                if (!latch.await(1000L, TimeUnit.MILLISECONDS)) {
                    return null;
                }
            }
            return bitmap;
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Taking screenshot failed.", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static byte[] compressBitmapToPng(@Nullable Bitmap bitmap, @NotNull ILogger logger) {
        if (bitmap == null) return null;
        if (bitmap.isRecycled()) {
            return null;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream);
            bitmap.recycle();
            if (byteArrayOutputStream.size() <= 0) {
                logger.log(SentryLevel.DEBUG, "Screenshot is 0 bytes, not attaching the image.", new Object[0]);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            logger.log(SentryLevel.ERROR, "Compressing bitmap failed.", e);
            return null;
        }
    }

    private static boolean isActivityValid(@NotNull Activity activity) {
        return !activity.isFinishing() && !activity.isDestroyed();
    }
}

