/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import io.sentry.protocol.SentryThread;
import io.sentry.util.thread.IThreadChecker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AndroidThreadChecker
implements IThreadChecker {
    private static final AndroidThreadChecker instance = new AndroidThreadChecker();
    public static volatile long mainThreadSystemId = Process.myTid();

    public static AndroidThreadChecker getInstance() {
        return instance;
    }

    private AndroidThreadChecker() {
        new Handler(Looper.getMainLooper()).post(() -> {
            mainThreadSystemId = Process.myTid();
        });
    }

    public boolean isMainThread(long threadId) {
        return Looper.getMainLooper().getThread().getId() == threadId;
    }

    public boolean isMainThread(@NotNull Thread thread) {
        return this.isMainThread(thread.getId());
    }

    public boolean isMainThread() {
        return this.isMainThread(Thread.currentThread());
    }

    @NotNull
    public String getCurrentThreadName() {
        return this.isMainThread() ? "main" : Thread.currentThread().getName();
    }

    public boolean isMainThread(@NotNull SentryThread sentryThread) {
        Long threadId = sentryThread.getId();
        return threadId != null && this.isMainThread(threadId);
    }

    public long currentThreadSystemId() {
        return Process.myTid();
    }
}

