/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core.internal.gestures;

import android.app.Activity;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import io.sentry.Breadcrumb;
import io.sentry.Hint;
import io.sentry.IScope;
import io.sentry.IScopes;
import io.sentry.ITransaction;
import io.sentry.SentryLevel;
import io.sentry.SpanStatus;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.gestures.ViewUtils;
import io.sentry.internal.gestures.UiElement;
import io.sentry.protocol.TransactionNameSource;
import io.sentry.util.TracingUtils;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class SentryGestureListener
implements GestureDetector.OnGestureListener {
    static final String UI_ACTION = "ui.action";
    private static final String TRACE_ORIGIN = "auto.ui.gesture_listener";
    @NotNull
    private final WeakReference<Activity> activityRef;
    @NotNull
    private final IScopes scopes;
    @NotNull
    private final SentryAndroidOptions options;
    @Nullable
    private UiElement activeUiElement = null;
    @Nullable
    private ITransaction activeTransaction = null;
    @NotNull
    private GestureType activeEventType = GestureType.Unknown;
    private final ScrollState scrollState = new ScrollState();

    public SentryGestureListener(@NotNull Activity currentActivity, @NotNull IScopes scopes, @NotNull SentryAndroidOptions options) {
        this.activityRef = new WeakReference<Activity>(currentActivity);
        this.scopes = scopes;
        this.options = options;
    }

    public void onUp(@NotNull MotionEvent motionEvent) {
        View decorView = this.ensureWindowDecorView("onUp");
        UiElement scrollTarget = this.scrollState.target;
        if (decorView == null || scrollTarget == null) {
            return;
        }
        if (this.scrollState.type == GestureType.Unknown) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Unable to define scroll type. No breadcrumb captured.", new Object[0]);
            return;
        }
        String direction = this.scrollState.calculateDirection(motionEvent);
        this.addBreadcrumb(scrollTarget, this.scrollState.type, Collections.singletonMap("direction", direction), motionEvent);
        this.startTracing(scrollTarget, this.scrollState.type);
        this.scrollState.reset();
    }

    public boolean onDown(@Nullable MotionEvent motionEvent) {
        if (motionEvent == null) {
            return false;
        }
        this.scrollState.reset();
        this.scrollState.startX = motionEvent.getX();
        this.scrollState.startY = motionEvent.getY();
        return false;
    }

    public boolean onSingleTapUp(@Nullable MotionEvent motionEvent) {
        View decorView = this.ensureWindowDecorView("onSingleTapUp");
        if (decorView == null || motionEvent == null) {
            return false;
        }
        @Nullable UiElement target = ViewUtils.findTarget(this.options, decorView, motionEvent.getX(), motionEvent.getY(), UiElement.Type.CLICKABLE);
        if (target == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Unable to find click target. No breadcrumb captured.", new Object[0]);
            return false;
        }
        this.addBreadcrumb(target, GestureType.Click, Collections.emptyMap(), motionEvent);
        this.startTracing(target, GestureType.Click);
        return false;
    }

    public boolean onScroll(@Nullable MotionEvent firstEvent, @Nullable MotionEvent currentEvent, float distX, float distY) {
        View decorView = this.ensureWindowDecorView("onScroll");
        if (decorView == null || firstEvent == null) {
            return false;
        }
        if (this.scrollState.type == GestureType.Unknown) {
            @Nullable UiElement target = ViewUtils.findTarget(this.options, decorView, firstEvent.getX(), firstEvent.getY(), UiElement.Type.SCROLLABLE);
            if (target == null) {
                this.options.getLogger().log(SentryLevel.DEBUG, "Unable to find scroll target. No breadcrumb captured.", new Object[0]);
                this.scrollState.type = GestureType.Scroll;
                return false;
            }
            this.options.getLogger().log(SentryLevel.DEBUG, "Scroll target found: " + target.getIdentifier(), new Object[0]);
            this.scrollState.setTarget(target);
            this.scrollState.type = GestureType.Scroll;
        }
        return false;
    }

    public boolean onFling(@Nullable MotionEvent motionEvent, @Nullable MotionEvent motionEvent1, float v, float v1) {
        this.scrollState.type = GestureType.Swipe;
        return false;
    }

    public void onShowPress(MotionEvent motionEvent) {
    }

    public void onLongPress(MotionEvent motionEvent) {
    }

    private void addBreadcrumb(@NotNull UiElement target, @NotNull GestureType eventType, @NotNull Map<String, Object> additionalData, @NotNull MotionEvent motionEvent) {
        if (!this.options.isEnableUserInteractionBreadcrumbs()) {
            return;
        }
        String type = SentryGestureListener.getGestureType(eventType);
        Hint hint = new Hint();
        hint.set("android:motionEvent", (Object)motionEvent);
        hint.set("android:view", target.getView());
        this.scopes.addBreadcrumb(Breadcrumb.userInteraction((String)type, (String)target.getResourceName(), (String)target.getClassName(), (String)target.getTag(), additionalData), hint);
    }

    private void startTracing(@NotNull UiElement target, @NotNull GestureType eventType) {
        boolean isNewInteraction;
        boolean isNewGestureSameAsActive = eventType == this.activeEventType && target.equals((Object)this.activeUiElement);
        boolean isClickGesture = eventType == GestureType.Click;
        boolean bl = isNewInteraction = isClickGesture || !isNewGestureSameAsActive;
        if (!this.options.isTracingEnabled() || !this.options.isEnableUserInteractionTracing()) {
            if (isNewInteraction) {
                if (this.options.isEnableAutoTraceIdGeneration()) {
                    TracingUtils.startNewTrace((IScopes)this.scopes);
                }
                this.activeUiElement = target;
                this.activeEventType = eventType;
            }
            return;
        }
        Activity activity = (Activity)this.activityRef.get();
        if (activity == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Activity is null, no transaction captured.", new Object[0]);
            return;
        }
        @Nullable String viewIdentifier = target.getIdentifier();
        if (this.activeTransaction != null) {
            if (!isNewInteraction && !this.activeTransaction.isFinished()) {
                this.options.getLogger().log(SentryLevel.DEBUG, "The view with id: " + viewIdentifier + " already has an ongoing transaction assigned. Rescheduling finish", new Object[0]);
                Long idleTimeout = this.options.getIdleTimeout();
                if (idleTimeout != null) {
                    this.activeTransaction.scheduleFinish();
                }
                return;
            }
            this.stopTracing(SpanStatus.OK);
        }
        String name = this.getActivityName(activity) + "." + viewIdentifier;
        String op = "ui.action." + SentryGestureListener.getGestureType(eventType);
        TransactionOptions transactionOptions = new TransactionOptions();
        transactionOptions.setWaitForChildren(true);
        long deadlineTimeoutMillis = this.options.getDeadlineTimeout();
        transactionOptions.setDeadlineTimeout(deadlineTimeoutMillis <= 0L ? null : Long.valueOf(deadlineTimeoutMillis));
        transactionOptions.setIdleTimeout(this.options.getIdleTimeout());
        transactionOptions.setTrimEnd(true);
        transactionOptions.setOrigin("auto.ui.gesture_listener." + target.getOrigin());
        ITransaction transaction = this.scopes.startTransaction(new TransactionContext(name, TransactionNameSource.COMPONENT, op), transactionOptions);
        this.scopes.configureScope(scope -> this.applyScope(scope, transaction));
        this.activeTransaction = transaction;
        this.activeUiElement = target;
        this.activeEventType = eventType;
    }

    void stopTracing(@NotNull SpanStatus status) {
        if (this.activeTransaction != null) {
            SpanStatus currentStatus = this.activeTransaction.getStatus();
            if (currentStatus == null) {
                this.activeTransaction.finish(status);
            } else {
                this.activeTransaction.finish();
            }
        }
        this.scopes.configureScope(scope -> this.clearScope(scope));
        this.activeTransaction = null;
        if (this.activeUiElement != null) {
            this.activeUiElement = null;
        }
        this.activeEventType = GestureType.Unknown;
    }

    @VisibleForTesting
    void clearScope(@NotNull IScope scope) {
        scope.withTransaction(transaction -> {
            if (transaction == this.activeTransaction) {
                scope.clearTransaction();
            }
        });
    }

    @VisibleForTesting
    void applyScope(@NotNull IScope scope, @NotNull ITransaction transaction) {
        scope.withTransaction(scopeTransaction -> {
            if (scopeTransaction == null) {
                scope.setTransaction(transaction);
            } else {
                this.options.getLogger().log(SentryLevel.DEBUG, "Transaction '%s' won't be bound to the Scope since there's one already in there.", new Object[]{transaction.getName()});
            }
        });
    }

    @NotNull
    private String getActivityName(@NotNull Activity activity) {
        return activity.getClass().getSimpleName();
    }

    @Nullable
    private View ensureWindowDecorView(@NotNull String caller) {
        Activity activity = (Activity)this.activityRef.get();
        if (activity == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Activity is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        Window window = activity.getWindow();
        if (window == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "Window is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        View decorView = window.getDecorView();
        if (decorView == null) {
            this.options.getLogger().log(SentryLevel.DEBUG, "DecorView is null in " + caller + ". No breadcrumb captured.", new Object[0]);
            return null;
        }
        return decorView;
    }

    @NotNull
    private static String getGestureType(@NotNull GestureType eventType) {
        String type;
        switch (eventType) {
            case Click: {
                type = "click";
                break;
            }
            case Scroll: {
                type = "scroll";
                break;
            }
            case Swipe: {
                type = "swipe";
                break;
            }
            default: {
                type = "unknown";
            }
        }
        return type;
    }

    private static enum GestureType {
        Click,
        Scroll,
        Swipe,
        Unknown;

    }

    private static final class ScrollState {
        @NotNull
        private GestureType type = GestureType.Unknown;
        @Nullable
        private UiElement target;
        private float startX = 0.0f;
        private float startY = 0.0f;

        private ScrollState() {
        }

        private void setTarget(@NotNull UiElement target) {
            this.target = target;
        }

        @NotNull
        private String calculateDirection(MotionEvent endEvent) {
            float diffX = endEvent.getX() - this.startX;
            float diffY = endEvent.getY() - this.startY;
            String direction = Math.abs(diffX) > Math.abs(diffY) ? (diffX > 0.0f ? "right" : "left") : (diffY > 0.0f ? "down" : "up");
            return direction;
        }

        private void reset() {
            this.target = null;
            this.type = GestureType.Unknown;
            this.startX = 0.0f;
            this.startY = 0.0f;
        }
    }
}

