/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.LocaleList;
import android.os.StatFs;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import io.sentry.DateUtils;
import io.sentry.ISentryLifecycleToken;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.android.core.BuildInfoProvider;
import io.sentry.android.core.ContextUtils;
import io.sentry.android.core.Installation;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.CpuInfoUtils;
import io.sentry.android.core.internal.util.DeviceOrientations;
import io.sentry.android.core.internal.util.RootChecker;
import io.sentry.protocol.Device;
import io.sentry.protocol.OperatingSystem;
import io.sentry.util.AutoClosableReentrantLock;
import java.io.File;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class DeviceInfoUtil {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile DeviceInfoUtil instance;
    @NotNull
    private static final AutoClosableReentrantLock staticLock;
    @NotNull
    private final Context context;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final BuildInfoProvider buildInfoProvider;
    @Nullable
    private final Boolean isEmulator;
    @Nullable
    private final ContextUtils.SideLoadedInfo sideLoadedInfo;
    @Nullable
    private final ContextUtils.SplitApksInfo splitApksInfo;
    @NotNull
    private final OperatingSystem os;
    @Nullable
    private final Long totalMem;

    public DeviceInfoUtil(@NotNull Context context, @NotNull SentryAndroidOptions options) {
        this.context = context;
        this.options = options;
        this.buildInfoProvider = new BuildInfoProvider(options.getLogger());
        CpuInfoUtils.getInstance().readMaxFrequencies();
        this.os = this.retrieveOperatingSystemInformation();
        this.isEmulator = this.buildInfoProvider.isEmulator();
        this.sideLoadedInfo = ContextUtils.retrieveSideLoadedInfo(context, options.getLogger(), this.buildInfoProvider);
        this.splitApksInfo = ContextUtils.retrieveSplitApksInfo(context, this.buildInfoProvider);
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ActivityManager.MemoryInfo memInfo = ContextUtils.getMemInfo(context, options.getLogger());
        this.totalMem = memInfo != null ? Long.valueOf(memInfo.totalMem) : null;
    }

    @NotNull
    public static DeviceInfoUtil getInstance(@NotNull Context context, @NotNull SentryAndroidOptions options) {
        if (instance == null) {
            try (@NotNull ISentryLifecycleToken ignored = staticLock.acquire();){
                if (instance == null) {
                    instance = new DeviceInfoUtil(ContextUtils.getApplicationContext(context), options);
                }
            }
        }
        return instance;
    }

    @TestOnly
    public static void resetInstance() {
        instance = null;
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    public Device collectDeviceInformation(boolean collectDeviceIO, boolean collectDynamicData) {
        List<Integer> cpuFrequencies;
        DisplayMetrics displayMetrics;
        @NotNull Device device = new Device();
        device.setManufacturer(Build.MANUFACTURER);
        device.setBrand(Build.BRAND);
        device.setFamily(ContextUtils.getFamily(this.options.getLogger()));
        device.setModel(Build.MODEL);
        device.setModelId(Build.ID);
        device.setArchs(ContextUtils.getArchitectures());
        if (this.buildInfoProvider.getSdkInfoVersion() >= 31) {
            device.setChipset(Build.SOC_MANUFACTURER + " " + Build.SOC_MODEL);
        }
        device.setOrientation(this.getOrientation());
        if (this.isEmulator != null) {
            device.setSimulator(this.isEmulator);
        }
        if ((displayMetrics = ContextUtils.getDisplayMetrics(this.context, this.options.getLogger())) != null) {
            device.setScreenWidthPixels(Integer.valueOf(displayMetrics.widthPixels));
            device.setScreenHeightPixels(Integer.valueOf(displayMetrics.heightPixels));
            device.setScreenDensity(Float.valueOf(displayMetrics.density));
            device.setScreenDpi(Integer.valueOf(displayMetrics.densityDpi));
        }
        device.setBootTime(this.getBootTime());
        device.setTimezone(this.getTimeZone());
        if (device.getId() == null) {
            device.setId(this.getDeviceId());
        }
        @NotNull Locale locale = Locale.getDefault();
        if (device.getLocale() == null) {
            device.setLocale(locale.toString());
        }
        if (!(cpuFrequencies = CpuInfoUtils.getInstance().readMaxFrequencies()).isEmpty()) {
            device.setProcessorFrequency(Double.valueOf(Collections.max(cpuFrequencies).doubleValue()));
            device.setProcessorCount(Integer.valueOf(cpuFrequencies.size()));
        }
        device.setMemorySize(this.totalMem);
        if (collectDeviceIO && this.options.isCollectAdditionalContext()) {
            this.setDeviceIO(device, collectDynamicData);
        }
        return device;
    }

    @NotNull
    public OperatingSystem getOperatingSystem() {
        return this.os;
    }

    @Nullable
    public Long getTotalMemory() {
        return this.totalMem;
    }

    @NotNull
    private OperatingSystem retrieveOperatingSystemInformation() {
        OperatingSystem os = new OperatingSystem();
        os.setName("Android");
        os.setVersion(Build.VERSION.RELEASE);
        os.setBuild(Build.DISPLAY);
        @Nullable String kernelVersion = ContextUtils.getKernelVersion(this.options.getLogger());
        if (kernelVersion != null) {
            os.setKernelVersion(kernelVersion);
        }
        if (this.options.isEnableRootCheck()) {
            boolean rooted = new RootChecker(this.context, this.buildInfoProvider, this.options.getLogger()).isDeviceRooted();
            os.setRooted(Boolean.valueOf(rooted));
        }
        return os;
    }

    @Nullable
    public ContextUtils.SideLoadedInfo getSideLoadedInfo() {
        return this.sideLoadedInfo;
    }

    @Nullable
    public ContextUtils.SplitApksInfo getSplitApksInfo() {
        return this.splitApksInfo;
    }

    private void setDeviceIO(@NotNull Device device, boolean includeDynamicData) {
        Boolean connected;
        Intent batteryIntent = this.getBatteryIntent();
        if (batteryIntent != null) {
            device.setBatteryLevel(DeviceInfoUtil.getBatteryLevel(batteryIntent, this.options));
            device.setCharging(DeviceInfoUtil.isCharging(batteryIntent, this.options));
            device.setBatteryTemperature(this.getBatteryTemperature(batteryIntent));
        }
        switch (this.options.getConnectionStatusProvider().getConnectionStatus()) {
            case DISCONNECTED: {
                connected = false;
                break;
            }
            case CONNECTED: {
                connected = true;
                break;
            }
            default: {
                connected = null;
            }
        }
        device.setOnline(connected);
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable ActivityManager.MemoryInfo memInfo = ContextUtils.getMemInfo(this.context, this.options.getLogger());
        if (memInfo != null && includeDynamicData) {
            device.setFreeMemory(Long.valueOf(memInfo.availMem));
            device.setLowMemory(Boolean.valueOf(memInfo.lowMemory));
        }
        this.options.getRuntimeManager().runWithRelaxedPolicy(() -> {
            StatFs externalStorageStat;
            @Nullable File internalStorageFile = this.context.getExternalFilesDir(null);
            if (internalStorageFile != null) {
                StatFs internalStorageStat = new StatFs(internalStorageFile.getPath());
                device.setStorageSize(this.getTotalInternalStorage(internalStorageStat));
                device.setFreeStorage(this.getUnusedInternalStorage(internalStorageStat));
            }
            if ((externalStorageStat = this.getExternalStorageStat(internalStorageFile)) != null) {
                device.setExternalStorageSize(this.getTotalExternalStorage(externalStorageStat));
                device.setExternalFreeStorage(this.getUnusedExternalStorage(externalStorageStat));
            }
        });
        if (device.getConnectionType() == null) {
            device.setConnectionType(this.options.getConnectionStatusProvider().getConnectionType());
        }
    }

    @NotNull
    private TimeZone getTimeZone() {
        LocaleList locales;
        if (this.buildInfoProvider.getSdkInfoVersion() >= 24 && !(locales = this.context.getResources().getConfiguration().getLocales()).isEmpty()) {
            Locale locale = locales.get(0);
            return Calendar.getInstance(locale).getTimeZone();
        }
        return Calendar.getInstance().getTimeZone();
    }

    @Nullable
    private Date getBootTime() {
        try {
            return DateUtils.getDateTime((long)(System.currentTimeMillis() - SystemClock.elapsedRealtime()));
        }
        catch (IllegalArgumentException e) {
            this.options.getLogger().log(SentryLevel.ERROR, (Throwable)e, "Error getting the device's boot time.", new Object[0]);
            return null;
        }
    }

    @Nullable
    private Intent getBatteryIntent() {
        return ContextUtils.registerReceiver(this.context, this.buildInfoProvider, null, new IntentFilter("android.intent.action.BATTERY_CHANGED"), null);
    }

    @Nullable
    public static Float getBatteryLevel(@NotNull Intent batteryIntent, @NotNull SentryOptions options) {
        try {
            int level = batteryIntent.getIntExtra("level", -1);
            int scale = batteryIntent.getIntExtra("scale", -1);
            if (level == -1 || scale == -1) {
                return null;
            }
            float percentMultiplier = 100.0f;
            return Float.valueOf((float)level / (float)scale * percentMultiplier);
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Error getting device battery level.", e);
            return null;
        }
    }

    @Nullable
    public static Boolean isCharging(@NotNull Intent batteryIntent, @NotNull SentryOptions options) {
        try {
            int plugged = batteryIntent.getIntExtra("plugged", -1);
            return plugged == 1 || plugged == 2;
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Error getting device charging state.", e);
            return null;
        }
    }

    @Nullable
    private Float getBatteryTemperature(@NotNull Intent batteryIntent) {
        try {
            int temperature = batteryIntent.getIntExtra("temperature", -1);
            if (temperature != -1) {
                return Float.valueOf((float)temperature / 10.0f);
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting battery temperature.", e);
        }
        return null;
    }

    @Nullable
    private Device.DeviceOrientation getOrientation() {
        Device.DeviceOrientation deviceOrientation = null;
        try {
            deviceOrientation = DeviceOrientations.getOrientation(this.context.getResources().getConfiguration().orientation);
            if (deviceOrientation == null) {
                this.options.getLogger().log(SentryLevel.INFO, "No device orientation available (ORIENTATION_SQUARE|ORIENTATION_UNDEFINED)", new Object[0]);
                return null;
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting device orientation.", e);
        }
        return deviceOrientation;
    }

    @Nullable
    private Long getTotalInternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = stat.getBlockSizeLong();
            long totalBlocks = stat.getBlockCountLong();
            return totalBlocks * blockSize;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting total internal storage amount.", e);
            return null;
        }
    }

    @Nullable
    private Long getUnusedInternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = stat.getBlockSizeLong();
            long availableBlocks = stat.getAvailableBlocksLong();
            return availableBlocks * blockSize;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting unused internal storage amount.", e);
            return null;
        }
    }

    @Nullable
    private StatFs getExternalStorageStat(@Nullable File internalStorage) {
        try {
            File path = this.getExternalStorageDep(internalStorage);
            if (path != null) {
                return new StatFs(path.getPath());
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.INFO, "Not possible to read external files directory", new Object[0]);
        }
        return null;
    }

    @Nullable
    private File getExternalStorageDep(@Nullable File internalStorage) {
        @Nullable File[] externalFilesDirs = this.context.getExternalFilesDirs(null);
        if (externalFilesDirs != null) {
            String internalStoragePath = internalStorage != null ? internalStorage.getAbsolutePath() : null;
            for (File file : externalFilesDirs) {
                if (file == null) continue;
                if (internalStoragePath == null || internalStoragePath.isEmpty()) {
                    return file;
                }
                if (file.getAbsolutePath().contains(internalStoragePath)) continue;
                return file;
            }
        } else {
            this.options.getLogger().log(SentryLevel.INFO, "Not possible to read getExternalFilesDirs", new Object[0]);
        }
        return null;
    }

    @Nullable
    private Long getTotalExternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = stat.getBlockSizeLong();
            long totalBlocks = stat.getBlockCountLong();
            return totalBlocks * blockSize;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting total external storage amount.", e);
            return null;
        }
    }

    @Nullable
    private Long getUnusedExternalStorage(@NotNull StatFs stat) {
        try {
            long blockSize = stat.getBlockSizeLong();
            long availableBlocks = stat.getAvailableBlocksLong();
            return availableBlocks * blockSize;
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting unused external storage amount.", e);
            return null;
        }
    }

    @Nullable
    private String getDeviceId() {
        try {
            return (String)this.options.getRuntimeManager().runWithRelaxedPolicy(() -> Installation.id(this.context));
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Error getting installationId.", e);
            return null;
        }
    }

    static {
        staticLock = new AutoClosableReentrantLock();
    }
}

