/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.android.core;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.ISentryLifecycleToken;
import io.sentry.MeasurementUnit;
import io.sentry.SentryEvent;
import io.sentry.SpanContext;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.android.core.ActivityFramesTracker;
import io.sentry.android.core.SentryAndroidOptions;
import io.sentry.android.core.internal.util.AndroidThreadChecker;
import io.sentry.android.core.performance.AppStartMetrics;
import io.sentry.android.core.performance.TimeSpan;
import io.sentry.protocol.App;
import io.sentry.protocol.MeasurementValue;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.SentrySpan;
import io.sentry.protocol.SentryTransaction;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.Objects;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PerformanceAndroidEventProcessor
implements EventProcessor {
    private static final String APP_METRICS_ORIGIN = "auto.ui";
    private static final String APP_METRICS_CONTENT_PROVIDER_OP = "contentprovider.load";
    private static final String APP_METRICS_ACTIVITIES_OP = "activity.load";
    private static final String APP_METRICS_APPLICATION_OP = "application.load";
    private static final String APP_METRICS_PROCESS_INIT_OP = "process.load";
    private static final long MAX_PROCESS_INIT_APP_START_DIFF_MS = 10000L;
    private boolean sentStartMeasurement = false;
    @NotNull
    private final ActivityFramesTracker activityFramesTracker;
    @NotNull
    private final SentryAndroidOptions options;
    @NotNull
    private final AutoClosableReentrantLock lock = new AutoClosableReentrantLock();

    PerformanceAndroidEventProcessor(@NotNull SentryAndroidOptions options, @NotNull ActivityFramesTracker activityFramesTracker) {
        this.options = (SentryAndroidOptions)((Object)Objects.requireNonNull((Object)((Object)options), (String)"SentryAndroidOptions is required"));
        this.activityFramesTracker = (ActivityFramesTracker)Objects.requireNonNull((Object)activityFramesTracker, (String)"ActivityFramesTracker is required");
    }

    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        return event;
    }

    @NotNull
    public SentryTransaction process(@NotNull SentryTransaction transaction, @NotNull Hint hint) {
        try (@NotNull ISentryLifecycleToken ignored = this.lock.acquire();){
            Map<String, MeasurementValue> framesMetrics;
            if (!this.options.isTracingEnabled()) {
                SentryTransaction sentryTransaction = transaction;
                return sentryTransaction;
            }
            @NotNull AppStartMetrics appStartMetrics = AppStartMetrics.getInstance();
            if (this.hasAppStartSpan(transaction)) {
                App appContext;
                TimeSpan appStartTimeSpan;
                long appStartUpDurationMs;
                if (appStartMetrics.shouldSendStartMeasurements() && (appStartUpDurationMs = (appStartTimeSpan = appStartMetrics.getAppStartTimeSpanWithFallback(this.options)).getDurationMs()) != 0L) {
                    MeasurementValue value = new MeasurementValue((Number)Float.valueOf(appStartUpDurationMs), MeasurementUnit.Duration.MILLISECOND.apiName());
                    String appStartKey = appStartMetrics.getAppStartType() == AppStartMetrics.AppStartType.COLD ? "app_start_cold" : "app_start_warm";
                    transaction.getMeasurements().put(appStartKey, value);
                    this.attachAppStartSpans(appStartMetrics, transaction);
                    appStartMetrics.onAppStartSpansSent();
                }
                if ((appContext = transaction.getContexts().getApp()) == null) {
                    appContext = new App();
                    transaction.getContexts().setApp(appContext);
                }
                String appStartType = appStartMetrics.getAppStartType() == AppStartMetrics.AppStartType.COLD ? "cold" : "warm";
                appContext.setStartType(appStartType);
            }
            this.setContributingFlags(transaction);
            SentryId eventId = transaction.getEventId();
            SpanContext spanContext = transaction.getContexts().getTrace();
            if (eventId != null && spanContext != null && spanContext.getOperation().contentEquals("ui.load") && (framesMetrics = this.activityFramesTracker.takeMetrics(eventId)) != null) {
                transaction.getMeasurements().putAll(framesMetrics);
            }
            SentryTransaction sentryTransaction = transaction;
            return sentryTransaction;
        }
    }

    private void setContributingFlags(SentryTransaction transaction) {
        @Nullable SentrySpan ttidSpan = null;
        @Nullable SentrySpan ttfdSpan = null;
        for (SentrySpan span : transaction.getSpans()) {
            if ("ui.load.initial_display".equals(span.getOp())) {
                ttidSpan = span;
            } else if ("ui.load.full_display".equals(span.getOp())) {
                ttfdSpan = span;
            }
            if (ttidSpan == null || ttfdSpan == null) continue;
            break;
        }
        if (ttidSpan == null && ttfdSpan == null) {
            return;
        }
        for (SentrySpan span : transaction.getSpans()) {
            boolean withinTtfd;
            if (span == ttidSpan || span == ttfdSpan) continue;
            boolean spanOnMainThread = true;
            @Nullable Map spanData = span.getData();
            if (spanData != null) {
                @Nullable V threadName = spanData.get("thread.name");
                spanOnMainThread = threadName == null || "main".equals(threadName);
            }
            boolean withinTtid = ttidSpan != null && PerformanceAndroidEventProcessor.isTimestampWithinSpan(span.getStartTimestamp(), ttidSpan) && spanOnMainThread;
            boolean bl = withinTtfd = ttfdSpan != null && PerformanceAndroidEventProcessor.isTimestampWithinSpan(span.getStartTimestamp(), ttfdSpan);
            if (!withinTtid && !withinTtfd) continue;
            @Nullable ConcurrentHashMap<String, Boolean> data = span.getData();
            if (data == null) {
                data = new ConcurrentHashMap<String, Boolean>();
                span.setData(data);
            }
            if (withinTtid) {
                data.put("ui.contributes_to_ttid", true);
            }
            if (!withinTtfd) continue;
            data.put("ui.contributes_to_ttfd", true);
        }
    }

    private static boolean isTimestampWithinSpan(double timestamp, @NotNull SentrySpan target) {
        return timestamp >= target.getStartTimestamp() && (target.getTimestamp() == null || timestamp <= target.getTimestamp());
    }

    private boolean hasAppStartSpan(@NotNull SentryTransaction txn) {
        @NotNull List spans = txn.getSpans();
        for (SentrySpan span : spans) {
            if (!span.getOp().contentEquals("app.start.cold") && !span.getOp().contentEquals("app.start.warm")) continue;
            return true;
        }
        @Nullable SpanContext context = txn.getContexts().getTrace();
        return context != null && (context.getOperation().equals("app.start.cold") || context.getOperation().equals("app.start.warm"));
    }

    private void attachAppStartSpans(@NotNull AppStartMetrics appStartMetrics, @NotNull SentryTransaction txn) {
        TimeSpan appOnCreate;
        List<TimeSpan> contentProviderOnCreates;
        TimeSpan processInitTimeSpan;
        if (appStartMetrics.getAppStartType() != AppStartMetrics.AppStartType.COLD) {
            return;
        }
        @Nullable SpanContext traceContext = txn.getContexts().getTrace();
        if (traceContext == null) {
            return;
        }
        @NotNull SentryId traceId = traceContext.getTraceId();
        SpanId parentSpanId = null;
        @NotNull List spans = txn.getSpans();
        for (SentrySpan span : spans) {
            if (!span.getOp().contentEquals("app.start.cold")) continue;
            parentSpanId = span.getSpanId();
            break;
        }
        if ((processInitTimeSpan = appStartMetrics.createProcessInitSpan()).hasStarted() && Math.abs(processInitTimeSpan.getDurationMs()) <= 10000L) {
            txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(processInitTimeSpan, parentSpanId, traceId, APP_METRICS_PROCESS_INIT_OP));
        }
        if (!(contentProviderOnCreates = appStartMetrics.getContentProviderOnCreateTimeSpans()).isEmpty()) {
            for (TimeSpan contentProvider : contentProviderOnCreates) {
                txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(contentProvider, parentSpanId, traceId, APP_METRICS_CONTENT_PROVIDER_OP));
            }
        }
        if ((appOnCreate = appStartMetrics.getApplicationOnCreateTimeSpan()).hasStopped()) {
            txn.getSpans().add(PerformanceAndroidEventProcessor.timeSpanToSentrySpan(appOnCreate, parentSpanId, traceId, APP_METRICS_APPLICATION_OP));
        }
    }

    @NotNull
    private static SentrySpan timeSpanToSentrySpan(@NotNull TimeSpan span, @Nullable SpanId parentSpanId, @NotNull SentryId traceId, @NotNull String operation) {
        HashMap<String, Object> defaultSpanData = new HashMap<String, Object>(2);
        defaultSpanData.put("thread.id", AndroidThreadChecker.mainThreadSystemId);
        defaultSpanData.put("thread.name", "main");
        defaultSpanData.put("ui.contributes_to_ttid", true);
        defaultSpanData.put("ui.contributes_to_ttfd", true);
        return new SentrySpan(Double.valueOf(span.getStartTimestampSecs()), Double.valueOf(span.getProjectedStopTimestampSecs()), traceId, new SpanId(), parentSpanId, operation, span.getDescription(), SpanStatus.OK, APP_METRICS_ORIGIN, new ConcurrentHashMap(), new ConcurrentHashMap(), defaultSpanData);
    }

    @Nullable
    public Long getOrder() {
        return 9000L;
    }
}

